/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.entity.projectile.SmokeDecoyEntity;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.world.TDMSavedData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.TriPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeekTool {
    public static final Predicate<Entity> IS_ALIVE = Entity::isAlive;
    public static final Predicate<Entity> NOT_SPECTATOR = e -> {
        Player player;
        return !(e instanceof Player && (player = (Player)e).isSpectator());
    };
    public static final Predicate<Entity> IN_BLACKLIST = e -> e.getType().is(ModTags.EntityTypes.SEEK_BLACKLIST);
    public static final Predicate<Entity> BASIC_TYPE_FILTER = e -> !(e instanceof HangingEntity) && (!(e instanceof Projectile) || e.getType().is(ModTags.EntityTypes.DESTROYABLE_PROJECTILE));
    public static final Predicate<Entity> BASIC_FILTER = e -> IS_ALIVE.test((Entity)e) && NOT_SPECTATOR.test((Entity)e) && BASIC_TYPE_FILTER.test((Entity)e) && !IN_BLACKLIST.test((Entity)e);
    public static final BiPredicate<Entity, Double> ON_GROUND_HEIGHT = (entity, height) -> {
        Level level = entity.level();
        double y = entity.getY();
        int minY = level.getMinBuildHeight();
        int maxY = level.getMaxBuildHeight();
        if (y < (double)minY || y > (double)maxY) {
            return false;
        }
        boolean[] onGround = new boolean[]{false};
        AABB aabb = entity.getBoundingBox().expandTowards(0.0, -height.doubleValue(), 0.0);
        BlockPos.betweenClosedStream((AABB)aabb).forEach(pos -> {
            if (pos.getY() < minY || pos.getY() > maxY) {
                return;
            }
            BlockState state = level.getBlockState(pos);
            if (!state.isAir()) {
                onGround[0] = true;
            }
        });
        return entity.onGround() || entity.isInWater() || onGround[0];
    };
    public static final Predicate<Entity> ON_GROUND = e -> ON_GROUND_HEIGHT.test((Entity)e, 0.0);
    public static final TriPredicate<Entity, Double, Double> IN_HEIGHT_RANGE = (entity, min, max) -> {
        BlockState state;
        Level level = entity.level();
        BlockPos pos = entity.getOnPos();
        double y = pos.getY();
        int minY = level.getMinBuildHeight();
        int maxY = level.getMaxBuildHeight();
        if (y < (double)minY || y > (double)maxY) {
            return true;
        }
        int height = 0;
        do {
            if (++height >= minY && height <= maxY) continue;
            return false;
        } while ((state = level.getBlockState(pos.offset(0, -height, 0))).isAir());
        return (double)height >= min && (double)height <= max;
    };
    public static final BiPredicate<Entity, Entity> IN_SAME_TEAM = (self, target) -> {
        if (self == null || target == null) {
            return false;
        }
        return self == target || target.getTeam() != null && !TDMSavedData.enabledTDM(target) && target.getTeam() == self.getTeam();
    };
    public static final BiPredicate<Entity, Entity> IS_FRIENDLY_DRONE = (self, target) -> {
        DroneEntity drone;
        if (!(self instanceof Player)) {
            return false;
        }
        Player player = (Player)self;
        ItemStack stack = player.getMainHandItem();
        DroneEntity myDrone = null;
        CompoundTag tag = NBTTool.getTag(stack);
        if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked")) {
            myDrone = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"));
        }
        return target instanceof DroneEntity && (drone = (DroneEntity)target) != myDrone && drone.getController() != null && IN_SAME_TEAM.test((Entity)target, drone.getController());
    };
    public static final BiPredicate<Entity, Entity> IS_FRIENDLY = (self, target) -> {
        OwnableEntity ownableEntity;
        if (IN_SAME_TEAM.test((Entity)self, (Entity)target)) {
            return true;
        }
        if (target instanceof OwnableEntity && (ownableEntity = (OwnableEntity)target).getOwner() != null && IN_SAME_TEAM.test((Entity)self, (Entity)ownableEntity.getOwner())) {
            return true;
        }
        if (IS_FRIENDLY_DRONE.test((Entity)self, (Entity)target)) {
            return true;
        }
        List entities = target.getPassengers();
        for (Entity passenger : entities) {
            if (!IN_SAME_TEAM.test((Entity)self, passenger)) continue;
            return true;
        }
        if (target instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)target;
            Entity lastDriver = EntityFindUtil.findEntity(vehicle.level(), (String)vehicle.getEntityData().get(VehicleEntity.LAST_DRIVER_UUID));
            return lastDriver != null && IN_SAME_TEAM.test((Entity)self, lastDriver);
        }
        return false;
    };
    public static final Predicate<Entity> NOT_IN_SMOKE = e -> {
        AABB box = e.getBoundingBox().inflate(8.0);
        List entities = e.level().getEntities(EntityTypeTest.forClass(Entity.class), box, entity -> entity instanceof SmokeDecoyEntity && !(e instanceof SmokeDecoyEntity)).stream().toList();
        return entities.isEmpty();
    };
    public static final BiPredicate<Entity, Double> NOT_IN_SMOKE_WITH_RANGE = (e, range) -> {
        AABB box = e.getBoundingBox().inflate(range.doubleValue());
        List entities = e.level().getEntities(EntityTypeTest.forClass(Entity.class), box, entity -> entity instanceof SmokeDecoyEntity).stream().toList();
        return entities.isEmpty();
    };
    public static final BiPredicate<Entity, Entity> IS_OWNER = (self, target) -> {
        if (target instanceof TraceableEntity) {
            TraceableEntity traceableEntity = (TraceableEntity)target;
            return traceableEntity.getOwner() == self;
        }
        if (target instanceof OwnableEntity) {
            OwnableEntity ownableEntity = (OwnableEntity)target;
            return ownableEntity.getOwner() == self;
        }
        return false;
    };
    public static final BiPredicate<Entity, Entity> IS_NOT_OWNER = (self, target) -> {
        if (target instanceof TraceableEntity) {
            TraceableEntity traceableEntity = (TraceableEntity)target;
            return traceableEntity.getOwner() != self;
        }
        if (target instanceof OwnableEntity) {
            OwnableEntity ownableEntity = (OwnableEntity)target;
            return ownableEntity.getOwner() != self;
        }
        return true;
    };
    public static final Predicate<Entity> IS_INVULNERABLE = e -> {
        Player player;
        return e.isInvulnerable() || e instanceof Player && ((player = (Player)e).isCreative() || player.isSpectator());
    };

    @Deprecated(forRemoval=true)
    public static boolean baseFilter(Entity entity) {
        return BASIC_FILTER.test(entity);
    }

    @Deprecated(forRemoval=true)
    public static boolean smokeFilter(Entity pEntity) {
        return NOT_IN_SMOKE.test(pEntity);
    }

    @Deprecated(forRemoval=true)
    public static boolean friendlyToPlayer(Entity e, Entity entity) {
        return IS_FRIENDLY.test(e, entity);
    }

    @Deprecated(forRemoval=true)
    public static boolean teamFilter(Entity e, Entity entity) {
        return IN_SAME_TEAM.test(e, entity);
    }

    @Deprecated(forRemoval=true)
    public static Entity seekEntity(Entity entity, Level level, double seekRange, double seekAngle) {
        return SeekTool.seekEntity(entity, seekRange, seekAngle);
    }

    public static Entity seekEntity(Entity entity, double range, double angle) {
        return new Builder(entity).withinRange(range).withinAngle(angle).baseFilter().smokeFilter().noVehicle().noClip().buildWithClosest();
    }

    @Deprecated(forRemoval=true)
    public static Entity seekCustomSizeEntity(Entity entity, Level level, double seekRange, double seekAngle, double size, boolean checkOnGround) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> {
            if ((double)e.distanceTo(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && SeekTool.baseFilter(e) && (!checkOnGround || ON_GROUND_HEIGHT.test((Entity)e, 10.0)) && e.getBoundingBox().getSize() >= size && SeekTool.smokeFilter(e) && e.getVehicle() == null) {
                return level.clip(new ClipContext(entity.getEyePosition(), e.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() != HitResult.Type.BLOCK;
            }
            return false;
        }).min(Comparator.comparingDouble(e -> SeekTool.calculateAngle(e, entity))).orElse(null);
    }

    @Deprecated(forRemoval=true)
    public static Entity seekLivingEntity(Entity entity, Level level, double seekRange, double seekAngle) {
        return SeekTool.seekLivingEntity(entity, seekRange, seekAngle);
    }

    @Nullable
    public static Entity seekLivingEntity(@NotNull Entity entity, double range, double angle) {
        return new Builder(entity).withinRange(range).withinAngle(angle).baseFilter().smokeFilter().noVehicle().notFriendly().isNotOwner().noClip().buildWithClosest();
    }

    @Deprecated(forRemoval=true)
    public static List<Entity> seekLivingEntities(Entity entity, Level level, double seekRange, double seekAngle) {
        return SeekTool.seekLivingEntities(entity, seekRange, seekAngle);
    }

    public static List<Entity> seekLivingEntities(Entity entity, double seekRange, double seekAngle) {
        return new Builder(entity).withinRange(seekRange).withinAngle(seekAngle).baseFilter().smokeFilter().noVehicle().notFriendly().noClip().build();
    }

    @Deprecated(forRemoval=true)
    public static List<Entity> seekCustomSizeEntities(Entity entity, Level level, double seekRange, double seekAngle, double size, boolean checkOnGround) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> {
            if ((double)e.distanceTo(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && e.getBoundingBox().getSize() >= size && SeekTool.baseFilter(e) && (!checkOnGround || ON_GROUND_HEIGHT.test((Entity)e, 10.0)) && SeekTool.smokeFilter(e) && e.getVehicle() == null && !SeekTool.friendlyToPlayer(entity, e)) {
                return level.clip(new ClipContext(entity.getEyePosition(), e.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() != HitResult.Type.BLOCK;
            }
            return false;
        }).toList();
    }

    @Deprecated(forRemoval=true)
    public static List<Entity> seekLivingEntitiesThroughWall(Entity entity, Level level, double seekRange, double seekAngle) {
        return SeekTool.seekLivingEntitiesThroughWall(entity, seekRange, seekAngle);
    }

    public static List<Entity> seekLivingEntitiesThroughWall(Entity entity, double range, double angle) {
        return new Builder(entity).withinRange(range).withinAngle(angle).baseFilter().noVehicle().notFriendly().build();
    }

    @Deprecated(forRemoval=true)
    public static Entity seekEntityThroughWall(Entity entity, Level level, double seekRange, double seekAngle) {
        return SeekTool.seekEntityThroughWall(entity, seekRange, seekAngle);
    }

    @Nullable
    public static Entity seekEntityThroughWall(Entity entity, double range, double angle) {
        return new Builder(entity).withinRange(range).withinAngle(angle).baseFilter().noVehicle().notFriendly().buildWithClosest();
    }

    public static List<Entity> getEntitiesWithinRange(BlockPos pos, Level level, double range) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> e.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= range * range && BASIC_FILTER.test((Entity)e) && NOT_IN_SMOKE.test((Entity)e) && !e.getType().is(ModTags.EntityTypes.DECOY)).toList();
    }

    private static double calculateAngle(Entity entityA, Entity entityB) {
        Vec3 start = new Vec3(entityA.getX() - entityB.getX(), entityA.getY() - entityB.getY(), entityA.getZ() - entityB.getZ());
        Vec3 end = entityB.getLookAngle();
        return VectorTool.calculateAngle(start, end);
    }

    private static double calculateAngle(Vec3 pos, Vec3 vec3, Entity entityA) {
        Vec3 start = pos.vectorTo(entityA.position());
        return VectorTool.calculateAngle(start, vec3);
    }

    public static class Builder {
        @NotNull
        private final Entity entity;
        private final List<Predicate<Entity>> filters = new ArrayList<Predicate<Entity>>();

        public Builder(@NotNull Entity entity) {
            this(entity, true);
        }

        public Builder(@NotNull Entity entity, boolean excludeSelf) {
            this.entity = entity;
            if (excludeSelf) {
                this.filters.add(e -> e != this.entity);
            }
        }

        public List<Entity> build() {
            return StreamSupport.stream(EntityFindUtil.getEntities(this.entity.level()).getAll().spliterator(), false).filter(e -> {
                for (Predicate<Entity> f : this.filters) {
                    if (f.test((Entity)e)) continue;
                    return false;
                }
                return true;
            }).toList();
        }

        @Nullable
        public Entity buildWithClosest() {
            return StreamSupport.stream(EntityFindUtil.getEntities(this.entity.level()).getAll().spliterator(), false).filter(e -> {
                for (Predicate<Entity> f : this.filters) {
                    if (f.test((Entity)e)) continue;
                    return false;
                }
                return true;
            }).min(Comparator.comparingDouble(e -> SeekTool.calculateAngle(e, this.entity))).orElse(null);
        }

        @Nullable
        public Entity buildWithClosest(Vec3 pos, Vec3 vec3) {
            return StreamSupport.stream(EntityFindUtil.getEntities(this.entity.level()).getAll().spliterator(), false).filter(e -> {
                for (Predicate<Entity> f : this.filters) {
                    if (f.test((Entity)e)) continue;
                    return false;
                }
                return true;
            }).min(Comparator.comparingDouble(e -> SeekTool.calculateAngle(pos, vec3, e))).orElse(null);
        }

        public Builder notItsVehicle() {
            this.filters.add(e -> e.getVehicle() != this.entity);
            return this;
        }

        public Builder withinRange(double range) {
            this.filters.add(e -> e.position().distanceTo(this.entity.getEyePosition()) <= range);
            return this;
        }

        public Builder withinRange(Vec3 vec3, double range) {
            this.filters.add(e -> e.position().distanceTo(vec3) <= range);
            return this;
        }

        public Builder overRange(double range) {
            this.filters.add(e -> e.position().distanceTo(this.entity.getEyePosition()) >= range);
            return this;
        }

        public Builder sameTeam() {
            this.filters.add(e -> IN_SAME_TEAM.test(this.entity, (Entity)e));
            return this;
        }

        public Builder differentTeam() {
            this.filters.add(e -> !IN_SAME_TEAM.test(this.entity, (Entity)e));
            return this;
        }

        public Builder friendly() {
            this.filters.add(e -> IS_FRIENDLY.test(this.entity, (Entity)e));
            return this;
        }

        public Builder notFriendly() {
            this.filters.add(e -> !IS_FRIENDLY.test(this.entity, (Entity)e));
            return this;
        }

        public Builder blackList() {
            this.filters.add(IN_BLACKLIST);
            return this;
        }

        public Builder smokeFilter() {
            this.filters.add(NOT_IN_SMOKE);
            return this;
        }

        public Builder onGround(double height) {
            this.filters.add(e -> ON_GROUND_HEIGHT.test((Entity)e, height));
            return this;
        }

        public Builder baseFilter() {
            this.filters.add(BASIC_FILTER);
            return this;
        }

        public Builder withinAngle(double angle) {
            this.filters.add(e -> SeekTool.calculateAngle(e, this.entity) < angle);
            return this;
        }

        public Builder withinAngle(Vec3 pos, Vec3 vec3, double angle) {
            this.filters.add(e -> SeekTool.calculateAngle(pos, vec3, e) < angle);
            return this;
        }

        public Builder is(Class<? extends Entity> clazz) {
            this.filters.add(clazz::isInstance);
            return this;
        }

        public Builder isNot(Class<? extends Entity> clazz) {
            this.filters.add(e -> !clazz.isInstance(e));
            return this;
        }

        public Builder is(TagKey<EntityType<?>> tagKey) {
            this.filters.add(e -> e.getType().is(tagKey));
            return this;
        }

        public Builder isNot(TagKey<EntityType<?>> tagKey) {
            this.filters.add(e -> !e.getType().is(tagKey));
            return this;
        }

        public Builder isOwner() {
            this.filters.add(e -> IS_OWNER.test(this.entity, (Entity)e));
            return this;
        }

        public Builder isNotOwner() {
            this.filters.add(e -> IS_NOT_OWNER.test(this.entity, (Entity)e));
            return this;
        }

        public Builder noClip() {
            this.filters.add(e -> this.entity.level().clip(new ClipContext(this.entity.getEyePosition(), e.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.entity)).getType() != HitResult.Type.BLOCK);
            return this;
        }

        public Builder vehicleNoClip(Entity entity) {
            this.filters.add(e -> {
                Entity patt0$temp = this.entity;
                if (patt0$temp instanceof VehicleEntity) {
                    VehicleEntity vehicle = (VehicleEntity)patt0$temp;
                    return this.entity.level().clip(new ClipContext(vehicle.getZoomPos(entity, 1.0f), vehicle.getZoomPos(entity, 1.0f), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)vehicle)).getType() != HitResult.Type.BLOCK;
                }
                return false;
            });
            return this;
        }

        public Builder hasVehicle() {
            this.filters.add(e -> e.getVehicle() != null);
            return this;
        }

        public Builder noVehicle() {
            this.filters.add(e -> e.getVehicle() == null);
            return this;
        }

        public Builder sizeBiggerThan(double size) {
            this.filters.add(e -> e.getBoundingBox().getSize() >= size);
            return this;
        }

        public Builder sizeGreaterThan(double size) {
            this.filters.add(e -> e.getBoundingBox().getSize() >= size);
            return this;
        }

        public Builder custom(Predicate<Entity> predicate) {
            this.filters.add(predicate);
            return this;
        }

        public Builder custom(BiPredicate<Entity, Entity> predicate) {
            this.filters.add(e -> predicate.test(this.entity, (Entity)e));
            return this;
        }

        public Builder heightRange(double min, double max) {
            this.filters.add(e -> IN_HEIGHT_RANGE.test(e, (Object)min, (Object)max));
            return this;
        }
    }
}

