/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.network.message.receive.SoundClientMessage;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class SoundTool {
    public static void playLocalSound(Player player, SoundEvent sound) {
        SoundTool.playLocalSound(player, sound, 1.0f, 1.0f);
    }

    public static void playLocalSound(Player player, SoundEvent sound, float volume, float pitch) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, sound, volume, pitch);
        }
    }

    public static void playLocalSound(ServerPlayer player, SoundEvent sound) {
        SoundTool.playLocalSound(player, sound, 1.0f, 1.0f);
    }

    public static void playLocalSound(ServerPlayer player, SoundEvent sound, float volume, float pitch) {
        SoundTool.playLocalSound(player, sound, SoundSource.PLAYERS, volume, pitch);
    }

    public static void playLocalSound(ServerPlayer player, SoundEvent sound, SoundSource source, float volume, float pitch) {
        player.connection.send((Packet)new ClientboundSoundPacket((Holder)new Holder.Direct((Object)sound), source, player.getX(), player.getY(), player.getZ(), volume, pitch, player.level().random.nextLong()));
    }

    public static void stopSound(ServerPlayer player, ResourceLocation sound) {
        SoundTool.stopSound(player, sound, SoundSource.PLAYERS);
    }

    public static void stopSound(ServerPlayer player, ResourceLocation sound, SoundSource source) {
        player.connection.send((Packet)new ClientboundStopSoundPacket(sound, source));
    }

    public static void playDistantSound(ServerLevel serverLevel, SoundEvent soundEvent, Vec3 pos, float radius, float pitch, Entity sender) {
        List players = serverLevel.getPlayers(p -> p.distanceToSqr(pos) < (double)(radius * radius * 256.0f));
        for (ServerPlayer serverPlayer : players) {
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SoundClientMessage(soundEvent.getLocation(), pos.toVector3f(), radius, pitch, sender == null ? UUID.randomUUID() : sender.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

