/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.SeekTool;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;

public class TraceTool {
    public static Entity findLookingEntity(Entity entity, double entityReach) {
        AABB aabb;
        double blockReach;
        double distance = entityReach * entityReach;
        Vec3 eyePos = entity.getEyePosition(1.0f);
        HitResult hitResult = entity.pick(entityReach, 1.0f, false);
        if (hitResult.getType() != HitResult.Type.MISS && (distance = hitResult.getLocation().distanceToSqr(eyePos)) > (blockReach = 5.0) * blockReach) {
            Vec3 pos = hitResult.getLocation();
            hitResult = BlockHitResult.miss((Vec3)pos, (Direction)Direction.getNearest((double)eyePos.x, (double)eyePos.y, (double)eyePos.z), (BlockPos)BlockPos.containing((Position)pos));
        }
        Vec3 viewVec = entity.getViewVector(1.0f);
        Vec3 toVec = eyePos.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)eyePos, (Vec3)toVec, (AABB)(aabb = entity.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0)), p -> !p.isSpectator() && entity.getVehicle() != p && p.isAlive() && SeekTool.NOT_IN_SMOKE.test((Entity)p), (double)distance);
        if (entityhitresult != null) {
            Vec3 targetPos = entityhitresult.getLocation();
            double distanceToTarget = eyePos.distanceToSqr(targetPos);
            if (distanceToTarget > distance || distanceToTarget > entityReach * entityReach) {
                hitResult = BlockHitResult.miss((Vec3)targetPos, (Direction)Direction.getNearest((double)viewVec.x, (double)viewVec.y, (double)viewVec.z), (BlockPos)BlockPos.containing((Position)targetPos));
            } else if (distanceToTarget < distance) {
                hitResult = entityhitresult;
            }
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).getEntity();
        }
        return null;
    }

    public static Entity findMeleeEntity(Entity entity, double entityReach) {
        AABB aabb;
        double distance = entityReach * entityReach;
        Vec3 eyePos = entity.getEyePosition(1.0f);
        HitResult hitResult = entity.pick(entityReach, 1.0f, false);
        Vec3 viewVec = entity.getViewVector(1.0f);
        Vec3 toVec = eyePos.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)eyePos, (Vec3)toVec, (AABB)(aabb = entity.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0)), p -> !p.isSpectator() && entity.getVehicle() != p && p.isAlive(), (double)distance);
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).getEntity();
        }
        return null;
    }

    public static Vec3 vehicleFindLookingPos(Entity shooter, VehicleEntity vehicle, Vec3 eye, double entityReach, float partialTick) {
        AABB aabb;
        double distance = entityReach * entityReach;
        HitResult hitResult = TraceTool.pickNew(eye, 512.0, vehicle);
        Vec3 viewVec = vehicle.getViewVec(shooter, partialTick);
        Vec3 toVec = eye.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)vehicle, (Vec3)eye, (Vec3)toVec, (AABB)(aabb = vehicle.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0)), p -> !p.isSpectator() && p.isAlive() && SeekTool.BASIC_FILTER.test((Entity)p) && !p.getType().is(ModTags.EntityTypes.DECOY) && SeekTool.NOT_IN_SMOKE.test((Entity)p) && p != shooter && !(p instanceof Projectile), (double)distance);
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            return hitResult.getLocation();
        }
        return null;
    }

    public static Vec3 playerFindLookingPos(Entity pEntity, Entity entity, double entityReach) {
        double distance = entityReach * entityReach;
        HitResult hitResult = pEntity.pick(entityReach, 1.0f, false);
        Vec3 viewVec = pEntity.getViewVector(1.0f);
        Vec3 toVec = pEntity.getEyePosition().add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach);
        AABB aabb = entity.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Level)pEntity.level(), (Entity)pEntity, (Vec3)pEntity.getEyePosition(), (Vec3)toVec, (AABB)aabb, p -> true, (float)((float)distance));
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            return hitResult.getLocation();
        }
        return null;
    }

    public static Entity droneFindLookingEntity(Entity entity, Vec3 pos, double entityReach, float ticks) {
        AABB aabb;
        double distance = entityReach * entityReach;
        HitResult hitResult = entity.pick(entityReach, 1.0f, false);
        Vec3 viewVec = entity.getViewVector(ticks);
        Vec3 toVec = pos.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)pos, (Vec3)toVec, (AABB)(aabb = entity.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0)), p -> !p.isSpectator() && p.isAlive() && !(p instanceof Projectile) && SeekTool.BASIC_FILTER.test((Entity)p) && !p.getType().is(ModTags.EntityTypes.DECOY) && SeekTool.NOT_IN_SMOKE.test((Entity)p) && p != entity && p != entity.getVehicle(), (double)distance);
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).getEntity();
        }
        return null;
    }

    public static Entity camerafFindLookingEntity(Player player, Vec3 pos, Vec3 viewVec, double entityReach) {
        AABB aabb;
        Vec3 toVec;
        EntityHitResult entityhitresult;
        double blockReach;
        double distance = entityReach * entityReach;
        HitResult hitResult = TraceTool.pickNew(pos, entityReach, viewVec, (Entity)player);
        if (hitResult.getType() != HitResult.Type.MISS && (distance = hitResult.getLocation().distanceToSqr(pos)) > (blockReach = 5.0) * blockReach) {
            hitResult = BlockHitResult.miss((Vec3)hitResult.getLocation(), (Direction)Direction.getNearest((double)pos.x, (double)pos.y, (double)pos.z), (BlockPos)BlockPos.containing((Position)hitResult.getLocation()));
        }
        if ((entityhitresult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)pos, (Vec3)(toVec = pos.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach)), (AABB)(aabb = player.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0)), p -> !p.isSpectator() && p.isAlive() && !(p instanceof Projectile) && SeekTool.BASIC_FILTER.test((Entity)p) && !p.getType().is(ModTags.EntityTypes.DECOY) && SeekTool.NOT_IN_SMOKE.test((Entity)p) && p != player && p != player.getVehicle(), (double)distance)) != null) {
            Vec3 targetPos = entityhitresult.getLocation();
            double distanceToTarget = pos.distanceToSqr(targetPos);
            if (distanceToTarget > distance || distanceToTarget > entityReach * entityReach) {
                hitResult = BlockHitResult.miss((Vec3)targetPos, (Direction)Direction.getNearest((double)viewVec.x, (double)viewVec.y, (double)viewVec.z), (BlockPos)BlockPos.containing((Position)targetPos));
            } else if (distanceToTarget < distance) {
                hitResult = entityhitresult;
            }
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).getEntity();
        }
        return null;
    }

    public static Entity findLookDecoy(Player player, Vec3 pos, Vec3 viewVec, double entityReach) {
        AABB aabb;
        Vec3 toVec;
        EntityHitResult entityhitresult;
        double blockReach;
        double distance = entityReach * entityReach;
        HitResult hitResult = TraceTool.pickNew(pos, entityReach, viewVec, (Entity)player);
        if (hitResult.getType() != HitResult.Type.MISS && (distance = hitResult.getLocation().distanceToSqr(pos)) > (blockReach = 5.0) * blockReach) {
            hitResult = BlockHitResult.miss((Vec3)hitResult.getLocation(), (Direction)Direction.getNearest((double)pos.x, (double)pos.y, (double)pos.z), (BlockPos)BlockPos.containing((Position)hitResult.getLocation()));
        }
        if ((entityhitresult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)pos, (Vec3)(toVec = pos.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach)), (AABB)(aabb = player.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(2.0)), p -> p.getType().is(ModTags.EntityTypes.DECOY), (double)distance)) != null) {
            Vec3 targetPos = entityhitresult.getLocation();
            double distanceToTarget = pos.distanceToSqr(targetPos);
            if (distanceToTarget > distance || distanceToTarget > entityReach * entityReach) {
                hitResult = BlockHitResult.miss((Vec3)targetPos, (Direction)Direction.getNearest((double)viewVec.x, (double)viewVec.y, (double)viewVec.z), (BlockPos)BlockPos.containing((Position)targetPos));
            } else if (distanceToTarget < distance) {
                hitResult = entityhitresult;
            }
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).getEntity();
        }
        return null;
    }

    public static HitResult pickNew(Vec3 pos, double pHitDistance, VehicleEntity vehicle) {
        Vec3 vec31 = vehicle.getBarrelVector(1.0f);
        Vec3 vec32 = pos.add(vec31.x * pHitDistance, vec31.y * pHitDistance, vec31.z * pHitDistance);
        return vehicle.level().clip(new ClipContext(pos, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)vehicle));
    }

    public static HitResult pickNew(Vec3 pos, double pHitDistance, Vec3 viewVec, Entity entity) {
        Vec3 vec32 = pos.add(viewVec.x * pHitDistance, viewVec.y * pHitDistance, viewVec.z * pHitDistance);
        return entity.level().clip(new ClipContext(pos, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, entity));
    }

    public static List<BlockPos> getBlocksAlongRay(Vec3 start, Vec3 direction, double maxDistance) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        Vec3 normalizedDir = direction.normalize();
        double step = 0.1;
        BlockPos lastPos = null;
        for (double distance = 0.0; distance <= maxDistance; distance += step) {
            Vec3 currentPos = start.add(normalizedDir.scale(distance));
            BlockPos blockPos = new BlockPos((int)Math.floor(currentPos.x), (int)Math.floor(currentPos.y), (int)Math.floor(currentPos.z));
            if (lastPos != null && lastPos.equals((Object)blockPos)) continue;
            blocks.add(blockPos);
            lastPos = blockPos;
        }
        return blocks;
    }

    public static List<RayTraceResultEntity> getEntitiesAlongVector(Level world, Vec3 start, Vec3 direction, double maxDistance, Predicate<Entity> filterPredicate) {
        ArrayList<RayTraceResultEntity> hitEntities = new ArrayList<RayTraceResultEntity>();
        Vec3 normalizedDirection = direction.normalize();
        Vec3 end = start.add(normalizedDirection.scale(maxDistance));
        AABB rayBoundingBox = new AABB(start, end).inflate(1.0);
        List entitiesInWorld = world.getEntities((Entity)null, rayBoundingBox, filterPredicate);
        for (Entity entity : entitiesInWorld) {
            if (entity instanceof PartEntity) continue;
            AABB entityBoundingBox = entity.getBoundingBox();
            Double distanceToHit = TraceTool.rayIntersectsAABB(start, normalizedDirection, entityBoundingBox = entityBoundingBox.inflate(0.3), maxDistance);
            if (distanceToHit == null) continue;
            Vec3 hitVec = start.add(normalizedDirection.scale(distanceToHit.doubleValue()));
            hitEntities.add(new RayTraceResultEntity(entity, distanceToHit, hitVec));
        }
        hitEntities.sort(Comparator.comparingDouble(o -> o.distance));
        return hitEntities;
    }

    private static Double rayIntersectsAABB(Vec3 start, Vec3 dir, AABB box, double maxDist) {
        double tMin = 0.0;
        double tMax = maxDist;
        double invDx = 1.0 / dir.x;
        double t0x = (box.minX - start.x) * invDx;
        double t1x = (box.maxX - start.x) * invDx;
        if (invDx < 0.0) {
            double temp = t0x;
            t0x = t1x;
            t1x = temp;
        }
        tMin = Math.max(tMin, t0x);
        if ((tMax = Math.min(tMax, t1x)) <= tMin) {
            return null;
        }
        double invDy = 1.0 / dir.y;
        double t0y = (box.minY - start.y) * invDy;
        double t1y = (box.maxY - start.y) * invDy;
        if (invDy < 0.0) {
            double temp = t0y;
            t0y = t1y;
            t1y = temp;
        }
        tMin = Math.max(tMin, t0y);
        if ((tMax = Math.min(tMax, t1y)) <= tMin) {
            return null;
        }
        double invDz = 1.0 / dir.z;
        double t0z = (box.minZ - start.z) * invDz;
        double t1z = (box.maxZ - start.z) * invDz;
        if (invDz < 0.0) {
            double temp = t0z;
            t0z = t1z;
            t1z = temp;
        }
        tMin = Math.max(tMin, t0z);
        if ((tMax = Math.min(tMax, t1z)) <= tMin) {
            return null;
        }
        return tMin;
    }

    public static class RayTraceResultEntity {
        public final Entity entity;
        public final double distance;
        public final Vec3 hitVec;

        public RayTraceResultEntity(Entity entity, double distance, Vec3 hitVec) {
            this.entity = entity;
            this.distance = distance;
            this.hitVec = hitVec;
        }

        public String toString() {
            return "RayTraceResultEntity{entity=" + String.valueOf(this.entity) + ", distance=" + this.distance + ", hitVec=" + String.valueOf(this.hitVec) + "}";
        }
    }
}

