/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.world;

import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.network.message.receive.TDMSyncMessage;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class TDMSavedData
extends SavedData {
    public static final String FILE_ID = "superbwarfare_tdm";
    private final Set<String> entities = Sets.newHashSet();

    public TDMSavedData() {
    }

    public TDMSavedData(Collection<String> entities) {
        this.entities.addAll(entities);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("Entities", (Tag)this.saveEntities());
        return tag;
    }

    public static TDMSavedData load(CompoundTag pCompoundTag, HolderLookup.Provider registries) {
        TDMSavedData tdmSavedData = new TDMSavedData();
        if (pCompoundTag.contains("Entities", 9)) {
            tdmSavedData.loadEntities(pCompoundTag.getList("Entities", 8));
        }
        return tdmSavedData;
    }

    private ListTag saveEntities() {
        ListTag listtag = new ListTag();
        for (String s : this.entities) {
            listtag.add((Object)StringTag.valueOf((String)s));
        }
        return listtag;
    }

    private void loadEntities(ListTag pTagList) {
        for (int i = 0; i < pTagList.size(); ++i) {
            this.entities.add(pTagList.getString(i));
        }
    }

    public Set<String> getEntities() {
        return this.entities;
    }

    public boolean addEntity(String entity) {
        return this.entities.add(entity);
    }

    public boolean removeEntity(String entity) {
        return this.entities.remove(entity);
    }

    public boolean containsEntity(String entity) {
        return this.entities.contains(entity);
    }

    public void sync() {
        this.setDirty();
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new TDMSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static boolean enabledTDM(Entity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return ((TDMSavedData)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(TDMSavedData::new, TDMSavedData::load, null), FILE_ID)).containsEntity(entity.getStringUUID());
        }
        return ClientEventHandler.tdmSavedData.containsEntity(entity.getStringUUID());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (!(player2 instanceof ServerPlayer) || !((player2 = (player = (ServerPlayer)player2).level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)player2;
        TDMSavedData data = (TDMSavedData)level.getDataStorage().get(new SavedData.Factory(TDMSavedData::new, TDMSavedData::load, null), FILE_ID);
        if (data == null) {
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new TDMSyncMessage(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

