/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.block.ContainerBlock;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ContainerBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    public EntityType<?> entityType;
    public CompoundTag entityTag = null;
    public int tick = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ContainerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CONTAINER.get(), pos, state);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, ContainerBlockEntity blockEntity) {
        if (!((Boolean)pState.m_61143_((Property)ContainerBlock.OPENED)).booleanValue()) {
            return;
        }
        if (blockEntity.tick < 20) {
            ++blockEntity.tick;
            blockEntity.m_6596_();
            if (blockEntity.tick == 18) {
                ParticleTool.sendParticle((ServerLevel)pLevel, ParticleTypes.f_123813_, pPos.m_123341_(), pPos.m_123342_() + 1, pPos.m_123343_(), 40, 1.5, 1.5, 1.5, 1.0, false);
                pLevel.m_5594_(null, pPos, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (pLevel.f_46441_.m_188501_() - pLevel.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            }
        } else {
            Direction direction = (Direction)pState.m_61143_((Property)ContainerBlock.FACING);
            Entity entity = blockEntity.entityType.m_20615_(pLevel);
            if (entity == null) {
                return;
            }
            if (blockEntity.entityTag != null) {
                entity.m_20258_(blockEntity.entityTag);
            }
            entity.m_6034_((double)pPos.m_123341_() + 0.5 + (2.0 * Math.random() - 1.0) * (double)0.1f, (double)pPos.m_123342_() + 0.5 + (2.0 * Math.random() - 1.0) * (double)0.1f, (double)pPos.m_123343_() + 0.5 + (2.0 * Math.random() - 1.0) * (double)0.1f);
            entity.m_146922_(direction.m_122435_());
            pLevel.m_7967_(entity);
            pLevel.m_46597_(pPos, Blocks.f_50016_.m_49966_());
        }
    }

    private PlayState predicate(AnimationState<ContainerBlockEntity> event) {
        if (((Boolean)this.m_58900_().m_61143_((Property)ContainerBlock.OPENED)).booleanValue()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.container.open"));
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("EntityType")) {
            this.entityType = EntityType.m_20632_((String)compound.m_128461_("EntityType")).orElse(null);
        }
        if (compound.m_128441_("Entity")) {
            this.entityTag = compound.m_128469_("Entity");
        }
        this.tick = compound.m_128451_("Tick");
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        if (this.entityTag != null) {
            compound.m_128365_("Entity", (Tag)this.entityTag);
        }
        if (this.entityType != null) {
            compound.m_128359_("EntityType", EntityType.m_20613_(this.entityType).toString());
        }
        compound.m_128405_("Tick", this.tick);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void m_187476_(@NotNull ItemStack pStack) {
        CompoundTag tag = new CompoundTag();
        if (this.entityType != null) {
            tag.m_128359_("EntityType", EntityType.m_20613_(this.entityType).toString());
        }
        BlockItem.m_186338_((ItemStack)pStack, (BlockEntityType)this.m_58903_(), (CompoundTag)tag);
    }
}

