/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.block.SuperbItemInterfaceBlock;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.menu.SuperbItemInterfaceMenu;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuperbItemInterfaceBlockEntity
extends BaseContainerBlockEntity {
    public static final int TRANSFER_COOLDOWN = 20;
    public static final int CONTAINER_SIZE = 5;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int cooldownTime = -1;

    public SuperbItemInterfaceBlockEntity(BlockEntityType<?> type, BlockPos pPos, BlockState pBlockState) {
        super(type, pPos, pBlockState);
    }

    public SuperbItemInterfaceBlockEntity(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)ModBlockEntities.SUPERB_ITEM_INTERFACE.get(), pPos, pBlockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SuperbItemInterfaceBlockEntity blockEntity) {
        int z;
        int y;
        --blockEntity.cooldownTime;
        if (blockEntity.isOnCooldown()) {
            return;
        }
        blockEntity.setCooldown(20);
        if (blockEntity.m_7983_()) {
            return;
        }
        if (!((Boolean)state.m_61143_((Property)SuperbItemInterfaceBlock.ENABLED)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)SuperbItemInterfaceBlock.FACING);
        int x = pos.m_123341_() + facing.m_122429_();
        List list = level.m_6249_((Entity)null, new AABB((double)x - 0.5, (double)(y = pos.m_123342_() + facing.m_122430_()) - 0.5, (double)(z = pos.m_123343_() + facing.m_122431_()) - 0.5, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5), entity -> entity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent());
        if (list.isEmpty()) {
            return;
        }
        Entity target = (Entity)list.get(level.f_46441_.m_188503_(list.size()));
        for (int i = 0; i < blockEntity.items.size(); ++i) {
            ItemStack stack = (ItemStack)blockEntity.items.get(i);
            if (stack.m_41619_()) continue;
            ItemStack originalStack = stack.m_41777_();
            IItemHandler itemHandler = (IItemHandler)target.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().get();
            int totalInserted = 0;
            for (int ii = 0; ii < itemHandler.getSlots(); ++ii) {
                ItemStack insertedStack;
                int inserted;
                for (inserted = stack.m_41613_(); inserted > 0 && (insertedStack = itemHandler.insertItem(ii, stack.m_255036_(inserted), true)).m_41613_() == inserted && ItemStack.m_150942_((ItemStack)insertedStack, (ItemStack)stack); --inserted) {
                }
                if (inserted <= 0) continue;
                itemHandler.insertItem(ii, stack.m_255036_(inserted), false);
                stack.m_41774_(inserted);
                totalInserted += inserted;
            }
            if (!blockEntity.isCreative()) {
                blockEntity.items.set(i, (Object)stack);
                blockEntity.m_6596_();
            } else {
                blockEntity.items.set(i, (Object)originalStack);
            }
            if (totalInserted > 0) break;
        }
    }

    protected boolean isCreative() {
        return false;
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        this.cooldownTime = pTag.m_128451_("TransferCooldown");
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
        pTag.m_128405_("TransferCooldown", this.cooldownTime);
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.superbwarfare.superb_item_interface");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int pContainerId, @NotNull Inventory pInventory) {
        return new SuperbItemInterfaceMenu(pContainerId, pInventory, (Container)this);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    @NotNull
    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    @NotNull
    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.items, (int)pSlot, (int)pAmount);
    }

    @NotNull
    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.items, (int)pSlot);
    }

    public void m_6836_(int pSlot, @NotNull ItemStack pStack) {
        this.items.set(pSlot, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(@NotNull Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void setCooldown(int pCooldownTime) {
        this.cooldownTime = pCooldownTime;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> new InvWrapper((Container)this)));
    }
}

