/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.capability;

import com.atsuishio.superbwarfare.capability.LaserCapability;
import com.atsuishio.superbwarfare.capability.ModCapabilities;
import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.data.gun.Ammo;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.PlayerVariablesSyncMessage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class CapabilityHandler {
    @SubscribeEvent
    public static void registerCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(LaserCapability.ID, CapabilityHandler.createProvider(LazyOptional.of(LaserCapability.LaserCapabilityImpl::new), ModCapabilities.LASER_CAPABILITY));
            if (!(player instanceof FakePlayer)) {
                event.addCapability(PlayerVariable.ID, CapabilityHandler.createProvider(LazyOptional.of(PlayerVariable::new), ModCapabilities.PLAYER_VARIABLE));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage(player2.m_19879_(), PlayerVariable.getOrDefault((Entity)player2).compareAndUpdate()));
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage(player2.m_19879_(), PlayerVariable.getOrDefault((Entity)player2).compareAndUpdate()));
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage(player2.m_19879_(), PlayerVariable.getOrDefault((Entity)player2).forceUpdate()));
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        event.getOriginal().revive();
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        PlayerVariable original = PlayerVariable.getOrDefault((Entity)event.getOriginal());
        PlayerVariable clone = (PlayerVariable)event.getEntity().getCapability(ModCapabilities.PLAYER_VARIABLE, null).orElse((Object)new PlayerVariable());
        for (Ammo type : Ammo.values()) {
            type.set(clone, type.get(original));
        }
        clone.tacticalSprint = original.tacticalSprint;
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        Player player = event.getEntity();
        ((PlayerVariable)player.getCapability(ModCapabilities.PLAYER_VARIABLE, null).orElse((Object)new PlayerVariable())).sync((Entity)player);
    }

    public static <T extends INBTSerializable<CompoundTag>> ICapabilitySerializable<CompoundTag> createProvider(final LazyOptional<T> instance, final Capability<T> capability) {
        return new ICapabilitySerializable<CompoundTag>(){

            @NotNull
            public <C> LazyOptional<C> getCapability(@NotNull Capability<C> cap, @Nullable Direction side) {
                return capability.orEmpty(cap, instance.cast());
            }

            public CompoundTag serializeNBT() {
                return (CompoundTag)((INBTSerializable)instance.orElseThrow(NullPointerException::new)).serializeNBT();
            }

            public void deserializeNBT(CompoundTag nbt) {
                ((INBTSerializable)instance.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
            }
        };
    }
}

