/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.capability.energy;

import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraftforge.energy.EnergyStorage;

public class SyncedEntityEnergyStorage
extends EnergyStorage {
    protected SynchedEntityData entityData;
    protected EntityDataAccessor<Integer> energyDataAccessor;

    public SyncedEntityEnergyStorage(int capacity, SynchedEntityData data, EntityDataAccessor<Integer> energyDataAccessor) {
        this(capacity, capacity, capacity, data, energyDataAccessor);
    }

    public SyncedEntityEnergyStorage(int capacity, int maxReceive, int maxExtract, SynchedEntityData data, EntityDataAccessor<Integer> energyDataAccessor) {
        super(capacity, maxReceive, maxExtract, 0);
        this.entityData = data;
        this.energyDataAccessor = energyDataAccessor;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = super.receiveEnergy(maxReceive, simulate);
        if (!simulate) {
            this.entityData.m_135381_(this.energyDataAccessor, (Object)this.energy);
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = super.extractEnergy(maxExtract, simulate);
        if (!simulate) {
            this.entityData.m_135381_(this.energyDataAccessor, (Object)this.energy);
        }
        return extracted;
    }

    public int getEnergyStored() {
        return (Integer)this.entityData.m_135370_(this.energyDataAccessor);
    }

    public void deserializeNBT(Tag nbt) {
        super.deserializeNBT(nbt);
        this.entityData.m_135381_(this.energyDataAccessor, (Object)this.energy);
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        this.entityData.m_135381_(this.energyDataAccessor, (Object)energy);
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }
}

