/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class JavelinHudOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_javelin_hud";
    private static final ResourceLocation FRAME = Mod.loc("textures/overlay/frame/frame.png");
    private static final ResourceLocation FRAME_TARGET = Mod.loc("textures/overlay/frame/frame_target_triangle.png");
    private static final ResourceLocation FRAME_LOCK = Mod.loc("textures/overlay/frame/frame_lock.png");
    private static final ResourceLocation JAVELIN_HUD = Mod.loc("textures/overlay/javelin/javelin_hud.png");
    private static final ResourceLocation TOP = Mod.loc("textures/overlay/javelin/top.png");
    private static final ResourceLocation DIR = Mod.loc("textures/overlay/javelin/dir.png");
    private static final ResourceLocation MISSILE_GREEN = Mod.loc("textures/overlay/javelin/missile_green.png");
    private static final ResourceLocation MISSILE_RED = Mod.loc("textures/overlay/javelin/missile_red.png");
    private static final ResourceLocation SEEK = Mod.loc("textures/overlay/javelin/seek.png");
    private static float scopeScale = 1.0f;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        VehicleEntity vehicle;
        LocalPlayer player = gui.getMinecraft().f_91074_;
        PoseStack poseStack = guiGraphics.m_280168_();
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (ClientEventHandler.isEditing) {
            return;
        }
        Entity entity = player.m_20202_();
        if (entity instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).banHand((LivingEntity)player)) {
            return;
        }
        if (stack.m_41720_() == ModItems.JAVELIN.get() && ClientEventHandler.zoomPos > 0.8 && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && ClientEventHandler.zoom) {
            GunData data = GunData.from(stack);
            poseStack.m_85836_();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float deltaFrame = Minecraft.m_91087_().m_91297_();
            float moveX = (float)(-32.0 * ClientEventHandler.turnRot[1] - (double)(player.m_20142_() ? 100 : 67) * ClientEventHandler.movePosX + 3.0 * ClientEventHandler.cameraRot[2]);
            float moveY = (float)(-32.0 * ClientEventHandler.turnRot[0] + (double)(100.0f * (float)ClientEventHandler.velocityY) - (double)(player.m_20142_() ? 100 : 67) * ClientEventHandler.movePosY - 12.0 * ClientEventHandler.firePos + 3.0 * ClientEventHandler.cameraRot[1]);
            scopeScale = (float)Mth.m_14139_((double)(0.5f * deltaFrame), (double)scopeScale, (double)((double)1.35f + (double)0.2f * ClientEventHandler.firePos));
            float f = Math.min(screenWidth, screenHeight);
            float f1 = Math.min((float)screenWidth / f, (float)screenHeight / f) * scopeScale;
            float i = Mth.m_14143_((float)(f * f1));
            float j = Mth.m_14143_((float)(f * f1));
            float k = ((float)screenWidth - i) / 2.0f + moveX;
            float l = ((float)screenHeight - j) / 2.0f + moveY;
            float i1 = k + i;
            float j1 = l + j;
            RenderHelper.preciseBlit(guiGraphics, JAVELIN_HUD, k, l, 0.0f, 0.0f, i, j, i, j);
            RenderHelper.preciseBlit(guiGraphics, data.selectedFireModeInfo().name.equals("Top") ? TOP : DIR, k, l, 0.0f, 0.0f, i, j, i, j);
            RenderHelper.preciseBlit(guiGraphics, data.hasEnoughAmmoToShoot((Entity)player) ? MISSILE_GREEN : MISSILE_RED, k, l, 0.0f, 0.0f, i, j, i, j);
            if (stack.m_41784_().m_128451_("SeekTime") > 1 && stack.m_41784_().m_128451_("SeekTime") < 20) {
                RenderHelper.preciseBlit(guiGraphics, SEEK, k, l, 0.0f, 0.0f, i, j, i, j);
            }
            guiGraphics.m_285795_(RenderType.m_286086_(), 0, (int)l, (int)k + 3, (int)j1, -90, -16777216);
            guiGraphics.m_285795_(RenderType.m_286086_(), (int)i1, (int)l, screenWidth, (int)j1, -90, -16777216);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft mc = Minecraft.m_91087_();
            Camera camera = mc.f_91063_.m_109153_();
            Vec3 cameraPos = camera.m_90583_();
            Entity decoy = TraceTool.findLookDecoy((Player)player, cameraPos, player.m_20252_(partialTick), 512.0);
            if (decoy == null) {
                Entity targetEntity = ClientEventHandler.lockingEntity;
                List<Entity> entities = new SeekTool.Builder((Entity)player).withinRange(data.compute().seekRange).withinAngle(data.compute().seekAngle).baseFilter().heightRange(data.compute().minTargetHeight, data.compute().maxTargetHeight).smokeFilter().noVehicle().noClip().notFriendly().build();
                Entity nearestEntity = ClientEventHandler.nearestEntity;
                if (ClientEventHandler.guideType == 0) {
                    for (Entity e : entities) {
                        Vec3 pos = VectorTool.lerpGetEntityBoundingBoxCenter(e, partialTick);
                        Vec3 point = VectorUtil.worldToScreen(pos);
                        boolean lockOn = ClientEventHandler.lockOn && e == targetEntity;
                        boolean nearest = e == nearestEntity;
                        poseStack.m_85836_();
                        float x = (float)point.f_82479_;
                        float y = (float)point.f_82480_;
                        RenderHelper.blit(poseStack, lockOn ? FRAME_LOCK : (nearest ? FRAME_TARGET : FRAME), x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                        poseStack.m_85849_();
                    }
                } else {
                    Vec3 pos = ClientEventHandler.lockingPos;
                    boolean lockOn = ClientEventHandler.lockOn;
                    Vec3 point = VectorUtil.worldToScreen(pos);
                    if (VectorUtil.canSee(pos)) {
                        poseStack.m_85836_();
                        float x = (float)point.f_82479_;
                        float y = (float)point.f_82480_;
                        RenderHelper.blit(poseStack, lockOn ? FRAME_LOCK : FRAME_TARGET, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                        poseStack.m_85849_();
                    }
                }
            }
            poseStack.m_85849_();
        } else {
            scopeScale = 1.0f;
        }
    }
}

