/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.launchable;

import com.atsuishio.superbwarfare.data.CustomData;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.data.launchable.ShootData;
import com.atsuishio.superbwarfare.tools.TagDataParser;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import org.jetbrains.annotations.Nullable;

public class LaunchableEntityTool {
    @Nullable
    public static CompoundTag getModifiedTag(ProjectileInfo projectileInfo, ShootData data) {
        JsonObject launchableData;
        if (projectileInfo.data != null) {
            launchableData = projectileInfo.data;
        } else if (CustomData.LAUNCHABLE_ENTITY.containsKey(projectileInfo.type)) {
            launchableData = CustomData.LAUNCHABLE_ENTITY.get((Object)projectileInfo.type).data;
        } else {
            return null;
        }
        return TagDataParser.parse(launchableData, name -> switch (name) {
            case "@sbw:damage" -> DoubleTag.m_128500_((double)data.damage());
            case "@sbw:owner" -> {
                if (data.shooter() != null) {
                    yield NbtUtils.m_129226_((UUID)data.shooter());
                }
                yield null;
            }
            case "@sbw:owner_string_lower" -> {
                if (data.shooter() != null) {
                    yield StringTag.m_129297_((String)data.shooter().toString().replace("-", "").toLowerCase(Locale.ROOT));
                }
                yield null;
            }
            case "@sbw:owner_string_upper" -> {
                if (data.shooter() != null) {
                    yield StringTag.m_129297_((String)data.shooter().toString().replace("-", "").toUpperCase(Locale.ROOT));
                }
                yield null;
            }
            case "@sbw:explosion_damage" -> DoubleTag.m_128500_((double)data.explosionDamage());
            case "@sbw:explosion_radius" -> DoubleTag.m_128500_((double)data.explosionRadius());
            case "@sbw:spread" -> DoubleTag.m_128500_((double)data.spread());
            default -> StringTag.m_129297_((String)name);
        });
    }
}

