/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.annotation.ServerOnly;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.data.IDBasedData;
import com.atsuishio.superbwarfare.data.ModColor;
import com.atsuishio.superbwarfare.data.ObjectToList;
import com.atsuishio.superbwarfare.data.StringToObject;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.vehicle.subdata.CollisionLevel;
import com.atsuishio.superbwarfare.data.vehicle.subdata.DestroyInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.EngineType;
import com.atsuishio.superbwarfare.data.vehicle.subdata.OBBInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.SeatInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.SeekInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.VehicleContainerType;
import com.atsuishio.superbwarfare.data.vehicle.subdata.VehicleType;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModify;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;

public class DefaultVehicleData
implements IDBasedData<DefaultVehicleData> {
    @SerializedName(value="ID")
    public String id = "";
    public transient boolean isDefaultData = true;
    @SerializedName(value="MaxHealth")
    public float maxHealth = 50.0f;
    @ServerOnly
    @SerializedName(value="RepairCooldown")
    public int repairCooldown = (Integer)DefaultVehicleData.getConfigOrDefault(VehicleConfig.REPAIR_COOLDOWN);
    @ServerOnly
    @SerializedName(value="RepairAmount")
    public float repairAmount = ((Double)DefaultVehicleData.getConfigOrDefault(VehicleConfig.REPAIR_AMOUNT)).floatValue();
    @ServerOnly
    @SerializedName(value="SelfHurtPercent")
    public float selfHurtPercent = 0.1f;
    @ServerOnly
    @SerializedName(value="SelfHurtAmount")
    public float selfHurtAmount = 0.1f;
    @SerializedName(value="MaxEnergy")
    public int maxEnergy = Integer.MAX_VALUE;
    @SerializedName(value="OBB")
    public List<OBBInfo> obb = List.of();
    @SerializedName(value="Seats")
    protected ObjectToList<SeatInfo> seats = new ObjectToList<SeatInfo>(new SeatInfo[0]);
    @SerializedName(value="UpStep")
    public float upStep = 0.0f;
    @SerializedName(value="AllowFreeCam")
    public boolean allowFreeCam = false;
    @SerializedName(value="HasDecoy")
    public boolean hasDecoy = false;
    @ServerOnly
    @SerializedName(value="ApplyDefaultDamageModifiers")
    public boolean applyDefaultDamageModifiers = true;
    @ServerOnly
    @SerializedName(value="SendHitParticles")
    public boolean sendHitParticles = true;
    @ServerOnly
    @SerializedName(value="DamageModifiers")
    public ObjectToList<StringToObject<DamageModify>> damageModifiers = new ObjectToList<StringToObject>(new StringToObject[0]);
    @ServerOnly
    @SerializedName(value="Mass")
    public float mass = 1.0f;
    @ServerOnly
    @SerializedName(value="DestroyInfo")
    public DestroyInfo destroyInfo = new DestroyInfo();
    @SerializedName(value="SeekInfo")
    public SeekInfo seekInfo = null;
    @SerializedName(value="VehicleContainerType")
    public VehicleContainerType vehicleContainerType = VehicleContainerType.MEDIUM;
    @SerializedName(value="HasUpgradeSlots")
    public boolean hasUpgradeSlots = false;
    @SerializedName(value="VehicleIcon")
    public ResourceLocation vehicleIcon = Mod.loc("textures/gun_icon/default_icon.png");
    @SerializedName(value="ContainerIcon")
    public ResourceLocation containerIcon = null;
    @SerializedName(value="HUDColor")
    public ModColor hudColor = new ModColor(0x66FF00);
    @SerializedName(value="Type")
    public VehicleType type = VehicleType.EMPTY;
    @SerializedName(value="EngineType")
    public EngineType engineType = EngineType.EMPTY;
    @SerializedName(value="EngineInfo")
    public JsonObject engineInfo = new JsonObject();
    @SerializedName(value="EngineSound")
    public SoundEvent engineSound = SoundEvents.f_271165_;
    @SerializedName(value="HornSound")
    public SoundEvent hornSound = SoundEvents.f_271165_;
    @SerializedName(value="ThirdPersonCameraPos")
    public Vec3 thirdPersonCameraPos = new Vec3(0.0, 1.0, 3.0);
    @SerializedName(value="HasLowHealthWarning")
    public boolean hasLowHealthWarning = true;
    @SerializedName(value="RotateOffsetHeight")
    public float rotateOffsetHeight = 0.0f;
    @SerializedName(value="Weapons")
    protected Map<String, JsonObject> weapons = Map.of();
    private transient Map<String, DefaultGunData> processedWeapons;
    @SerializedName(value="CollisionLevel")
    public CollisionLevel collisionLevel = new CollisionLevel();
    @SerializedName(value="TurretPos")
    public Vec3 turretPos = null;
    @SerializedName(value="TurretTurnSpeed")
    public Vec2 turretTurnSpeed = new Vec2(5.0f, 5.0f);
    @SerializedName(value="TurretYawRange")
    public Vec2 turretYawRange = new Vec2(-514.0f, 514.0f);
    @SerializedName(value="TurretPitchRange")
    public Vec2 turretPitchRange = new Vec2(-10.0f, 30.0f);
    @SerializedName(value="TurretControllerIndex")
    public int turretControllerIndex = 0;
    @SerializedName(value="MainWeaponHudType")
    public String mainWeaponHudType = "@Empty";
    @SerializedName(value="BarrelPos")
    public Vec3 barrelPos = Vec3.f_82478_;
    @SerializedName(value="PassengerWeaponStationPos")
    public Vec3 passengerWeaponStationPos = null;
    @SerializedName(value="PassengerWeaponStationBarrelPos")
    public Vec3 passengerWeaponStationBarrelPos = Vec3.f_82478_;
    @SerializedName(value="PassengerWeaponStationTurnSpeed")
    public Vec2 passengerWeaponStationTurnSpeed = new Vec2(5.0f, 5.0f);
    @SerializedName(value="PassengerWeaponStationYawRange")
    public Vec2 passengerWeaponStationYawRange = new Vec2(-514.0f, 514.0f);
    @SerializedName(value="PassengerWeaponStationPitchRange")
    public Vec2 passengerWeaponStationPitchRange = new Vec2(-10.0f, 30.0f);
    @SerializedName(value="PassengerWeaponStationControllerIndex")
    public int passengerWeaponStationControllerIndex = 1;
    @SerializedName(value="UsePassengerCreativeAmmoBox")
    public boolean usePassengerCreativeAmmoBox = true;
    @SerializedName(value="Gravity")
    public double gravity = 0.06;
    @SerializedName(value="TerrainCompat")
    public List<Vec3> terrainCompat = null;
    @SerializedName(value="TerrainCompatRotateRate")
    public float terrainCompatRotateRate = 1.0f;
    @SerializedName(value="InertiaRotateRate")
    public float inertiaRotateRate = 0.0f;

    @Override
    public String getId() {
        return this.id;
    }

    private static <T> T getConfigOrDefault(ForgeConfigSpec.ConfigValue<T> config) {
        try {
            return (T)config.get();
        }
        catch (Exception exception) {
            return (T)config.getDefault();
        }
    }

    public List<SeatInfo> seats() {
        if (this.seats == null) {
            return List.of();
        }
        return Collections.unmodifiableList(this.seats.list);
    }

    public Map<String, DefaultGunData> weapons() {
        if (this.processedWeapons != null) {
            return this.processedWeapons;
        }
        HashMap<String, DefaultGunData> map = new HashMap<String, DefaultGunData>();
        for (Map.Entry<String, JsonObject> entry : this.weapons.entrySet()) {
            JsonPrimitive primitive;
            JsonObject value = entry.getValue();
            if (value == null) continue;
            JsonElement jsonElement = (value = value.deepCopy()).get("Template");
            if (jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isString()) {
                value.remove("Template");
                JsonObject templateValue = this.weapons.get(primitive.getAsString());
                if (templateValue != null) {
                    JsonObject newValue = templateValue.deepCopy();
                    for (Map.Entry kv : value.entrySet()) {
                        newValue.add((String)kv.getKey(), (JsonElement)kv.getValue());
                    }
                    value = newValue;
                }
            }
            map.put(entry.getKey(), (DefaultGunData)DataLoader.GSON.fromJson((JsonElement)value, DefaultGunData.class));
        }
        this.processedWeapons = Collections.unmodifiableMap(map);
        return this.processedWeapons;
    }

    @Override
    public void limit() {
        this.maxHealth = Math.max(this.maxHealth, 0.0f);
        this.repairCooldown = Math.max(this.repairCooldown, 0);
        this.maxEnergy = Math.max(this.maxEnergy, 0);
        this.weapons = this.weapons == null ? Map.of() : this.weapons;
        this.obb = this.obb == null ? List.of() : this.obb;
        this.obb = this.obb.stream().filter(Objects::nonNull).peek(OBBInfo::limit).toList();
        this.collisionLevel = this.collisionLevel == null ? new CollisionLevel() : this.collisionLevel;
        this.collisionLevel.level = Mth.m_14045_((int)this.collisionLevel.level, (int)0, (int)4);
        this.collisionLevel.powerLimits = this.collisionLevel.powerLimits == null ? List.of() : this.collisionLevel.powerLimits;
    }
}

