/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.CustomSyncMotionEntity;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import org.jetbrains.annotations.NotNull;

public abstract class DestroyableProjectile
extends FastThrowableProjectile
implements CustomSyncMotionEntity,
IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(DestroyableProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier();

    public DestroyableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public DestroyableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, @Nullable Entity pShooter, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_5602_(pShooter);
        if (pShooter != null) {
            this.m_6034_(pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_());
        }
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        amount = DAMAGE_MODIFIER.compute(source, amount);
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() - amount));
        return super.m_6469_(source, amount);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(this.getMaxHealth()));
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compound.m_128457_("Health")));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
    }

    public float getMaxHealth() {
        return 30.0f;
    }
}

