/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.client.particle.CustomCloudOption;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrapeshotEntity
extends FastThrowableProjectile {
    public GrapeshotEntity(EntityType<? extends GrapeshotEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    public GrapeshotEntity(@Nullable Entity entity, Level level, float damage) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.GRAPESHOT.get()), entity, level);
        this.f_19811_ = true;
        this.damage = damage;
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.GS_5_INCHES.get();
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (this.m_19749_() != null && this.m_19749_().m_20202_() != null && entity == this.m_19749_().m_20202_()) {
            return;
        }
        if (this.m_9236_() instanceof ServerLevel) {
            LivingEntity living;
            if (entity == this.m_19749_() || this.m_19749_() != null && entity == this.m_19749_().m_20202_()) {
                return;
            }
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            DamageHandler.doDamage(entity, ModDamageTypes.causeGrapeShotHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.damage);
            if (entity instanceof LivingEntity) {
                entity.f_19802_ = 0;
            }
            this.m_146870_();
        }
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
        BlockPos resultPos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(resultPos);
        SoundEvent event = state.m_60734_().getSoundType(state, (LevelReader)this.m_9236_(), resultPos, (Entity)this).m_56775_();
        this.m_9236_().m_6263_(null, result.m_82450_().f_82479_, result.m_82450_().f_82480_, result.m_82450_().f_82481_, event, SoundSource.AMBIENT, 1.0f, 1.0f);
        Vec3 hitVec = result.m_82450_();
        this.hitBlock(hitVec, result);
        this.m_146870_();
    }

    protected void hitBlock(Vec3 location, BlockHitResult result) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = result.m_82425_();
            Direction face = result.m_82434_();
            BlockState state = this.m_9236_().m_8055_(pos);
            double vx = face.m_122429_();
            double vy = face.m_122430_();
            double vz = face.m_122431_();
            Vec3 dir = new Vec3(vx, vy, vz);
            this.summonVectorParticle(serverLevel, state, location, dir);
            this.m_146870_();
            serverLevel.m_5594_(null, new BlockPos((int)location.f_82479_, (int)location.f_82480_, (int)location.f_82481_), (SoundEvent)ModSounds.LAND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void summonVectorParticle(ServerLevel serverLevel, BlockState state, Vec3 pos, Vec3 dir) {
        Vec3 vec3;
        int i;
        BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.f_123794_, state);
        for (i = 0; i < 7; ++i) {
            vec3 = this.randomVec(dir, 40.0);
            ParticleTool.sendParticle(serverLevel, particleData, pos.f_82479_ + 0.05 * (double)i * dir.f_82479_, pos.f_82480_ + 0.05 * (double)i * dir.f_82480_, pos.f_82481_ + 0.05 * (double)i * dir.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 10.0, true);
        }
        for (i = 0; i < 3; ++i) {
            vec3 = this.randomVec(dir, 20.0);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.05, true);
        }
        if (state.m_60827_() == SoundType.f_56743_ || state.m_60827_() == SoundType.f_56749_ || state.m_60827_() == SoundType.f_56728_ || state.m_60827_() == SoundType.f_154663_ || state.m_60827_() == SoundType.f_56725_) {
            serverLevel.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSounds.HIT.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
            for (i = 0; i < 3; ++i) {
                vec3 = this.randomVec(dir, 80.0);
                ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.2 + 0.1 * Math.random(), true);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            BlockHitResult fluidResult = ProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this), state -> false);
            this.onHitWater(fluidResult.m_82450_(), fluidResult);
        }
        Vec3 vec31 = this.m_20184_();
        this.m_20256_(vec31.m_82542_(0.96, 0.96, 0.96));
        if (this.f_19797_ > 200 || this.m_20069_()) {
            this.m_146870_();
        }
    }

    protected void onHitWater(Vec3 location, BlockHitResult result) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = result.m_82425_();
            Direction face = result.m_82434_();
            BlockState state = this.m_9236_().m_8055_(pos);
            double vx = face.m_122429_();
            double vy = face.m_122430_();
            double vz = face.m_122431_();
            Vec3 dir = new Vec3(vx, vy, vz).m_82549_(this.m_20184_().m_82541_().m_82490_(-0.1));
            if (state.m_60734_() == Blocks.f_49990_) {
                if (!this.m_20069_()) {
                    CustomCloudOption particleData = new CustomCloudOption(1.0f, 1.0f, 1.0f, 80, 0.5f, 1.0f, false, false);
                    for (int i = 0; i < 10; ++i) {
                        Vec3 vec3 = this.randomVec(dir, 40.0);
                        ParticleTool.sendParticle(serverLevel, particleData, location.f_82479_ + 0.12 * (double)i * dir.f_82479_, location.f_82480_ + 0.12 * (double)i * dir.f_82480_, location.f_82481_ + 0.12 * (double)i * dir.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 15.0, true);
                    }
                    ParticleTool.spawnBulletHitWaterParticles((Level)serverLevel, location);
                    serverLevel.m_5594_(null, new BlockPos((int)location.f_82479_, (int)location.f_82480_, (int)location.f_82481_), (SoundEvent)ModSounds.HIT_WATER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.m_146870_();
                }
            } else if (state.m_60734_() == Blocks.f_49991_ && !this.m_20077_()) {
                BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.f_123794_, state);
                for (int i = 0; i < 7; ++i) {
                    Vec3 vec3 = this.randomVec(dir, 20.0);
                    ParticleTool.sendParticle(serverLevel, particleData, location.f_82479_ + 0.1 * (double)i * dir.f_82479_, location.f_82480_ + 0.1 * (double)i * dir.f_82480_, location.f_82481_ + 0.1 * (double)i * dir.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 10.0, true);
                }
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123756_, location.f_82479_, location.f_82480_, location.f_82481_, 4, 0.0, 0.0, 0.0, 0.6, true);
                serverLevel.m_5594_(null, new BlockPos((int)location.f_82479_, (int)location.f_82480_, (int)location.f_82481_), SoundEvents.f_12032_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.m_146870_();
            }
        }
    }

    public Vec3 randomVec(Vec3 vec3, double spread) {
        return vec3.m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * spread), this.f_19796_.m_216328_(0.0, 0.0172275 * spread), this.f_19796_.m_216328_(0.0, 0.0172275 * spread));
    }

    @Override
    public boolean isFastMoving() {
        return false;
    }
}

