/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.MissileProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IglaMissileEntity
extends MissileProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public IglaMissileEntity(EntityType<? extends IglaMissileEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    public IglaMissileEntity(Entity entity, Level level, float damage, float explosionDamage, float explosionRadius) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.IGLA_MISSILE.get()), entity, level);
        this.f_19811_ = true;
        this.damage = damage;
        this.explosionDamage = explosionDamage;
        this.explosionRadius = explosionRadius;
        this.durability = 0;
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.MEDIUM_ANTI_AIR_MISSILE.get();
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (this.m_19749_() != null && this.m_19749_().m_20202_() != null && entity == this.m_19749_().m_20202_()) {
            return;
        }
        if (this.m_9236_() instanceof ServerLevel) {
            LivingEntity living;
            if (entity == this.m_19749_() || this.m_19749_() != null && entity == this.m_19749_().m_20202_()) {
                return;
            }
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            DamageHandler.doDamage(entity, ModDamageTypes.causeProjectileHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.damage);
            if (entity instanceof LivingEntity) {
                entity.f_19802_ = 0;
            }
            this.causeExplode(result.m_82450_());
            this.m_146870_();
        }
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            BlockPos resultPos = blockHitResult.m_82425_();
            float hardness = this.m_9236_().m_8055_(resultPos).m_60734_().m_155943_();
            if (hardness != -1.0f) {
                if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                    if (this.firstHit) {
                        this.causeExplode(blockHitResult.m_82450_());
                        this.firstHit = false;
                        Mod.queueServerWork(3, () -> ((IglaMissileEntity)this).m_146870_());
                    }
                    if (((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue()) {
                        this.m_9236_().m_46961_(resultPos, true);
                    }
                }
            } else {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
            if (!((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.mediumTrail();
        Entity entity = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(TARGET_UUID));
        List<Entity> decoy = SeekTool.seekLivingEntities((Entity)this, 32.0, 90.0);
        for (Entity e : decoy) {
            if (!e.m_6095_().m_204039_(ModTags.EntityTypes.DECOY) || this.distracted) continue;
            this.f_19804_.m_135381_(TARGET_UUID, (Object)e.m_20149_());
            this.distracted = true;
            break;
        }
        if (entity != null && !((String)this.f_19804_.m_135370_(TARGET_UUID)).equals("none")) {
            if ((!entity.m_20197_().isEmpty() || entity instanceof VehicleEntity) && entity.f_19797_ % (int)Math.max(0.04 * (double)this.m_20270_(entity), 2.0) == 0) {
                entity.m_9236_().m_5594_(null, entity.m_20097_(), entity instanceof Pig ? SoundEvents.f_12235_ : (SoundEvent)ModSounds.MISSILE_WARNING.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
            }
            Vec3 targetPos = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)(0.5f * entity.m_20206_()) + (double)(entity instanceof EnderDragon ? -3 : 0), entity.m_20189_());
            Vec3 toVec = RangeTool.calculateFiringSolution(this.m_20182_(), targetPos, entity.m_20184_(), this.m_20184_().m_82553_(), 0.0);
            if (this.f_19797_ > 1) {
                Player player;
                this.lostTarget = VectorTool.calculateAngle(this.m_20184_(), toVec) > 120.0 && !this.lostTarget;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof Player && (player = (Player)entity2).m_21205_().m_150930_((Item)ModItems.IGLA_9K38.get()) && !this.lost) {
                    ItemStack handItem = player.m_21205_();
                    GunData data = GunData.from(handItem);
                    boolean bl = this.lost = !data.zooming.get() || !VectorTool.checkNoClip(player.m_146892_(), targetPos, this.m_9236_());
                }
                if (!this.lostTarget && !this.lost) {
                    this.turn(toVec, Mth.m_14036_((float)((float)(this.f_19797_ - 1) * 0.5f), (float)0.0f, (float)15.0f));
                    this.m_20256_(this.m_20184_().m_82490_(0.05).m_82549_(this.m_20154_().m_82490_(8.0)));
                }
                if (this.lostTarget) {
                    this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                }
            }
        }
        if (this.lost) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.03, 0.0));
            this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
        }
        if (this.f_19797_ > 200 || this.m_20069_()) {
            if (this.m_9236_() instanceof ServerLevel) {
                ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, ModDamageTypes.causeProjectileExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), (Entity)this, this.explosionDamage, this.explosionRadius);
            }
            this.m_146870_();
        }
    }

    private PlayState movementPredicate(AnimationState<IglaMissileEntity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.jvm.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.ROCKET_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.4f;
    }
}

