/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.MediumRocketEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModSerializers;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.common.ammo.MediumRocketItem;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4d;

public class Type63Entity
extends GeoVehicleEntity {
    public static final EntityDataAccessor<Float> TARGET_PITCH = SynchedEntityData.m_135353_(Type63Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> TARGET_YAW = SynchedEntityData.m_135353_(Type63Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> BODY_YAW = SynchedEntityData.m_135353_(Type63Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> SHOOT_PITCH = SynchedEntityData.m_135353_(Type63Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> SHOOT_YAW = SynchedEntityData.m_135353_(Type63Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<IntList> LOADED_AMMO = SynchedEntityData.m_135353_(Type63Entity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.INT_LIST_SERIALIZER.get()));
    public OBB[] barrel = new OBB[12];
    public OBB pitchController;
    public OBB yawController;
    public OBB hoe1;
    public OBB hoe2;
    public OBB wheel1 = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.125, 0.390625, 0.390625), new Quaterniond(), OBB.Part.WHEEL_LEFT);
    public OBB wheel2 = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.125, 0.390625, 0.390625), new Quaterniond(), OBB.Part.WHEEL_RIGHT);
    public OBB body1 = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.4765625, 0.3515625, 0.7578125), new Quaterniond(), OBB.Part.BODY);
    public OBB body2 = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d((double)0.771875f, 0.109375, 0.296875), new Quaterniond(), OBB.Part.BODY);
    public double interactionTick;
    public int cooldown;

    public Type63Entity(EntityType<Type63Entity> type, Level world) {
        super(type, world);
        this.barrel[0] = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[1] = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[2] = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[3] = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[4] = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[5] = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[6] = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[7] = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[8] = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[9] = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[10] = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[11] = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.pitchController = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.15625, 0.21875, 0.21875), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.yawController = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.125, 0.125, 0.125), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.hoe1 = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.125, 0.125, 0.875), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.hoe2 = new OBB(OBB.vec3ToVector3d(this.m_20182_()), new Vector3d(0.125, 0.125, 0.875), new Quaterniond(), OBB.Part.INTERACTIVE);
    }

    @Override
    public boolean m_5829_() {
        return true;
    }

    public void m_6123_(Player pPlayer) {
        if (this.m_20182_().m_82554_(pPlayer.m_20182_()) > 1.4 || pPlayer == this.m_146895_() || pPlayer.m_20182_().f_82480_ > this.m_20182_().f_82480_ || !pPlayer.m_6144_()) {
            return;
        }
        if (!this.m_9236_().f_46443_ && pPlayer.m_20186_() < this.m_20186_() + (double)this.m_20206_() && pPlayer.m_20186_() + (double)pPlayer.m_20206_() > this.m_20186_()) {
            double entitySize = pPlayer.m_20205_() * pPlayer.m_20206_();
            double thisSize = this.m_20205_() * this.m_20206_();
            double f = Math.min((double)(entitySize / thisSize), (double)2.0);
            this.m_20256_(this.m_20184_().m_82549_(new Vec3(pPlayer.m_20182_().m_82505_(this.m_20182_()).m_252839_()).m_82490_(0.5 * f * pPlayer.m_20184_().m_82553_())));
            this.m_146922_(pPlayer.m_6080_());
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        IntArrayList list = new IntArrayList();
        for (int i = 0; i < this.m_6643_(); ++i) {
            list.add(-1);
        }
        this.f_19804_.m_135372_(TARGET_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BODY_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SHOOT_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SHOOT_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LOADED_AMMO, (Object)list);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Pitch", ((Float)this.f_19804_.m_135370_(TARGET_PITCH)).floatValue());
        compound.m_128350_("Yaw", ((Float)this.f_19804_.m_135370_(TARGET_YAW)).floatValue());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(TARGET_PITCH, (Object)Float.valueOf(compound.m_128457_("Pitch")));
        this.f_19804_.m_135381_(TARGET_YAW, (Object)Float.valueOf(compound.m_128457_("Yaw")));
        this.m_6596_();
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        Level vec3;
        InteractionResult result = super.m_6096_(player, hand);
        if (result != InteractionResult.PASS) {
            return result;
        }
        ItemStack stack = player.m_21205_();
        OBB lookingObb = OBB.getLookingObb(player, player.getEntityReach());
        if (stack.m_41619_()) {
            if (player.m_6144_()) {
                Level vec32;
                if (lookingObb == this.hoe1) {
                    Level level = player.m_9236_();
                    if (level instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level;
                        this.f_19804_.m_135381_(BODY_YAW, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(BODY_YAW)).floatValue() + 0.2f * (float)this.interactionTick));
                        this.interactionTick += 1.0;
                        if (this.cooldown == 0) {
                            this.cooldown = 6;
                            vec32 = OBB.vector3dToVec3(this.hoe1.center());
                            serverLevel.m_6263_(null, vec32.f_82479_, vec32.f_82480_, vec32.f_82481_, (SoundEvent)ModSounds.WHEEL_VEHICLE_STEP.get(), SoundSource.PLAYERS, 0.5f, this.f_19796_.m_188501_() * 0.05f + 0.975f);
                        }
                    }
                    player.m_6674_(InteractionHand.MAIN_HAND);
                }
                if (lookingObb == this.hoe2) {
                    vec32 = player.m_9236_();
                    if (vec32 instanceof ServerLevel) {
                        serverLevel = (ServerLevel)vec32;
                        this.f_19804_.m_135381_(BODY_YAW, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(BODY_YAW)).floatValue() - 0.2f * (float)this.interactionTick));
                        this.interactionTick += 1.0;
                        if (this.cooldown == 0) {
                            this.cooldown = 6;
                            vec32 = OBB.vector3dToVec3(this.hoe1.center());
                            serverLevel.m_6263_(null, vec32.f_82479_, vec32.f_82480_, vec32.f_82481_, (SoundEvent)ModSounds.WHEEL_VEHICLE_STEP.get(), SoundSource.PLAYERS, 0.5f, this.f_19796_.m_188501_() * 0.05f + 0.975f);
                        }
                    }
                    player.m_6674_(InteractionHand.MAIN_HAND);
                }
            } else {
                player.m_6674_(InteractionHand.MAIN_HAND);
                Level vec33 = this.m_9236_();
                if (vec33 instanceof ServerLevel) {
                    serverLevel = (ServerLevel)vec33;
                    if (this.cooldown == 0) {
                        for (int i = 0; i < this.barrel.length; ++i) {
                            if (lookingObb != this.barrel[i] || ((ItemStack)this.items.get(i)).m_41619_()) continue;
                            player.m_36356_(((ItemStack)this.items.get(i)).m_255036_(1));
                            vec3 = OBB.vector3dToVec3(this.barrel[i].center());
                            serverLevel.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (SoundEvent)ModSounds.TYPE_63_RELOAD.get(), SoundSource.PLAYERS, 1.0f, this.f_19796_.m_188501_() * 0.1f + 0.9f);
                            this.cooldown = 5;
                            this.items.set(i, (Object)ItemStack.f_41583_);
                            this.m_6596_();
                        }
                    }
                }
            }
            if (lookingObb == this.yawController) {
                this.interactEvent(OBB.vector3dToVec3(this.yawController.center()));
                this.f_19804_.m_135381_(TARGET_YAW, (Object)Float.valueOf(Mth.m_14036_((float)(((Float)this.f_19804_.m_135370_(TARGET_YAW)).floatValue() + (player.m_6144_() ? -0.02f : 0.02f) * (float)this.interactionTick), (float)(-this.getTurretMaxYaw()), (float)(-this.getTurretMinYaw()))));
                player.m_6674_(InteractionHand.MAIN_HAND);
            }
            if (lookingObb == this.pitchController) {
                this.interactEvent(OBB.vector3dToVec3(this.pitchController.center()));
                this.f_19804_.m_135381_(TARGET_PITCH, (Object)Float.valueOf(Mth.m_14036_((float)(((Float)this.f_19804_.m_135370_(TARGET_PITCH)).floatValue() + (player.m_6144_() ? 0.02f : -0.02f) * (float)this.interactionTick), (float)(-this.getTurretMaxPitch()), (float)(-this.getTurretMinPitch()))));
                player.m_6674_(InteractionHand.MAIN_HAND);
            }
        }
        if (stack.m_41720_() instanceof MediumRocketItem) {
            for (int i = 0; i < this.barrel.length; ++i) {
                if (lookingObb == this.barrel[i] && ((ItemStack)this.items.get(i)).m_41619_() && (vec3 = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)vec3;
                    if (this.cooldown == 0) {
                        this.m_6836_(i, stack.m_255036_(1));
                        if (!player.m_7500_()) {
                            stack.m_41774_(1);
                        }
                        vec3 = OBB.vector3dToVec3(this.barrel[i].center());
                        serverLevel.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (SoundEvent)ModSounds.TYPE_63_RELOAD.get(), SoundSource.PLAYERS, 1.0f, this.f_19796_.m_188501_() * 0.1f + 0.9f);
                        this.cooldown = 5;
                        this.m_6596_();
                    }
                }
                player.m_6674_(InteractionHand.MAIN_HAND);
            }
        }
        if (this.cooldown == 0 && (stack.m_204117_(ModTags.Items.TOOLS_CROWBAR) || stack.m_150930_(Items.f_42409_))) {
            if (this.lookingAtBarrel(player)) {
                for (int i = 0; i < this.barrel.length; ++i) {
                    if (lookingObb != this.barrel[i] || !(((ItemStack)this.items.get(i)).m_41720_() instanceof MediumRocketItem)) continue;
                    this.shoot(player, i);
                    this.items.set(i, (Object)ItemStack.f_41583_);
                    this.m_6596_();
                }
                player.m_6674_(InteractionHand.MAIN_HAND);
            } else {
                for (int i = 0; i < 12; ++i) {
                    if (!(((ItemStack)this.items.get(i)).m_41720_() instanceof MediumRocketItem)) continue;
                    this.shoot(player, i);
                    this.items.set(i, (Object)ItemStack.f_41583_);
                    this.m_6596_();
                    player.m_6674_(InteractionHand.MAIN_HAND);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public boolean lookingAtBarrel(Player player) {
        OBB lookingObb = OBB.getLookingObb(player, player.getEntityReach());
        for (int i = 0; i < 12; ++i) {
            if (lookingObb != this.barrel[i]) continue;
            return true;
        }
        return false;
    }

    public void interactEvent(Vec3 vec3) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.interactionTick += 1.0;
            if (this.cooldown <= 0) {
                this.cooldown = 6;
                serverLevel.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (SoundEvent)ModSounds.HAND_WHEEL_ROT.get(), SoundSource.PLAYERS, 1.0f, this.f_19796_.m_188501_() * 0.05f + 0.975f);
            }
        }
    }

    public void shoot(Player player, int i) {
        ItemStack stack = (ItemStack)this.items.get(i);
        Item item = stack.m_41720_();
        if (!(item instanceof MediumRocketItem)) {
            return;
        }
        MediumRocketItem rocketItem = (MediumRocketItem)item;
        GunData gunData = this.getGunData(rocketItem.type.toString());
        if (gunData == null) {
            return;
        }
        float shootVelocity = this.getProjectileVelocity(gunData);
        float shootSpread = this.getProjectileSpread(gunData);
        float shootGravity = this.getProjectileGravity(gunData);
        OBB obb = this.barrel[i];
        Vec3 shootPos = OBB.vector3dToVec3(obb.center());
        DefaultGunData computed = gunData.compute();
        MediumRocketEntity entityToSpawn = new MediumRocketEntity((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MEDIUM_ROCKET.get()), shootPos.f_82479_, shootPos.f_82480_, shootPos.f_82481_, this.m_9236_(), (float)computed.damage, (float)computed.explosionRadius, (float)computed.explosionDamage, 0.0f, 0, rocketItem.type, computed.sparedAmount, computed.sparedAngle);
        entityToSpawn.setGravity(shootGravity);
        entityToSpawn.m_5602_((Entity)player);
        Vec3 barrelVector = this.getBarrelVector(1.0f);
        entityToSpawn.m_6686_(barrelVector.f_82479_, barrelVector.f_82480_, barrelVector.f_82481_, shootVelocity, shootSpread);
        this.m_9236_().m_7967_((Entity)entityToSpawn);
        this.m_9236_().m_6263_(null, shootPos.f_82479_, shootPos.f_82480_, shootPos.f_82481_, computed.soundInfo.fire3P, SoundSource.PLAYERS, (float)computed.soundRadius, this.f_19796_.m_188501_() * 0.1f + 0.95f);
        AABB ab = new AABB(this.m_20191_().m_82399_(), this.m_20191_().m_82399_()).m_82400_(0.75).m_82383_(barrelVector.m_82490_(-2.0)).m_82369_(barrelVector.m_82490_(-5.0));
        for (Entity entity : this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Entity.class), ab, target -> target != this && target != this.m_146895_() && target.m_20202_() == null)) {
            entity.m_6469_(ModDamageTypes.causeBurnDamage(entity.m_9236_().m_9598_(), (Entity)player), 30.0f - 2.0f * entity.m_20270_((Entity)this));
            double force = 4.0 - 0.7 * (double)entity.m_20270_((Entity)this);
            entity.m_5997_(-force * barrelVector.f_82479_, -force * barrelVector.f_82480_, -force * barrelVector.f_82481_);
        }
        this.cooldown = 10;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.spawnMediumCannonMuzzleParticles(barrelVector.m_82490_(-1.0), shootPos.m_82549_(barrelVector.m_82490_(-0.5)), serverLevel, this);
            ParticleTool.spawnMediumCannonMuzzleParticles(barrelVector.m_82490_(-1.0), shootPos.m_82549_(barrelVector.m_82490_(-1.5)), serverLevel, this);
            ParticleTool.spawnMediumCannonMuzzleParticles(barrelVector, shootPos.m_82549_(barrelVector.m_82490_(1.5)), serverLevel, this);
        }
        gunData.shakePlayers(this);
    }

    @Override
    public void m_6075_() {
        this.turretYRotO = this.getTurretYRot();
        this.turretXRotO = this.getTurretXRot();
        this.leftWheelRotO = this.getLeftWheelRot();
        this.rightWheelRotO = this.getRightWheelRot();
        super.m_6075_();
        double fluidFloat = 0.052 * VehicleVecUtils.getSubmergedHeight(this);
        this.m_20256_(this.m_20184_().m_82520_(0.0, fluidFloat, 0.0));
        if (this.m_20096_()) {
            float f0 = 0.35f + 0.5f * Mth.m_14154_((float)(90.0f - (float)VehicleVecUtils.calculateAngle(this.m_20184_(), this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.05 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        if (this.m_20069_()) {
            float f1 = (float)((double)0.7f - (double)0.04f * Math.min((double)VehicleVecUtils.getSubmergedHeight(this), (double)this.m_20206_()) + (double)(0.08f * Mth.m_14154_((float)(90.0f - (float)VehicleVecUtils.calculateAngle(this.m_20184_(), this.m_20252_(1.0f)))) / 90.0f));
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.04 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        this.interactionTick *= 0.94;
        if (this.m_9236_() instanceof ServerLevel) {
            this.f_19804_.m_135381_(SHOOT_PITCH, (Object)Float.valueOf((float)VehicleVecUtils.getXRotFromVector(this.getBarrelVector(1.0f))));
            this.f_19804_.m_135381_(SHOOT_YAW, (Object)Float.valueOf((float)(-VehicleVecUtils.getYRotFromVector(this.getBarrelVector(1.0f)))));
        }
        this.f_19804_.m_135381_(BODY_YAW, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(BODY_YAW)).floatValue() * 0.8f));
        this.m_146922_(this.m_146908_() + ((Float)this.f_19804_.m_135370_(BODY_YAW)).floatValue());
        this.m_6210_();
    }

    @Override
    public void travel() {
        float diffY = ((Float)this.f_19804_.m_135370_(TARGET_YAW)).floatValue() - this.getTurretYRot();
        this.setTurretYRot(Mth.m_14036_((float)(this.getTurretYRot() + 0.1f * diffY), (float)(-this.getTurretMaxYaw()), (float)(-this.getTurretMinYaw())));
        float diffX = ((Float)this.f_19804_.m_135370_(TARGET_PITCH)).floatValue() - this.getTurretXRot();
        this.setTurretXRot(Mth.m_14036_((float)(this.getTurretXRot() + 0.1f * diffX), (float)(-this.getTurretMaxPitch()), (float)(-this.getTurretMinPitch())));
        double s0 = this.m_20184_().m_82526_(this.m_20252_(1.0f));
        this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - 1.167 * s0));
        this.setRightWheelRot((float)((double)this.getRightWheelRot() - 1.167 * s0));
    }

    public Vec3 getShootPos(float pPartialTicks) {
        Matrix4d transform = this.getBarrelTransform(pPartialTicks);
        Vector4d rootPosition = this.transformPosition(transform, 0.0, 6.25E-4, -0.44625);
        return new Vec3(rootPosition.x, rootPosition.y, rootPosition.z);
    }

    public int m_6893_() {
        return 1;
    }

    @Override
    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        return false;
    }

    @Override
    public boolean m_271862_(@NotNull Container target, int slot, @NotNull ItemStack stack) {
        return false;
    }

    @Override
    public List<OBB> getOBBs() {
        return List.of(this.barrel[0], this.barrel[1], this.barrel[2], this.barrel[3], this.barrel[4], this.barrel[5], this.barrel[6], this.barrel[7], this.barrel[8], this.barrel[9], this.barrel[10], this.barrel[11], this.hoe1, this.hoe2, this.yawController, this.pitchController, this.wheel1, this.wheel2, this.body1, this.body2);
    }

    @Override
    public void updateOBB() {
        Matrix4d transform = this.getVehicleTransform(1.0f);
        Vector4d worldPosition = this.transformPosition(transform, 0.875, 0.1875, -1.625);
        this.hoe1.center().set((Vector3fc)new Vector3f((float)worldPosition.x, (float)worldPosition.y, (float)worldPosition.z));
        this.hoe1.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4d worldPosition2 = this.transformPosition(transform, -0.875, 0.1875, -1.625);
        this.hoe2.center().set((Vector3fc)new Vector3f((float)worldPosition2.x, (float)worldPosition2.y, (float)worldPosition2.z));
        this.hoe2.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4d worldPositionW = this.transformPosition(transform, 0.90625, 0.390625, 0.1071875);
        this.wheel1.center().set((Vector3fc)new Vector3f((float)worldPositionW.x, (float)worldPositionW.y, (float)worldPositionW.z));
        this.wheel1.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4d worldPositionW2 = this.transformPosition(transform, -0.90625, 0.390625, 0.1071875);
        this.wheel2.center().set((Vector3fc)new Vector3f((float)worldPositionW2.x, (float)worldPositionW2.y, (float)worldPositionW2.z));
        this.wheel2.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4d worldPositionBody2 = this.transformPosition(transform, 0.0, 0.42546875, -0.090625);
        this.body2.center().set((Vector3fc)new Vector3f((float)worldPositionBody2.x, (float)worldPositionBody2.y, (float)worldPositionBody2.z));
        this.body2.setRotation(VectorTool.combineRotationsBarrel(1.0f, this));
        Matrix4d transformT = this.getTurretTransform(1.0f);
        Vector4d worldPositionYaw = this.transformPosition(transformT, 0.62625, 0.0396875, -0.5);
        this.yawController.center().set((Vector3fc)new Vector3f((float)worldPositionYaw.x, (float)worldPositionYaw.y, (float)worldPositionYaw.z));
        this.yawController.setRotation(VectorTool.combineRotationsTurret(1.0f, this));
        Vector4d worldPositionPitch = this.transformPosition(transformT, 0.7825, 0.5771875, -0.024375);
        this.pitchController.center().set((Vector3fc)new Vector3f((float)worldPositionPitch.x, (float)worldPositionPitch.y, (float)worldPositionPitch.z));
        this.pitchController.setRotation(VectorTool.combineRotationsTurret(1.0f, this));
        Matrix4d transformB = this.getBarrelTransform(1.0f);
        double i = 0.24375f;
        this.setBarrelOBB(0, -0.3659375, 0.244375);
        this.setBarrelOBB(1, -0.3659375 + i, 0.244375);
        this.setBarrelOBB(2, -0.3659375 + 2.0 * i, 0.244375);
        this.setBarrelOBB(3, -0.3659375 + 3.0 * i, 0.244375);
        this.setBarrelOBB(4, -0.3659375, 0.244375 - i);
        this.setBarrelOBB(5, -0.3659375 + i, 0.244375 - i);
        this.setBarrelOBB(6, -0.3659375 + 2.0 * i, 0.244375 - i);
        this.setBarrelOBB(7, -0.3659375 + 3.0 * i, 0.244375 - i);
        this.setBarrelOBB(8, -0.3659375, 0.244375 - 2.0 * i);
        this.setBarrelOBB(9, -0.3659375 + i, 0.244375 - 2.0 * i);
        this.setBarrelOBB(10, -0.3659375 + 2.0 * i, 0.244375 - 2.0 * i);
        this.setBarrelOBB(11, -0.3659375 + 3.0 * i, 0.244375 - 2.0 * i);
        Vector4d worldPositionBody1 = this.transformPosition(transformB, 0.0, 0.0, 0.3740625);
        this.body1.center().set((Vector3fc)new Vector3f((float)worldPositionBody1.x, (float)worldPositionBody1.y, (float)worldPositionBody1.z));
        this.body1.setRotation(VectorTool.combineRotationsBarrel(1.0f, this));
    }

    private void setBarrelOBB(int index, double x, double y) {
        Vector4d vec = this.transformPosition(this.getBarrelTransform(1.0f), x, y, -0.44625);
        this.barrel[index].center().set((Vector3fc)new Vector3f((float)vec.x, (float)vec.y, (float)vec.z));
        this.barrel[index].setRotation(VectorTool.combineRotationsBarrel(1.0f, this));
    }

    @Override
    public void m_6596_() {
        IntArrayList list = new IntArrayList();
        for (ItemStack item : this.items) {
            Item item2 = item.m_41720_();
            if (item2 instanceof MediumRocketItem) {
                MediumRocketItem mediumRocketItem = (MediumRocketItem)item2;
                list.add(mediumRocketItem.type.ordinal());
                continue;
            }
            list.add(-1);
        }
        this.f_19804_.m_135381_(LOADED_AMMO, (Object)list);
    }
}

