/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.block.VehicleAssemblingTableBlock;
import com.atsuishio.superbwarfare.block.property.BlockPart;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.menu.VehicleAssemblingMenu;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class VehicleAssemblingTableVehicleEntity
extends GeoVehicleEntity
implements HasCustomInventoryScreen,
MenuProvider {
    public float deltaXo;
    public float deltaYo;
    public float deltaX;
    public float deltaY;
    public int jumpCooldown;

    public VehicleAssemblingTableVehicleEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public VehicleAssemblingTableVehicleEntity(Level world) {
        this((EntityType)ModEntities.VEHICLE_ASSEMBLING_TABLE.get(), world);
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        if (player.m_21205_().m_204117_(ModTags.Items.TOOLS_CROWBAR) && !player.m_6047_()) {
            if (!this.m_9236_().f_46443_ && this.m_20197_().isEmpty()) {
                BlockPos blockPos;
                Direction facing = this.m_6350_();
                Vec3 currentPos = this.m_20182_();
                Vec3 targetPos = switch (facing) {
                    case Direction.WEST -> currentPos.m_82520_(-0.5, 0.0, -0.5);
                    case Direction.EAST -> currentPos.m_82520_(0.5, 0.0, 0.5);
                    case Direction.NORTH -> currentPos.m_82520_(0.5, 0.0, -0.5);
                    case Direction.SOUTH -> currentPos.m_82520_(-0.5, 0.0, 0.5);
                    default -> currentPos;
                };
                BlockPos targetBlockPos = BlockPos.m_274446_((Position)targetPos);
                boolean canPlace = true;
                for (BlockPart part : BlockPart.values()) {
                    blockPos = part.relative(targetBlockPos, facing);
                    BlockState blockState = this.m_9236_().m_8055_(blockPos);
                    if (blockState.m_247087_()) continue;
                    canPlace = false;
                    break;
                }
                if (canPlace) {
                    for (BlockPart part : BlockPart.values()) {
                        blockPos = part.relative(targetBlockPos, facing);
                        BlockState state = (BlockState)((BlockState)((Block)ModBlocks.VEHICLE_ASSEMBLING_TABLE.get()).m_49966_().m_61124_((Property)VehicleAssemblingTableBlock.FACING, (Comparable)facing)).m_61124_(VehicleAssemblingTableBlock.BLOCK_PART, (Comparable)((Object)part));
                        this.m_9236_().m_7731_(blockPos, state, 3);
                    }
                    this.m_146870_();
                    return InteractionResult.SUCCESS;
                }
                player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.vehicle_assembling_table.warn").m_130940_(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
        return super.m_6096_(player, hand);
    }

    @Override
    public void m_6075_() {
        this.deltaXo = this.deltaX;
        this.deltaYo = this.deltaY;
        super.m_6075_();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        this.deltaX = this.getMouseMoveSpeedY();
        if (this.leftInputDown() && this.rightInputDown()) {
            this.deltaX = 0.0f;
        } else if (this.leftInputDown()) {
            this.deltaX = -1.0f;
        } else if (this.rightInputDown()) {
            this.deltaX = 1.0f;
        }
        float f = this.m_20096_() ? 0.85f : 0.9f;
        this.m_20256_(this.m_20184_().m_82542_((double)f, (double)f, (double)f));
        if (this.m_20069_() && this.f_19797_ % 4 == 0) {
            this.m_20256_(this.m_20184_().m_82542_(0.6, 0.6, 0.6));
            if (this.lastTickSpeed > 0.4) {
                this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, this.m_146895_() == null ? this : this.m_146895_()), (float)(20.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
            }
        }
    }

    @Override
    public void travel() {
        Entity passenger = this.m_146895_();
        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.95f));
        if (passenger == null || this.m_20069_()) {
            this.setLeftInputDown(false);
            this.setRightInputDown(false);
            this.setForwardInputDown(false);
            this.setBackInputDown(false);
            this.m_20256_(this.m_20184_().m_82542_(0.96, 1.0, 0.96));
        } else if (passenger instanceof Player) {
            if (this.forwardInputDown()) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 0.1f), (float)1.0f)));
            }
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * 0.8f));
            if (this.backInputDown()) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - (((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.0f ? 0.1f : 0.01f)), (float)(this.m_20096_() ? -0.2f : 0.2f))));
                if (this.rightInputDown()) {
                    this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.4f));
                } else if (this.leftInputDown()) {
                    this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.4f));
                }
            } else if (this.rightInputDown()) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.4f));
            } else if (this.leftInputDown()) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.4f));
            }
            if (this.downInputDown()) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(0.0f));
            }
            if (this.upInputDown() && this.m_20096_() && this.jumpCooldown == 0) {
                this.jumpCooldown = 40;
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    server.m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.WHEEL_CHAIR_JUMP.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
                }
                Vec3 movement = this.m_20156_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(0.7);
                this.m_20256_(this.m_20184_().m_82520_(movement.f_82479_, 1.0, movement.f_82481_));
            }
            float diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.m_14177_((float)(passenger.m_6080_() - this.m_146908_())));
            float diffX = Math.clamp((float)-60.0f, (float)60.0f, (float)Mth.m_14177_((float)(passenger.m_146909_() - this.m_146909_())));
            float addX = Mth.m_14036_((float)(Math.min((float)((float)Math.max((double)(this.m_20184_().m_82553_() - 0.1), (double)0.01)), (float)0.9f) * diffX), (float)-4.0f, (float)4.0f);
            float addZ = ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - (this.m_20096_() ? 0.0f : 0.01f) * diffY * (float)this.m_20184_().m_82553_();
            float yRotSync = (float)(-Mth.m_14008_((double)(50.0 * this.m_20184_().m_82553_()), (double)2.0, (double)4.0) * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue());
            this.m_146922_(this.m_146908_() + yRotSync);
            this.m_146926_(Mth.m_14036_((float)(this.m_146909_() + addX), (float)(this.m_20096_() ? -12.0f : -120.0f), (float)(this.m_20096_() ? 3.0f : 120.0f)));
            this.setZRot(this.getRoll() - 0.2f * addZ);
        }
        double powerValue = 0.05 * (double)((Float)this.f_19804_.m_135370_(POWER)).floatValue();
        this.m_20256_(this.m_20184_().m_82549_(this.m_20156_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82542_(powerValue, powerValue, powerValue)));
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.m_9236_() instanceof ServerLevel) {
            ItemEntity item = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ModItems.VEHICLE_ASSEMBLING_TABLE.get()));
            item.m_32010_(50);
            this.m_9236_().m_7967_((Entity)item);
        }
    }

    @Override
    @NotNull
    public List<ItemStack> getRetrieveItems() {
        return List.of(new ItemStack((ItemLike)ModItems.VEHICLE_ASSEMBLING_TABLE.get()));
    }

    @Override
    public void m_213583_(@NotNull Player player) {
        player.m_5893_((MenuProvider)this);
    }

    @Override
    @ParametersAreNonnullByDefault
    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new VehicleAssemblingMenu(i, inventory, ContainerLevelAccess.f_39287_, true);
    }
}

