/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.utils;

import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.data.vehicle.subdata.CollisionLevel;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.vehicle.Type63Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleEngineUtils;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector4d;

public final class VehicleMotionUtils {
    public static void preventStacking(VehicleEntity vehicle) {
        List entities = vehicle.m_9236_().m_142425_(EntityTypeTest.m_156916_(VehicleEntity.class), vehicle.m_20191_().m_82400_(6.0), entity -> entity != vehicle && entity != vehicle.m_146895_() && entity.m_20202_() == null);
        for (VehicleEntity entity2 : entities) {
            if (!entity2.m_20191_().m_82381_(vehicle.m_20191_())) continue;
            Vec3 toVec = vehicle.m_20182_().m_82549_(new Vec3(1.0, 1.0, 1.0).m_82490_((double)(vehicle.getRandom().m_188501_() * 0.01f + 1.0f))).m_82505_(entity2.m_20182_());
            Vec3 velAdd = toVec.m_82541_().m_82490_(Math.max((double)((double)(vehicle.m_20205_() + 2.0f) - vehicle.m_20182_().m_82554_(entity2.m_20182_())), (double)0.0) * 0.1);
            double entitySize = entity2.m_20205_() * entity2.m_20206_();
            double thisSize = vehicle.m_20205_() * vehicle.m_20206_();
            double f = Math.min((double)(entitySize / thisSize), (double)2.0);
            double f1 = Math.min((double)(thisSize / entitySize), (double)2.0);
            vehicle.pushNew(-f * velAdd.f_82479_, -f * velAdd.f_82480_, -f * velAdd.f_82481_);
            entity2.m_5997_(f1 * velAdd.f_82479_, f1 * velAdd.f_82480_, f1 * velAdd.f_82481_);
        }
    }

    public static void supportEntities(VehicleEntity vehicle) {
        if (vehicle.m_213877_()) {
            return;
        }
        if (vehicle.enableAABB() || vehicle instanceof Type63Entity) {
            return;
        }
        AABB frontBox = VehicleMotionUtils.calculateCombinedAABBOptimized(vehicle).m_82400_(1.0);
        List<Entity> entities = vehicle.m_9236_().m_142425_(EntityTypeTest.m_156916_(Entity.class), frontBox, entity -> entity != vehicle && entity != vehicle.m_146895_() && entity.m_20202_() == null).stream().filter(entity -> {
            if (entity.m_6084_() && vehicle.isInObb((Entity)entity, vehicle.m_20184_())) {
                Player player;
                LivingEntity living;
                ResourceLocation type = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
                if (type == null) {
                    return false;
                }
                return entity instanceof VehicleEntity || entity instanceof Boat || entity instanceof Minecart || entity instanceof LivingEntity && (!((living = (LivingEntity)entity) instanceof Player) || !(player = (Player)living).m_5833_()) || ((List)VehicleConfig.COLLISION_ENTITY_WHITELIST.get()).contains(type.toString());
            }
            return false;
        }).toList();
        entities.forEach(e -> {
            if (e instanceof Player) {
                Player player = (Player)e;
                if (vehicle.m_9236_().f_46443_) {
                    vehicle.support((Entity)player);
                    return;
                }
            }
            if (vehicle.m_9236_().f_46443_) return;
            vehicle.support((Entity)e);
        });
    }

    public static void support(VehicleEntity vehicle, Entity entity) {
        if (vehicle.enableAABB()) {
            return;
        }
        if (entity.f_19794_ || vehicle.f_19794_) {
            return;
        }
        Vec3 feetPos = entity.m_20182_().m_82546_(new Vec3(0.0, (double)0.1f, 0.0));
        Vec3 midPos = feetPos.m_82520_(0.0, (double)(entity.m_20192_() / 2.0f), 0.0);
        Vec3 eyePos = feetPos.m_82520_(0.0, (double)entity.m_20192_(), 0.0);
        for (OBB obb : vehicle.getOBBs()) {
            double dz;
            double dx;
            double dMax;
            Player player;
            if (entity instanceof Player && (player = (Player)entity).m_20096_() && player.m_6047_() && player.m_9236_() instanceof ServerLevel) {
                vehicle.m_20256_(vehicle.m_20184_().m_82549_(player.m_20156_()).m_82541_().m_82490_(player.m_20184_().m_82553_() * 3.0));
            }
            if (obb.contains(feetPos) && !entity.f_19794_ && !vehicle.f_19794_) {
                double gravity = Math.max((double)entity.m_20184_().f_82480_, (double)0.0);
                if (gravity == 0.0) {
                    entity.m_6853_(true);
                }
                double depth = obb.getEmbeddingDepth(feetPos);
                entity.m_20256_(vehicle.m_20184_().m_82520_(0.0, gravity + depth <= (double)0.2f ? 0.0 : depth * 1.1, 0.0));
                entity.f_19789_ = 0.0f;
                continue;
            }
            if (obb.contains(eyePos) && (dMax = Mth.m_14005_((double)(dx = entity.m_20185_() - obb.center().x), (double)(dz = entity.m_20189_() - obb.center().z))) >= (double)0.01f) {
                dMax = Math.sqrt((double)dMax);
                dx /= dMax;
                dz /= dMax;
                double d = 1.0 / dMax;
                if (d > 1.0) {
                    d = 1.0;
                }
                dx *= d;
                dz *= d;
                dx *= (double)0.05f;
                dz *= (double)0.05f;
                if (!entity.m_6094_()) continue;
                entity.m_5997_(dx, 0.0, dz);
                continue;
            }
            AABB aabb = entity.m_20191_();
            if (!OBB.isColliding(obb, aabb)) continue;
            int face = obb.getEmbeddingFace(midPos);
            Vector3d[] axes = obb.getAxes();
            Vector3d support = axes[Math.abs((int)face) - 1];
            if (face < 0) {
                support.negate();
            }
            if (!entity.m_6094_()) continue;
            float force = 0.1f;
            if (vehicle.m_20184_().m_82553_() > 0.01 && Math.abs((int)face) != 2) {
                force = 0.2f;
            }
            Vec3 vec = OBB.vector3dToVec3(support).m_82490_((double)force);
            vec = new Vec3(vec.f_82479_, Math.max((double)0.0, (double)vec.f_82480_), vec.f_82481_);
            entity.m_146884_(entity.m_20182_().m_82549_(vec));
            entity.m_20256_(entity.m_20184_().m_82542_(0.2, 0.2, 0.2));
            vehicle.f_19812_ = true;
        }
    }

    public static void crushEntities(VehicleEntity vehicle) {
        List<Entity> entities;
        if (!vehicle.canCrushEntities()) {
            return;
        }
        if (vehicle.m_213877_()) {
            return;
        }
        Vec3 vec3 = vehicle.m_20184_();
        if (!vehicle.enableAABB()) {
            frontBox = vehicle.m_20191_().m_82383_(vec3).m_82400_(6.0);
            entities = vehicle.m_9236_().m_142425_(EntityTypeTest.m_156916_(Entity.class), frontBox, entity -> entity != vehicle && entity != vehicle.m_146895_() && entity.m_20202_() == null).stream().filter(entity -> {
                if (entity.m_6084_() && vehicle.isInObb((Entity)entity, vec3)) {
                    Player player;
                    LivingEntity living;
                    ResourceLocation type = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
                    if (type == null) {
                        return false;
                    }
                    return entity instanceof VehicleEntity || entity instanceof Boat || entity instanceof Minecart || entity instanceof LivingEntity && (!((living = (LivingEntity)entity) instanceof Player) || !(player = (Player)living).m_5833_()) || ((List)VehicleConfig.COLLISION_ENTITY_WHITELIST.get()).contains(type.toString());
                }
                return false;
            }).toList();
        } else {
            frontBox = vehicle.m_20191_().m_82383_(vec3);
            entities = vehicle.m_9236_().m_142425_(EntityTypeTest.m_156916_(Entity.class), frontBox, entity -> entity != vehicle && entity != vehicle.m_146895_() && entity.m_20202_() == null).stream().filter(entity -> {
                if (entity.m_6084_()) {
                    Player player;
                    LivingEntity living;
                    ResourceLocation type = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
                    if (type == null) {
                        return false;
                    }
                    return entity instanceof VehicleEntity || entity instanceof Boat || entity instanceof Minecart || entity instanceof LivingEntity && (!((living = (LivingEntity)entity) instanceof Player) || !(player = (Player)living).m_5833_()) || ((List)VehicleConfig.COLLISION_ENTITY_WHITELIST.get()).contains(type.toString());
                }
                return false;
            }).toList();
        }
        for (Entity entity2 : entities) {
            Vec3 vec31;
            double f1;
            double f;
            LivingEntity living;
            double entitySize = entity2.m_20191_().m_82309_();
            double thisSize = vehicle.m_20191_().m_82309_();
            Vec3 v0 = vec3.m_82546_(entity2.m_20184_());
            if (VectorTool.calculateAngle(v0, vehicle.m_20182_().m_82505_(entity2.m_20182_())) > 90.0) {
                return;
            }
            if (vehicle.m_20184_().m_82556_() < 0.09) {
                return;
            }
            if (entity2 instanceof LivingEntity && (living = (LivingEntity)entity2).m_21023_((MobEffect)ModMobEffects.STRIKE_PROTECTION.get())) continue;
            if (entity2 instanceof VehicleEntity) {
                VehicleEntity v = (VehicleEntity)entity2;
                f = Mth.m_14008_((double)(v.getMass() / vehicle.getMass()), (double)0.25, (double)4.0);
                f1 = Mth.m_14008_((double)(vehicle.getMass() / vehicle.getMass()), (double)0.25, (double)4.0);
            } else {
                f = Mth.m_14008_((double)(entitySize / thisSize), (double)0.25, (double)4.0);
                f1 = Mth.m_14008_((double)(thisSize / entitySize), (double)0.25, (double)4.0);
            }
            float length = (float)v0.m_82553_();
            Vec3 velAdd = v0.m_82541_().m_82490_(0.8 * (double)length);
            if ((double)length <= 0.3) continue;
            vehicle.m_9236_().m_6269_(null, (Entity)vehicle, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), vehicle.m_5720_(), 1.0f, 1.0f);
            if (entity2 instanceof LivingEntity) {
                DamageHandler.doDamage(entity2, ModDamageTypes.causeVehicleStrikeDamage(vehicle.m_9236_().m_9598_(), vehicle, vehicle.m_146895_() == null ? vehicle : vehicle.m_146895_()), (float)(f1 * 80.0 * ((double)Mth.m_14154_((float)length) - 0.3) * ((double)Mth.m_14154_((float)length) - 0.3)));
            } else {
                entity2.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(vehicle.m_9236_().m_9598_(), vehicle, vehicle.m_146895_() == null ? vehicle : vehicle.m_146895_()), (float)(f1 * 60.0 * ((double)Mth.m_14154_((float)length) - 0.3) * ((double)Mth.m_14154_((float)length) - 0.3)));
            }
            if (!(entity2 instanceof TargetEntity)) {
                vehicle.pushNew((double)-0.3f * f * velAdd.f_82479_, (double)-0.3f * f * velAdd.f_82480_, (double)-0.3f * f * velAdd.f_82481_);
            }
            if (entity2 instanceof VehicleEntity) {
                VehicleEntity mobileVehicle = (VehicleEntity)entity2;
                vehicle.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(vehicle.m_9236_().m_9598_(), entity2, entity2.m_146895_() == null ? entity2 : entity2.m_146895_()), (float)(f * 40.0 * ((double)Mth.m_14154_((float)length) - 0.3) * ((double)Mth.m_14154_((float)length) - 0.3)));
                if (!vehicle.enableAABB() && vehicle.isInObb(entity2, Vec3.f_82478_)) {
                    Vec3 thisPos = vehicle.m_20182_();
                    Vec3 otherPos = entity2.m_20182_();
                    for (OBB obb : vehicle.getOBBs()) {
                        if (!mobileVehicle.enableAABB()) {
                            List<OBB> obbList2 = mobileVehicle.getOBBs();
                            for (OBB obb2 : obbList2) {
                                if (!OBB.isColliding(obb, obb2)) continue;
                                thisPos = OBB.vector3dToVec3(obb.center());
                                otherPos = OBB.vector3dToVec3(obb2.center());
                            }
                            continue;
                        }
                        if (!OBB.isColliding(obb, entity2.m_20191_())) continue;
                        thisPos = OBB.vector3dToVec3(obb.center());
                    }
                    Vec3 toVec = thisPos.m_82549_(new Vec3(1.0, 1.0, 1.0).m_82490_((double)(vehicle.getRandom().m_188501_() * 0.01f + 1.0f))).m_82505_(otherPos);
                    velAdd = toVec.m_82541_().m_82490_(Math.max((double)thisPos.m_82554_(otherPos), (double)0.0) * 0.01);
                    vehicle.pushNew(-f * velAdd.f_82479_, -f * velAdd.f_82480_, -f * velAdd.f_82481_);
                }
                vec31 = vehicle.m_20184_().m_82541_().m_82490_(velAdd.m_82553_());
                mobileVehicle.pushNew(f1 * vec31.f_82479_, f1 * vec31.f_82480_, f1 * vec31.f_82481_);
                continue;
            }
            vec31 = vehicle.m_20184_().m_82541_().m_82490_(velAdd.m_82553_());
            entity2.m_5997_(f1 * vec31.f_82479_, f1 * vec31.f_82480_, f1 * vec31.f_82481_);
        }
    }

    public static AABB calculateCombinedAABBOptimized(VehicleEntity vehicle) {
        if (vehicle.enableAABB()) {
            return vehicle.m_20191_();
        }
        List<OBB> obbList = vehicle.getOBBs();
        Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (OBB obb : obbList) {
            Vector3d[] vertices;
            for (Vector3d vertex : vertices = obb.getVertices()) {
                min.x = Math.min((double)min.x, (double)vertex.x);
                min.y = Math.min((double)min.y, (double)vertex.y);
                min.z = Math.min((double)min.z, (double)vertex.z);
                max.x = Math.max((double)max.x, (double)vertex.x);
                max.y = Math.max((double)max.y, (double)vertex.y);
                max.z = Math.max((double)max.z, (double)vertex.z);
            }
        }
        return new AABB(OBB.vector3dToVec3(min), OBB.vector3dToVec3(max));
    }

    public static void collideBlocks(VehicleEntity vehicle) {
        CollisionLevel collisionLevel = vehicle.computed().collisionLevel;
        List<CollisionLevel.Limit> limits = collisionLevel.powerLimits;
        float power = ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue();
        double motion = vehicle.m_20184_().m_165924_();
        boolean[] flags = new boolean[]{(Boolean)VehicleConfig.COLLISION_DESTROY_SOFT_BLOCKS.get() != false && collisionLevel.level >= 1, (Boolean)VehicleConfig.COLLISION_DESTROY_NORMAL_BLOCKS.get() != false && collisionLevel.level >= 2, (Boolean)VehicleConfig.COLLISION_DESTROY_HARD_BLOCKS.get() != false && collisionLevel.level >= 3, (Boolean)VehicleConfig.COLLISION_DESTROY_BLOCKS_BEASTLY.get() != false && collisionLevel.level >= 4};
        for (int i = 0; i < flags.length && i < limits.size(); ++i) {
            CollisionLevel.Limit limit = limits.get(i);
            int n = i;
            flags[n] = flags[n] & (limit.equals() ? power >= limit.power() || motion >= (double)limit.motion() : power > limit.power() || motion > (double)limit.motion());
        }
        if (!vehicle.enableAABB()) {
            AABB aabb = vehicle.m_20191_().m_82383_(vehicle.m_20184_()).m_82400_(5.0);
            BlockPos.m_121921_((AABB)aabb).forEach(pos -> {
                BlockState blockstate = vehicle.m_9236_().m_8055_(pos);
                if (vehicle.isInObb((BlockPos)pos, vehicle.m_20184_()) && (flags[0] && blockstate.m_204336_(ModTags.Blocks.SOFT_COLLISION) || flags[1] && blockstate.m_204336_(ModTags.Blocks.NORMAL_COLLISION) || flags[2] && blockstate.m_204336_(ModTags.Blocks.HARD_COLLISION) || flags[3] && (blockstate.m_60734_().m_155943_() > 0.0f || blockstate.m_60734_().m_155943_() <= 4.0f))) {
                    vehicle.m_9236_().m_46961_(pos, true);
                }
            });
        }
        AABB aabb = vehicle.m_20191_().m_82377_(0.25, 0.0, 0.25).m_82383_(vehicle.m_20184_()).m_82386_(0.0, 0.5, 0.0);
        BlockPos.m_121921_((AABB)aabb).forEach(pos -> {
            BlockState blockstate = vehicle.m_9236_().m_8055_(pos);
            if (flags[0] && blockstate.m_204336_(ModTags.Blocks.SOFT_COLLISION) || flags[1] && blockstate.m_204336_(ModTags.Blocks.NORMAL_COLLISION) || flags[2] && blockstate.m_204336_(ModTags.Blocks.HARD_COLLISION) || flags[3] && (blockstate.m_60734_().m_155943_() > 0.0f || blockstate.m_60734_().m_155943_() <= 4.0f)) {
                vehicle.m_9236_().m_46961_(pos, true);
            }
        });
    }

    public static void handleVehicleMoveOnDragonTeeth(VehicleEntity vehicle) {
        AABB aabb = vehicle.m_20191_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 1.0E-6, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        BlockPos pos = vehicle.m_9236_().m_285750_((Entity)vehicle, aabb1).orElse(null);
        if (pos == null) {
            return;
        }
        BlockState state = vehicle.m_9236_().m_8055_(pos);
        if (state.m_60713_((Block)ModBlocks.DRAGON_TEETH.get())) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.8f));
            vehicle.m_20256_(vehicle.m_20184_().m_82542_(-0.1, 0.0, -0.1));
        }
    }

    public static void bounceHorizontal(VehicleEntity vehicle, Direction direction) {
        switch (direction.m_122434_()) {
            case X: {
                vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.8, 0.99, 0.99));
                break;
            }
            case Z: {
                vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.99, 0.99, 0.8));
            }
        }
    }

    public static void bounceVertical(VehicleEntity vehicle, Direction direction) {
        if (!vehicle.m_9236_().f_46443_) {
            vehicle.m_9236_().m_6269_(null, (Entity)vehicle, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), vehicle.m_5720_(), 1.0f, 1.0f);
        }
        vehicle.collisionCoolDown = 4;
        vehicle.setCrash(true);
        if (direction.m_122434_() == Direction.Axis.Y) {
            vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.9, -0.8, 0.9));
        }
    }

    public static void terrainCompact(VehicleEntity vehicle, List<Vec3> positions) {
        if (vehicle.m_20096_()) {
            Matrix4d transform = vehicle.getWheelsTransform(1.0f);
            for (Vec3 vec3 : positions) {
                BlockState state;
                VoxelShape shape;
                Vector4d Vector4d2 = VehicleVecUtils.transformPosition(transform, vec3.f_82479_, vec3.f_82480_ - 0.02, vec3.f_82481_);
                Vec3 p = new Vec3(Vector4d2.x, Vector4d2.y, Vector4d2.z);
                Level level = vehicle.m_9236_();
                BlockHitResult res = level.m_45547_(new ClipContext(p, p.m_82520_(0.0, -512.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)vehicle));
                BlockPos blockPos = BlockPos.m_274446_((Position)p);
                BlockPos blockPosUp = BlockPos.m_274446_((Position)p.m_82520_(0.0, 1.0, 0.0));
                if (level.m_8055_(blockPosUp).m_60815_()) {
                    blockPos = blockPosUp;
                }
                double heightY = !(shape = (state = level.m_8055_(blockPos)).m_60812_((BlockGetter)level, blockPos)).m_83281_() ? p.f_82480_ - (shape.m_83297_(Direction.Axis.Y) + (double)blockPos.m_123342_()) : (res.m_6662_() == HitResult.Type.BLOCK && level.m_45772_(new AABB(p, p)) ? Mth.m_14008_((double)(p.f_82480_ - res.m_82450_().f_82480_), (double)0.0, (double)20.0) : 0.0);
                VehicleMotionUtils.updateTerrainCompact(vehicle, p, heightY);
            }
        } else if (vehicle.isInFluidType()) {
            vehicle.m_146926_(vehicle.m_146909_() * 0.9f);
            vehicle.setZRot(vehicle.getRoll() * 0.9f);
        }
    }

    public static void updateTerrainCompact(VehicleEntity entity, Vec3 landingTarget, double heightY) {
        Vec3 horizontalOffset;
        double horizontalDistance;
        Vec3 currentPos = entity.m_20182_();
        AABB aabb = entity.m_20191_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 1.0E-6, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        Optional optional = entity.m_9236_().m_285750_((Entity)entity, aabb1);
        if (optional.isPresent()) {
            currentPos = currentPos.m_82549_(currentPos.m_82505_(((BlockPos)optional.get()).m_252807_()).m_82490_(0.6));
        }
        Vec3 horizontalDirection = (horizontalDistance = (horizontalOffset = new Vec3(landingTarget.f_82479_ - currentPos.f_82479_, 0.0, landingTarget.f_82481_ - currentPos.f_82481_)).m_82553_()) > 0.0 ? horizontalOffset.m_82541_() : Vec3.f_82478_;
        float tiltSmoothingFactor = 0.03f;
        float targetTilt = (float)Math.min((double)(heightY * 9.0 * (double)entity.data().compute().terrainCompatRotateRate * horizontalDistance), (double)45.0);
        float yawRad = Math.toRadians((float)(-entity.m_146908_()));
        Vec3 localDirection = new Vec3(horizontalDirection.f_82479_ * (double)Math.cos((float)yawRad) - horizontalDirection.f_82481_ * (double)Math.sin((float)yawRad), 0.0, horizontalDirection.f_82479_ * (double)Math.sin((float)yawRad) + horizontalDirection.f_82481_ * (double)Math.cos((float)yawRad));
        float targetXRot = (float)(-localDirection.f_82481_ * (double)targetTilt);
        float targetZRot = (float)(localDirection.f_82479_ * (double)targetTilt);
        entity.m_146926_(VehicleEngineUtils.lerpAngle(entity.m_146909_(), -targetXRot, tiltSmoothingFactor));
        entity.setZRot(VehicleEngineUtils.lerpAngle(entity.getRoll(), -targetZRot, tiltSmoothingFactor));
    }

    public static Matrix4d getWheelsTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transform = new Matrix4d();
        transform.translate((double)((float)Mth.m_14139_((double)partialTicks, (double)vehicle.f_19854_, (double)vehicle.m_20185_())), (double)((float)Mth.m_14139_((double)partialTicks, (double)vehicle.f_19855_, (double)vehicle.m_20186_())), (double)((float)Mth.m_14139_((double)partialTicks, (double)vehicle.f_19856_, (double)vehicle.m_20189_())));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-Mth.m_14179_((float)partialTicks, (float)vehicle.f_19859_, (float)vehicle.m_146908_())));
        return transform;
    }
}

