/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.utils;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.projectile.FlareDecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmokeDecoyEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.RangeTool;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.joml.Matrix4d;
import org.joml.Vector4d;

public final class VehicleWeaponUtils {
    public static void adjustTurretAngle(VehicleEntity vehicle) {
        float ySpeed = vehicle.getTurretTurnYSpeed();
        float xSpeed = vehicle.getTurretTurnXSpeed();
        Entity driver = vehicle.getNthEntity(vehicle.getTurretControllerIndex());
        if (driver == null) {
            vehicle.turretYRotLock = 0.0f;
        } else {
            float turretAngle = -Mth.m_14177_((float)(driver.m_6080_() - vehicle.m_146908_()));
            float diffY = Mth.m_14177_((float)(turretAngle - vehicle.getTurretYRot()));
            float diffX = Mth.m_14177_((float)(driver.m_146909_() - vehicle.getTurretXRot()));
            vehicle.turretTurnSound(diffX, diffY, 0.95f);
            if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.TURRET_DAMAGED)).booleanValue()) {
                ySpeed *= 0.2f;
                xSpeed *= 0.2f;
            }
            float min = -ySpeed;
            float max = ySpeed;
            vehicle.setTurretXRot(Mth.m_14036_((float)(vehicle.getTurretXRot() + Mth.m_14036_((float)(0.95f * diffX), (float)(-xSpeed), (float)xSpeed)), (float)-89.5f, (float)89.5f));
            vehicle.setTurretYRot(vehicle.getTurretYRot() + Mth.m_14036_((float)(0.9f * diffY), (float)min, (float)max));
            vehicle.turretYRotLock = Mth.m_14036_((float)(0.9f * diffY), (float)min, (float)max);
        }
    }

    public static void turretAutoAimFromVector(VehicleEntity vehicle, Vec3 shootVec) {
        float ySpeed = vehicle.getTurretTurnYSpeed();
        float xSpeed = vehicle.getTurretTurnXSpeed();
        Vec3 barrelVector = vehicle.getBarrelVector(1.0f);
        float diffY = (float)Mth.m_14175_((double)(-VehicleVecUtils.getYRotFromVector(shootVec) + VehicleVecUtils.getYRotFromVector(barrelVector)));
        float diffX = (float)Mth.m_14175_((double)(-VehicleVecUtils.getXRotFromVector(shootVec) + VehicleVecUtils.getXRotFromVector(barrelVector)));
        vehicle.turretTurnSound(diffX, diffY, 0.95f);
        if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.TURRET_DAMAGED)).booleanValue()) {
            ySpeed *= 0.2f;
            xSpeed *= 0.2f;
        }
        float min = -ySpeed;
        float max = ySpeed;
        vehicle.setTurretXRot(Mth.m_14036_((float)(vehicle.getTurretXRot() + Mth.m_14036_((float)(0.99f * diffX), (float)(-xSpeed), (float)xSpeed)), (float)(-vehicle.getTurretMaxPitch()), (float)(-vehicle.getTurretMinPitch())));
        vehicle.setTurretYRot(Mth.m_14036_((float)(vehicle.getTurretYRot() - Mth.m_14036_((float)(0.99f * diffY), (float)min, (float)max)), (float)(-vehicle.getTurretMaxYaw()), (float)(-vehicle.getTurretMinYaw())));
        vehicle.turretYRotLock = Mth.m_14036_((float)(0.9f * diffY), (float)min, (float)max);
    }

    public static void turretAutoAimFromUuid(VehicleEntity vehicle, String uuid, LivingEntity pLiving) {
        Entity target = EntityFindUtil.findEntity(vehicle.m_9236_(), uuid);
        if (target == null) {
            return;
        }
        if (target.m_20202_() != null) {
            target = target.m_20202_();
        }
        Vec3 targetPos = target.m_20191_().m_82399_();
        Vec3 targetVel = target.m_20184_();
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            double gravity = living.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            targetVel = targetVel.m_82520_(0.0, gravity, 0.0);
        }
        if (target instanceof Player) {
            targetVel = targetVel.m_82542_(2.0, 1.0, 2.0);
        }
        Vec3 targetVec = RangeTool.calculateFiringSolution(vehicle.getShootPos((Entity)pLiving, 1.0f).m_82546_(vehicle.getShootVec((Entity)pLiving, 1.0f).m_82490_(vehicle.getShootPos((Entity)pLiving, 1.0f).m_82554_(pLiving.m_20182_()))), targetPos, targetVel, vehicle.getProjectileVelocity((Entity)pLiving), vehicle.getProjectileGravity((Entity)pLiving));
        vehicle.turretAutoAimFromVector(targetVec);
    }

    public static void releaseSmokeDecoy(VehicleEntity vehicle, Vec3 vec3) {
        if (vehicle.decoyInputDown()) {
            if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.DECOY_READY)).booleanValue() && vehicle.m_9236_() instanceof ServerLevel) {
                for (int i = 0; i < 8; ++i) {
                    SmokeDecoyEntity smokeDecoyEntity = new SmokeDecoyEntity(vehicle.m_9236_());
                    smokeDecoyEntity.m_6034_(vehicle.m_20185_(), vehicle.m_20186_() + (double)vehicle.m_20206_(), vehicle.m_20189_());
                    smokeDecoyEntity.decoyShoot(vehicle, vec3.m_82524_((-78.75f + 22.5f * (float)i) * ((float)Math.PI / 180)), 4.0f, 8.0f);
                    vehicle.m_9236_().m_7967_((Entity)smokeDecoyEntity);
                }
                vehicle.m_9236_().m_6269_(null, (Entity)vehicle, (SoundEvent)ModSounds.DECOY_RELEASE.get(), vehicle.m_5720_(), 1.0f, 1.0f);
                vehicle.decoyReloadCoolDown = 500;
                vehicle.m_20088_().m_135381_(VehicleEntity.DECOY_READY, (Object)false);
            }
            vehicle.setDecoyInputDown(false);
        }
        if (!((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.DECOY_READY)).booleanValue() && vehicle.decoyReloadCoolDown == 0 && vehicle.m_9236_() instanceof ServerLevel) {
            vehicle.m_20088_().m_135381_(VehicleEntity.DECOY_READY, (Object)true);
            vehicle.m_9236_().m_6269_(null, (Entity)vehicle, (SoundEvent)ModSounds.DECOY_RELOAD.get(), vehicle.m_5720_(), 1.0f, 1.0f);
            vehicle.decoyReloadCoolDown = 500;
        }
    }

    public static void releaseDecoy(VehicleEntity vehicle) {
        if (vehicle.decoyInputDown()) {
            if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.DECOY_READY)).booleanValue() && vehicle.m_9236_() instanceof ServerLevel) {
                for (int i = 0; i < 54; i += 6) {
                    int finalI = i;
                    Mod.queueServerWork(i, () -> {
                        Matrix4d transform = vehicle.getVehicleTransform(1.0f);
                        Vector4d worldPositionO = VehicleVecUtils.transformPosition(transform, 0.0, 0.0, 0.0);
                        Vector4d worldPosition = VehicleVecUtils.transformPosition(transform, 1.0, -0.2, 0.6);
                        Vector4d worldPosition2 = VehicleVecUtils.transformPosition(transform, -1.0, -0.2, 0.6);
                        Vec3 shootVecO = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
                        Vec3 shootVec1 = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
                        Vec3 shootVec2 = new Vec3(worldPosition2.x, worldPosition2.y, worldPosition2.z);
                        VehicleWeaponUtils.shootDecoy(vehicle, shootVecO.m_82505_(shootVec1).m_82541_(), finalI == 6);
                        VehicleWeaponUtils.shootDecoy(vehicle, shootVecO.m_82505_(shootVec2).m_82541_(), finalI == 6);
                    });
                }
                vehicle.decoyReloadCoolDown = 400;
                vehicle.m_20088_().m_135381_(VehicleEntity.DECOY_READY, (Object)false);
            }
            vehicle.setDecoyInputDown(false);
        }
        if (!((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.DECOY_READY)).booleanValue() && vehicle.decoyReloadCoolDown == 0 && vehicle.m_9236_() instanceof ServerLevel) {
            vehicle.m_20088_().m_135381_(VehicleEntity.DECOY_READY, (Object)true);
            vehicle.m_9236_().m_6269_(null, (Entity)vehicle, (SoundEvent)ModSounds.DECOY_RELOAD.get(), vehicle.m_5720_(), 1.0f, 1.0f);
            vehicle.decoyReloadCoolDown = 400;
        }
    }

    public static void shootDecoy(VehicleEntity vehicle, Vec3 shootVec, boolean first) {
        FlareDecoyEntity flareDecoyEntity = new FlareDecoyEntity(vehicle.m_9236_());
        flareDecoyEntity.m_6034_(vehicle.m_20185_() + vehicle.m_20184_().f_82479_, vehicle.m_20186_() + 0.5 + vehicle.m_20184_().f_82480_, vehicle.m_20189_() + vehicle.m_20184_().f_82481_);
        flareDecoyEntity.decoyShoot(vehicle, shootVec, (float)(vehicle.m_20184_().m_82553_() * (double)0.3f + 0.7), 8.0f);
        vehicle.m_9236_().m_7967_((Entity)flareDecoyEntity);
        vehicle.m_9236_().m_6269_(null, (Entity)vehicle, first ? (SoundEvent)ModSounds.DECOY_RELEASE_FIRST.get() : (SoundEvent)ModSounds.DECOY_RELEASE.get(), vehicle.m_5720_(), 2.0f, 1.0f);
    }
}

