/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.entity.projectile.M18SmokeGrenadeEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.DispenserLaunchable;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class M18SmokeGrenade
extends Item
implements DispenserLaunchable {
    public static final String TAG_COLOR = "Color";

    public M18SmokeGrenade() {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON));
    }

    public void setColor(ItemStack stack, int color) {
        stack.m_41784_().m_128405_(TAG_COLOR, color);
    }

    public int getColor(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_(TAG_COLOR) ? stack.m_41783_().m_128451_(TAG_COLOR) : 0xFFFFFF;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"des.superbwarfare.m18_smoke_grenade").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)("#" + Integer.toHexString(this.getColor(pStack)))).m_130948_(Style.f_131099_.m_178520_(this.getColor(pStack)))));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), (SoundEvent)ModSounds.GRENADE_PULL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.SPEAR;
    }

    @ParametersAreNonnullByDefault
    public void m_5551_(ItemStack stack, Level pLevel, LivingEntity entityLiving, int timeLeft) {
        if (!pLevel.f_46443_ && entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            int usingTime = this.m_8105_(stack) - timeLeft;
            if (usingTime > 3) {
                player.m_36335_().m_41524_(stack.m_41720_(), 20);
                float power = Math.min((float)usingTime / 8.0f, 1.8f);
                int color = this.getColor(stack);
                M18SmokeGrenadeEntity grenade = new M18SmokeGrenadeEntity((LivingEntity)player, pLevel, 80 - usingTime).setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
                grenade.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, power, 0.0f);
                pLevel.m_7967_((Entity)grenade);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), (SoundEvent)ModSounds.GRENADE_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (!pLevel.f_46443_) {
            Player player;
            int color = this.getColor(pStack);
            M18SmokeGrenadeEntity grenade = new M18SmokeGrenadeEntity(pLivingEntity, pLevel, 2).setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            pLevel.m_7967_((Entity)grenade);
            if (pLivingEntity instanceof Player) {
                player = (Player)pLivingEntity;
                player.m_36335_().m_41524_(pStack.m_41720_(), 20);
            }
            if (pLivingEntity instanceof Player && !(player = (Player)pLivingEntity).m_7500_()) {
                pStack.m_41774_(1);
            }
        }
        return super.m_5922_(pStack, pLevel, pLivingEntity);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 80;
    }

    @Override
    public DispenseItemBehavior getLaunchBehavior() {
        return new AbstractProjectileDispenseBehavior(){

            @ParametersAreNonnullByDefault
            @NotNull
            protected Projectile m_6895_(Level pLevel, Position pPosition, ItemStack pStack) {
                int color = M18SmokeGrenade.this.getColor(pStack);
                return new M18SmokeGrenadeEntity((EntityType<? extends M18SmokeGrenadeEntity>)((EntityType)ModEntities.M18_SMOKE_GRENADE.get()), pPosition.m_7096_(), pPosition.m_7098_(), pPosition.m_7094_(), pLevel).setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            }

            protected void m_6823_(@NotNull BlockSource pSource) {
                pSource.m_7727_().m_5594_(null, pSource.m_7961_(), (SoundEvent)ModSounds.GRENADE_THROW.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        };
    }
}

