/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mixins;

import com.atsuishio.superbwarfare.client.ICustomCamera;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class CameraMixin
implements ICustomCamera {
    @Shadow
    @Final
    private Quaternionf f_90559_;
    @Shadow
    @Final
    private Vector3f f_90554_;
    @Shadow
    @Final
    private Vector3f f_90555_;
    @Shadow
    @Final
    private Vector3f f_90556_;
    @Shadow
    private float f_90557_;
    @Shadow
    private float f_90558_;

    @Shadow(aliases={"Lnet/minecraft/client/Camera;setRotation(FF)V"})
    protected abstract void m_90572_(float var1, float var2);

    @Shadow(aliases={"Lnet/minecraft/client/Camera;setPosition(DDD)V"})
    protected abstract void m_90584_(double var1, double var3, double var5);

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setRotation(FF)V", ordinal=0)}, method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, cancellable=true)
    private void onSetup(BlockGetter level, Entity entity, boolean detached, boolean mirrored, float partialTicks, CallbackInfo info) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null) {
            ItemStack stack = player.m_21205_();
            if (stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && stack.m_41784_().m_128471_("Linked")) {
                DroneEntity drone = EntityFindUtil.findDrone(player.m_9236_(), stack.m_41784_().m_128461_("LinkedDrone"));
                if (drone != null) {
                    boolean firstPerson;
                    boolean bl = firstPerson = Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON || Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK;
                    if (firstPerson) {
                        Matrix4d transform = CameraMixin.superbWarfare$getDroneTransform(drone, partialTicks);
                        double x0 = 0.0;
                        double y0 = 0.075;
                        double z0 = 0.18;
                        Vector4d worldPosition = CameraMixin.superbWarfare$transformPosition(transform, x0, y0, z0);
                        this.m_90572_(drone.getYaw(partialTicks), drone.getPitch(partialTicks));
                        this.m_90584_(worldPosition.x, worldPosition.y, worldPosition.z);
                        info.cancel();
                    } else {
                        Vec3 position;
                        Vec2 rotation = drone.getCameraRotation(partialTicks, (Player)player, false, false);
                        if (rotation != null) {
                            this.m_90572_(rotation.f_82470_, rotation.f_82471_);
                        }
                        if ((position = drone.getCameraPosition(partialTicks, (Player)player, false, false)) != null) {
                            this.m_90584_(position.f_82479_, position.f_82480_, position.f_82481_);
                        }
                        if (rotation != null || position != null) {
                            info.cancel();
                        }
                    }
                }
                return;
            }
            Entity firstPerson = player.m_20202_();
            if (firstPerson instanceof VehicleEntity) {
                Vec3 position;
                VehicleEntity vehicle = (VehicleEntity)firstPerson;
                Vec2 rotation = vehicle.getCameraRotation(partialTicks, (Player)player, ClientEventHandler.zoomVehicle, Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON);
                if (rotation != null) {
                    this.m_90572_(rotation.f_82470_, rotation.f_82471_);
                }
                if ((position = vehicle.getCameraPosition(partialTicks, (Player)player, ClientEventHandler.zoomVehicle, Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON)) != null) {
                    this.m_90584_(position.f_82479_, position.f_82480_, position.f_82481_);
                }
                if (rotation != null || position != null) {
                    info.cancel();
                }
            }
        }
    }

    @Unique
    private static Matrix4d superbWarfare$getDroneTransform(DroneEntity vehicle, float ticks) {
        Matrix4d transform = new Matrix4d();
        transform.translate((double)((float)Mth.m_14139_((double)ticks, (double)vehicle.f_19854_, (double)vehicle.m_20185_())), (double)((float)Mth.m_14139_((double)ticks, (double)vehicle.f_19855_, (double)vehicle.m_20186_())), (double)((float)Mth.m_14139_((double)ticks, (double)vehicle.f_19856_, (double)vehicle.m_20189_())));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-vehicle.getYaw(ticks)));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_(vehicle.getBodyPitch(ticks)));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(vehicle.getRoll(ticks)));
        return transform;
    }

    @Unique
    private static Vector4d superbWarfare$transformPosition(Matrix4d transform, double x, double y, double z) {
        return transform.transform(new Vector4d(x, y, z, 1.0));
    }

    @Inject(method={"setup"}, at={@At(value="TAIL")})
    public void superbWarfare$setup(BlockGetter area, Entity entity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        Entity entity2;
        Player player;
        if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK && entity instanceof Player && (player = (Player)entity).m_21205_().m_41720_() instanceof GunItem && Math.max((double)ClientEventHandler.bowPullPos, (double)ClientEventHandler.zoomPos) > 0.0) {
            this.m_90568_(-this.m_90566_(-2.9 * Math.max((double)ClientEventHandler.bowPullPos, (double)ClientEventHandler.zoomPos)), 0.0, -ClientEventHandler.cameraLocation * Math.max((double)ClientEventHandler.bowPullPos, (double)ClientEventHandler.zoomPos));
            return;
        }
        if (!thirdPerson || !((entity2 = entity.m_20202_()) instanceof VehicleEntity)) {
            return;
        }
        VehicleEntity vehicle = (VehicleEntity)entity2;
        Vec3 cameraPosition = vehicle.getThirdPersonCameraPosition();
        this.m_90568_(-this.m_90566_(cameraPosition.m_7096_()), cameraPosition.m_7098_(), cameraPosition.m_7094_());
    }

    @Shadow
    protected abstract void m_90568_(double var1, double var3, double var5);

    @Shadow
    protected abstract double m_90566_(double var1);

    @Override
    public Quaternionf superbwarfare$getRotation() {
        return this.f_90559_;
    }
}

