/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network;

import com.atsuishio.superbwarfare.api.event.RegisterContainersEvent;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.ClientMotionSyncMessage;
import com.atsuishio.superbwarfare.network.message.receive.ClientSetMotionMessage;
import com.atsuishio.superbwarfare.network.message.receive.ClientTacticalSprintSyncMessage;
import com.atsuishio.superbwarfare.network.message.receive.ContainerDataMessage;
import com.atsuishio.superbwarfare.network.message.receive.DrawClientMessage;
import com.atsuishio.superbwarfare.network.message.receive.FinishAssemblingVehicleMessage;
import com.atsuishio.superbwarfare.network.message.receive.GunsDataMessage;
import com.atsuishio.superbwarfare.network.message.receive.LivingGunKillMessage;
import com.atsuishio.superbwarfare.network.message.receive.PlayerVariablesSyncMessage;
import com.atsuishio.superbwarfare.network.message.receive.RadarMenuCloseMessage;
import com.atsuishio.superbwarfare.network.message.receive.RadarMenuOpenMessage;
import com.atsuishio.superbwarfare.network.message.receive.ResetCameraTypeMessage;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.network.message.receive.ShootClientMessage;
import com.atsuishio.superbwarfare.network.message.receive.SoundClientMessage;
import com.atsuishio.superbwarfare.network.message.receive.TDMSyncMessage;
import com.atsuishio.superbwarfare.network.message.receive.VehiclesDataMessage;
import com.atsuishio.superbwarfare.network.message.send.AdjustMortarAngleMessage;
import com.atsuishio.superbwarfare.network.message.send.AdjustZoomFovMessage;
import com.atsuishio.superbwarfare.network.message.send.AimVillagerMessage;
import com.atsuishio.superbwarfare.network.message.send.ArtilleryIndicatorFireMessage;
import com.atsuishio.superbwarfare.network.message.send.AssembleVehicleMessage;
import com.atsuishio.superbwarfare.network.message.send.ChangeVehicleSeatMessage;
import com.atsuishio.superbwarfare.network.message.send.DogTagFinishEditMessage;
import com.atsuishio.superbwarfare.network.message.send.DoubleJumpMessage;
import com.atsuishio.superbwarfare.network.message.send.DroneFireMessage;
import com.atsuishio.superbwarfare.network.message.send.EditMessage;
import com.atsuishio.superbwarfare.network.message.send.FireKeyMessage;
import com.atsuishio.superbwarfare.network.message.send.FireModeMessage;
import com.atsuishio.superbwarfare.network.message.send.FiringParametersEditMessage;
import com.atsuishio.superbwarfare.network.message.send.GunReforgeMessage;
import com.atsuishio.superbwarfare.network.message.send.InteractMessage;
import com.atsuishio.superbwarfare.network.message.send.LaserShootMessage;
import com.atsuishio.superbwarfare.network.message.send.LungeMineAttackMessage;
import com.atsuishio.superbwarfare.network.message.send.MeleeAttackMessage;
import com.atsuishio.superbwarfare.network.message.send.MouseMoveMessage;
import com.atsuishio.superbwarfare.network.message.send.ParachuteMessage;
import com.atsuishio.superbwarfare.network.message.send.PlayerStopRidingMessage;
import com.atsuishio.superbwarfare.network.message.send.RadarChangeModeMessage;
import com.atsuishio.superbwarfare.network.message.send.RadarSetParametersMessage;
import com.atsuishio.superbwarfare.network.message.send.RadarSetPosMessage;
import com.atsuishio.superbwarfare.network.message.send.RadarSetTargetMessage;
import com.atsuishio.superbwarfare.network.message.send.ReloadMessage;
import com.atsuishio.superbwarfare.network.message.send.SeekingWeaponWarningMessage;
import com.atsuishio.superbwarfare.network.message.send.SensitivityMessage;
import com.atsuishio.superbwarfare.network.message.send.SetFiringParametersMessage;
import com.atsuishio.superbwarfare.network.message.send.SetPerkLevelMessage;
import com.atsuishio.superbwarfare.network.message.send.ShootMessage;
import com.atsuishio.superbwarfare.network.message.send.ShowChargingRangeMessage;
import com.atsuishio.superbwarfare.network.message.send.SwitchScopeMessage;
import com.atsuishio.superbwarfare.network.message.send.SwitchVehicleWeaponMessage;
import com.atsuishio.superbwarfare.network.message.send.TacticalSprintMessage;
import com.atsuishio.superbwarfare.network.message.send.UnloadMessage;
import com.atsuishio.superbwarfare.network.message.send.VehicleFireMessage;
import com.atsuishio.superbwarfare.network.message.send.VehicleMovementMessage;
import com.atsuishio.superbwarfare.network.message.send.WeaponZoomingMessage;
import com.atsuishio.superbwarfare.network.message.send.ZoomMessage;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkRegistry {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = net.minecraftforge.network.NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("superbwarfare", "superbwarfare"), () -> "1", "1"::equals, "1"::equals);
    public static int messageID = 0;

    public static void register() {
        NetworkRegistry.playToClient(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
        NetworkRegistry.playToClient(ShakeClientMessage.class, ShakeClientMessage::encode, ShakeClientMessage::decode, ShakeClientMessage::handler);
        NetworkRegistry.playToClient(ClientMotionSyncMessage.class, ClientMotionSyncMessage::encode, ClientMotionSyncMessage::decode, ClientMotionSyncMessage::handler);
        NetworkRegistry.playToClient(ClientIndicatorMessage.class, ClientIndicatorMessage::encode, ClientIndicatorMessage::decode, ClientIndicatorMessage::handler);
        NetworkRegistry.playToClient(LivingGunKillMessage.class, LivingGunKillMessage::encode, LivingGunKillMessage::decode, LivingGunKillMessage::handler);
        NetworkRegistry.playToClient(GunsDataMessage.class, GunsDataMessage::encode, GunsDataMessage::decode, (message, ctx) -> GunsDataMessage.handler(message));
        NetworkRegistry.playToClient(ContainerDataMessage.class, ContainerDataMessage::encode, ContainerDataMessage::decode, ContainerDataMessage::handler);
        NetworkRegistry.playToClient(ShootClientMessage.class, ShootClientMessage::encode, ShootClientMessage::decode, (message, context) -> ShootClientMessage.handler(context));
        NetworkRegistry.playToClient(DrawClientMessage.INSTANCE, DrawClientMessage::handler);
        NetworkRegistry.playToClient(ResetCameraTypeMessage.INSTANCE, ResetCameraTypeMessage::handler);
        NetworkRegistry.playToClient(RadarMenuOpenMessage.class, RadarMenuOpenMessage::encode, RadarMenuOpenMessage::decode, RadarMenuOpenMessage::handler);
        NetworkRegistry.playToClient(RadarMenuCloseMessage.INSTANCE, RadarMenuCloseMessage::handler);
        NetworkRegistry.playToClient(ClientTacticalSprintSyncMessage.class, ClientTacticalSprintSyncMessage::encode, ClientTacticalSprintSyncMessage::decode, ClientTacticalSprintSyncMessage::handler);
        NetworkRegistry.playToClient(VehiclesDataMessage.class, VehiclesDataMessage::encode, VehiclesDataMessage::decode, (msg, ctx) -> VehiclesDataMessage.handler(msg));
        NetworkRegistry.playToClient(ClientSetMotionMessage.class, ClientSetMotionMessage::encode, ClientSetMotionMessage::decode, ClientSetMotionMessage::handler);
        NetworkRegistry.playToClient(FinishAssemblingVehicleMessage.class, FinishAssemblingVehicleMessage::encode, FinishAssemblingVehicleMessage::decode, FinishAssemblingVehicleMessage::handler);
        NetworkRegistry.playToClient(TDMSyncMessage.class, TDMSyncMessage::encode, TDMSyncMessage::decode, TDMSyncMessage::handler);
        NetworkRegistry.playToClient(SoundClientMessage.class, SoundClientMessage::encode, SoundClientMessage::decode, SoundClientMessage::handler);
        NetworkRegistry.playToServer(LaserShootMessage.class, LaserShootMessage::encode, LaserShootMessage::decode, LaserShootMessage::handler);
        NetworkRegistry.playToServer(ShootMessage.class, ShootMessage::encode, ShootMessage::decode, ShootMessage::handler);
        NetworkRegistry.playToServer(SeekingWeaponWarningMessage.class, SeekingWeaponWarningMessage::encode, SeekingWeaponWarningMessage::decode, SeekingWeaponWarningMessage::handler);
        NetworkRegistry.playToServer(DoubleJumpMessage.INSTANCE, DoubleJumpMessage::handler);
        NetworkRegistry.playToServer(ParachuteMessage.INSTANCE, ParachuteMessage::handler);
        NetworkRegistry.playToServer(VehicleMovementMessage.class, VehicleMovementMessage::encode, VehicleMovementMessage::decode, VehicleMovementMessage::handler);
        NetworkRegistry.playToServer(MeleeAttackMessage.class, MeleeAttackMessage::encode, MeleeAttackMessage::decode, MeleeAttackMessage::handler);
        NetworkRegistry.playToServer(LungeMineAttackMessage.class, LungeMineAttackMessage::encode, LungeMineAttackMessage::decode, LungeMineAttackMessage::handler);
        NetworkRegistry.playToServer(VehicleFireMessage.class, VehicleFireMessage::encode, VehicleFireMessage::decode, VehicleFireMessage::handler);
        NetworkRegistry.playToServer(AimVillagerMessage.class, AimVillagerMessage::encode, AimVillagerMessage::decode, AimVillagerMessage::handler);
        NetworkRegistry.playToServer(RadarChangeModeMessage.class, RadarChangeModeMessage::encode, RadarChangeModeMessage::decode, RadarChangeModeMessage::handler);
        NetworkRegistry.playToServer(RadarSetParametersMessage.class, RadarSetParametersMessage::encode, RadarSetParametersMessage::decode, RadarSetParametersMessage::handler);
        NetworkRegistry.playToServer(RadarSetPosMessage.class, RadarSetPosMessage::encode, RadarSetPosMessage::decode, RadarSetPosMessage::handler);
        NetworkRegistry.playToServer(RadarSetTargetMessage.class, RadarSetTargetMessage::encode, RadarSetTargetMessage::decode, RadarSetTargetMessage::handler);
        NetworkRegistry.playToServer(GunReforgeMessage.INSTANCE, GunReforgeMessage::handler);
        NetworkRegistry.playToServer(SetPerkLevelMessage.class, SetPerkLevelMessage::encode, SetPerkLevelMessage::decode, SetPerkLevelMessage::handler);
        NetworkRegistry.playToServer(SwitchVehicleWeaponMessage.class, SwitchVehicleWeaponMessage::encode, SwitchVehicleWeaponMessage::decode, SwitchVehicleWeaponMessage::handler);
        NetworkRegistry.playToServer(AdjustZoomFovMessage.class, AdjustZoomFovMessage::encode, AdjustZoomFovMessage::decode, AdjustZoomFovMessage::handler);
        NetworkRegistry.playToServer(SwitchScopeMessage.class, SwitchScopeMessage::encode, SwitchScopeMessage::decode, SwitchScopeMessage::handler);
        NetworkRegistry.playToServer(FireKeyMessage.class, FireKeyMessage::encode, FireKeyMessage::decode, FireKeyMessage::handler);
        NetworkRegistry.playToServer(ReloadMessage.INSTANCE, ReloadMessage::handler);
        NetworkRegistry.playToServer(FireModeMessage.class, FireModeMessage::encode, FireModeMessage::decode, FireModeMessage::handler);
        NetworkRegistry.playToServer(PlayerStopRidingMessage.class, PlayerStopRidingMessage::encode, PlayerStopRidingMessage::decode, PlayerStopRidingMessage::handler);
        NetworkRegistry.playToServer(ZoomMessage.class, ZoomMessage::encode, ZoomMessage::decode, ZoomMessage::handler);
        NetworkRegistry.playToServer(DroneFireMessage.class, DroneFireMessage::encode, DroneFireMessage::decode, DroneFireMessage::handler);
        NetworkRegistry.playToServer(SetFiringParametersMessage.INSTANCE, SetFiringParametersMessage::handler);
        NetworkRegistry.playToServer(ArtilleryIndicatorFireMessage.INSTANCE, ArtilleryIndicatorFireMessage::handler);
        NetworkRegistry.playToServer(SensitivityMessage.class, SensitivityMessage::encode, SensitivityMessage::decode, SensitivityMessage::handler);
        NetworkRegistry.playToServer(EditMessage.class, EditMessage::encode, EditMessage::decode, EditMessage::handler);
        NetworkRegistry.playToServer(InteractMessage.INSTANCE, InteractMessage::handler);
        NetworkRegistry.playToServer(AdjustMortarAngleMessage.class, AdjustMortarAngleMessage::encode, AdjustMortarAngleMessage::decode, AdjustMortarAngleMessage::handler);
        NetworkRegistry.playToServer(ChangeVehicleSeatMessage.class, ChangeVehicleSeatMessage::encode, ChangeVehicleSeatMessage::decode, ChangeVehicleSeatMessage::handler);
        NetworkRegistry.playToServer(ShowChargingRangeMessage.class, ShowChargingRangeMessage::encode, ShowChargingRangeMessage::decode, ShowChargingRangeMessage::handler);
        NetworkRegistry.playToServer(TacticalSprintMessage.class, TacticalSprintMessage::encode, TacticalSprintMessage::decode, TacticalSprintMessage::handler);
        NetworkRegistry.playToServer(DogTagFinishEditMessage.class, DogTagFinishEditMessage::encode, DogTagFinishEditMessage::decode, DogTagFinishEditMessage::handler);
        NetworkRegistry.playToServer(MouseMoveMessage.class, MouseMoveMessage::encode, MouseMoveMessage::decode, MouseMoveMessage::handler);
        NetworkRegistry.playToServer(FiringParametersEditMessage.class, FiringParametersEditMessage::encode, FiringParametersEditMessage::decode, FiringParametersEditMessage::handler);
        NetworkRegistry.playToServer(UnloadMessage.INSTANCE, UnloadMessage::handler);
        NetworkRegistry.playToServer(AssembleVehicleMessage.class, AssembleVehicleMessage::encode, AssembleVehicleMessage::decode, AssembleVehicleMessage::handler);
        NetworkRegistry.playToServer(WeaponZoomingMessage.class, WeaponZoomingMessage::encode, WeaponZoomingMessage::decode, WeaponZoomingMessage::handler);
        RegisterContainersEvent registerContainerEvent = new RegisterContainersEvent();
        FMLJavaModLoadingContext.get().getModEventBus().post((Event)registerContainerEvent);
    }

    public static <T> void playToClient(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        ++messageID;
    }

    public static <T> void playToClient(T instance, Consumer<Supplier<NetworkEvent.Context>> messageConsumer) {
        Class<?> type = instance.getClass();
        PACKET_HANDLER.registerMessage(messageID, type, (msg, buf) -> {}, buf -> instance, (msg, ctx) -> messageConsumer.accept((Supplier<NetworkEvent.Context>)ctx), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        ++messageID;
    }

    public static <T> void playToServer(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        ++messageID;
    }

    public static <T> void playToServer(T instance, Consumer<Supplier<NetworkEvent.Context>> messageConsumer) {
        Class<?> type = instance.getClass();
        PACKET_HANDLER.registerMessage(messageID, type, (msg, buf) -> {}, buf -> instance, (msg, ctx) -> messageConsumer.accept((Supplier<NetworkEvent.Context>)ctx), Optional.of(NetworkDirection.PLAY_TO_SERVER));
        ++messageID;
    }
}

