/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.LivingEventHandler;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record EditMessage(int type, boolean add, boolean isVehicle) {
    public EditMessage(int type, boolean add) {
        this(type, add, false);
    }

    public static EditMessage decode(FriendlyByteBuf buffer) {
        return new EditMessage(buffer.readInt(), buffer.readBoolean(), buffer.readBoolean());
    }

    public static void encode(EditMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeBoolean(message.add);
        buffer.writeBoolean(message.isVehicle);
    }

    public static void handler(EditMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity patt1610$temp;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            if (message.isVehicle && (patt1610$temp = player.m_20202_()) instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)patt1610$temp;
                if (message.type != 5) {
                    return;
                }
                vehicle.modifyGunData(vehicle.getSeatIndex((Entity)player), data -> {
                    int size = data.getDefault().getAmmoConsumers().size();
                    LivingEventHandler.stopGunReloadSound(player, data);
                    data.changeAmmoConsumer((data.selectedAmmoType.get() + (message.add ? 1 : -1) + size) % size, vehicle.getAmmoSupplier());
                    SoundEvent sound = data.compute().soundInfo.change;
                    if (sound == null) {
                        return;
                    }
                    SoundTool.playLocalSound(player, sound, 4.0f, 1.0f);
                });
            } else {
                ItemStack stack = player.m_21205_();
                Item patt2379$temp = stack.m_41720_();
                if (!(patt2379$temp instanceof GunItem)) {
                    return;
                }
                GunItem gunItem = (GunItem)patt2379$temp;
                GunData data2 = GunData.from(stack);
                switch (message.type) {
                    case 0: {
                        int att = data2.attachment.get(AttachmentType.BARREL);
                        att = EditMessage.setAttachment(gunItem.getValidBarrels(), att, message.add);
                        data2.attachment.set(AttachmentType.BARREL, att);
                        break;
                    }
                    case 1: {
                        int att = data2.attachment.get(AttachmentType.SCOPE);
                        att = EditMessage.setAttachment(gunItem.getValidScopes(), att, message.add);
                        data2.attachment.set(AttachmentType.SCOPE, att);
                        break;
                    }
                    case 2: {
                        int att = data2.attachment.get(AttachmentType.GRIP);
                        att = EditMessage.setAttachment(gunItem.getValidGrips(), att, message.add);
                        data2.attachment.set(AttachmentType.GRIP, att);
                        break;
                    }
                    case 3: {
                        int att = data2.attachment.get(AttachmentType.STOCK);
                        att = EditMessage.setAttachment(gunItem.getValidStocks(), att, message.add);
                        data2.attachment.set(AttachmentType.STOCK, att);
                        break;
                    }
                    case 4: {
                        int att = data2.attachment.get(AttachmentType.MAGAZINE);
                        att = EditMessage.setAttachment(gunItem.getValidMagazines(), att, message.add);
                        data2.withdrawAmmo((Entity)player);
                        data2.attachment.set(AttachmentType.MAGAZINE, att);
                        break;
                    }
                    case 5: {
                        int size = data2.getDefault().getAmmoConsumers().size();
                        data2.changeAmmoConsumer((data2.selectedAmmoType.get() + (message.add ? 1 : -1) + size) % size, (Entity)player);
                    }
                }
                data2.save();
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.EDIT.get(), 1.0f, 1.0f);
            }
        });
        context.setPacketHandled(true);
    }

    private static int setAttachment(int[] arr, int value, boolean add) {
        if (arr.length == 0) {
            return 0;
        }
        int[] sorted = Arrays.copyOf(arr, arr.length);
        Arrays.sort(sorted);
        int index = Arrays.binarySearch(sorted, value);
        if (index < 0) {
            index = -index - 1;
        }
        index = add ? (index + 1) % arr.length : (index + arr.length - 1) % arr.length;
        return sorted[index];
    }
}

