/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.event.GunEventHandler;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class FireKeyMessage {
    private final int type;
    private final double power;
    private final boolean zoom;

    public FireKeyMessage(int type, double power, boolean zoom) {
        this.type = type;
        this.power = power;
        this.zoom = zoom;
    }

    public static FireKeyMessage decode(FriendlyByteBuf buffer) {
        return new FireKeyMessage(buffer.readInt(), buffer.readDouble(), buffer.readBoolean());
    }

    public static void encode(FireKeyMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeDouble(message.power);
        buffer.writeBoolean(message.zoom);
    }

    public static void handler(FireKeyMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() != null) {
                FireKeyMessage.pressAction((Player)context.getSender(), message.type, message.power, message.zoom);
            }
        });
        context.setPacketHandled(true);
    }

    public static void pressAction(Player player, int type, double power, boolean zoom) {
        if (player.m_5833_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        FireKeyMessage.handleGunBolt(player, stack);
        if (type == 0) {
            data.item.onFireKeyPress(data, player, zoom);
        } else if (type == 1) {
            data.item.onFireKeyRelease(data, player, power, zoom);
        }
        data.save();
    }

    private static void handleGunBolt(Player player, ItemStack stack) {
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        if (data.compute().boltActionTime > 0 && data.hasEnoughAmmoToShoot((Entity)player) && data.bolt.actionTimer.get() == 0 && !data.reloading() && !data.charging() && !player.m_36335_().m_41519_(stack.m_41720_()) && data.bolt.needed.get()) {
            data.startBolt();
            GunEventHandler.playGunBoltSounds((Entity)player, data);
        }
    }
}

