/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public record LungeMineAttackMessage(int type, UUID uuid, Vec3 pos) {
    public static LungeMineAttackMessage decode(FriendlyByteBuf buffer) {
        return new LungeMineAttackMessage(buffer.readInt(), buffer.m_130259_(), new Vec3(buffer.m_269394_()));
    }

    public static void encode(LungeMineAttackMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.m_130077_(message.uuid);
        buffer.m_269582_(message.pos.m_252839_());
    }

    public static void handler(LungeMineAttackMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21205_();
            if (!stack.m_150930_((Item)ModItems.LUNGE_MINE.get())) {
                return;
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (message.type == 0) {
                Entity lookingEntity = EntityFindUtil.findEntity(player.m_9236_(), String.valueOf(message.uuid));
                if (lookingEntity != null) {
                    DamageHandler.doDamage(lookingEntity, ModDamageTypes.causeLungeMineDamage(player.m_9236_().m_9598_(), (Entity)player, (Entity)player), lookingEntity instanceof VehicleEntity ? 600.0f : 150.0f);
                    LungeMineAttackMessage.causeLungeMineExplode((Entity)player, lookingEntity);
                }
            } else if (message.type == 1) {
                new CustomExplosion.Builder((Entity)player).damage(60.0f).radius(4.0f).damageMultiplier(1.25f).withParticleType(ParticleTool.ParticleType.MEDIUM).position(message.pos).explode();
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
        });
        context.setPacketHandled(true);
    }

    public static void causeLungeMineExplode(Entity attacker, Entity target) {
        new CustomExplosion.Builder(target).damage(60.0f).radius(4.0f).attacker(attacker).damageMultiplier(1.25f).withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
    }
}

