/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SwitchVehicleWeaponMessage {
    private final int index;
    private final double value;
    private final boolean isScroll;

    public SwitchVehicleWeaponMessage(int index, double value, boolean isScroll) {
        this.index = index;
        this.value = value;
        this.isScroll = isScroll;
    }

    public static void encode(SwitchVehicleWeaponMessage message, FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(message.index);
        byteBuf.writeDouble(message.value);
        byteBuf.writeBoolean(message.isScroll);
    }

    public static SwitchVehicleWeaponMessage decode(FriendlyByteBuf byteBuf) {
        return new SwitchVehicleWeaponMessage(byteBuf.readInt(), byteBuf.readDouble(), byteBuf.readBoolean());
    }

    public static void handler(SwitchVehicleWeaponMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            VehicleEntity vehicle;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            Entity patt1451$temp = player.m_20202_();
            if (patt1451$temp instanceof VehicleEntity && (vehicle = (VehicleEntity)patt1451$temp).hasWeapon(vehicle.getSeatIndex((Entity)player))) {
                double value = message.isScroll ? (double)Mth.m_14045_((int)(message.value > 0.0 ? Mth.m_14165_((double)message.value) : Mth.m_14107_((double)message.value)), (int)-1, (int)1) : message.value;
                vehicle.changeWeapon(message.index, (int)value, message.isScroll);
            }
        });
        context.get().setPacketHandled(true);
    }
}

