/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class ZoomMessage {
    private final int type;

    public ZoomMessage(int type) {
        this.type = type;
    }

    public static ZoomMessage decode(FriendlyByteBuf buffer) {
        return new ZoomMessage(buffer.readInt());
    }

    public static void encode(ZoomMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
    }

    public static void handler(ZoomMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Entity patt1147$temp = player.m_20202_();
            if (!(patt1147$temp instanceof VehicleEntity)) {
                return;
            }
            VehicleEntity vehicle = (VehicleEntity)patt1147$temp;
            if (message.type == 0 && vehicle.hasWeapon(vehicle.getSeatIndex((Entity)player)) && vehicle.banHand((LivingEntity)player)) {
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_IN.get(), 2.0f, 1.0f);
            }
            if (message.type == 1 && vehicle.hasWeapon(vehicle.getSeatIndex((Entity)player)) && vehicle.banHand((LivingEntity)player)) {
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_OUT.get(), 2.0f, 1.0f);
            }
        });
        context.setPacketHandled(true);
    }
}

