/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk;

import com.atsuishio.superbwarfare.data.gun.DamageReduce;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;

public class AmmoPerk
extends Perk {
    public double bypassArmorRate;
    public double damageRate = 1.0;
    public double speedRate = 1.0;
    public boolean slug;
    public float[] rgb;
    public Supplier<ArrayList<MobEffect>> mobEffects;

    public AmmoPerk(Builder builder) {
        super(builder.descriptionId, builder.type);
        this.bypassArmorRate = builder.bypassArmorRate;
        this.damageRate = builder.damageRate;
        this.speedRate = builder.speedRate;
        this.slug = builder.slug;
        this.rgb = builder.rgb;
        this.mobEffects = () -> builder.mobEffects;
    }

    @Override
    public DefaultGunData computeProperties(GunData gunData, DefaultGunData rawData) {
        AmmoPerk ammoPerk;
        rawData.bypassesArmor = Math.max(0.0, rawData.bypassesArmor + this.bypassArmorRate);
        rawData.velocity = Math.max(0.0, rawData.velocity * this.speedRate);
        Perk perk = gunData.perk.get(Perk.Type.AMMO);
        if (perk instanceof AmmoPerk) {
            ammoPerk = (AmmoPerk)perk;
            rawData.damage = ammoPerk.slug ? (rawData.damage *= ammoPerk.damageRate * (double)rawData.projectileAmount) : (rawData.damage *= ammoPerk.damageRate);
        }
        if ((perk = gunData.perk.get(Perk.Type.AMMO)) instanceof AmmoPerk) {
            ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.slug) {
                rawData.projectileAmount = 1;
            }
        }
        if ((perk = gunData.perk.get(Perk.Type.AMMO)) instanceof AmmoPerk) {
            ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.slug && gunData.isShotgun(rawData)) {
                rawData.zoomSpreadRate = 0.15;
            }
        }
        return super.computeProperties(gunData, rawData);
    }

    public AmmoPerk(String descriptionId, Perk.Type type) {
        super(descriptionId, type);
        this.rgb = new float[]{1.0f, 0.87058824f, 0.15294118f};
        this.mobEffects = ArrayList::new;
    }

    @Override
    public void modifyProjectile(GunData data, PerkInstance instance, Entity entity) {
        if (!(entity instanceof ProjectileEntity)) {
            return;
        }
        ProjectileEntity projectile = (ProjectileEntity)entity;
        projectile.setRGB(this.rgb);
        if (!this.mobEffects.get().isEmpty()) {
            int amplifier = this.getEffectAmplifier(instance);
            int duration = this.getEffectDuration(instance);
            ArrayList<MobEffectInstance> mobEffectInstances = new ArrayList<MobEffectInstance>();
            for (MobEffect effect : this.mobEffects.get()) {
                mobEffectInstances.add(new MobEffectInstance(effect, duration, amplifier));
            }
            projectile.effect(mobEffectInstances);
        }
    }

    public int getEffectAmplifier(PerkInstance instance) {
        return instance.level() - 1;
    }

    public int getEffectDuration(PerkInstance instance) {
        return 70 + 30 * instance.level();
    }

    @Override
    public double getModifiedDamageReduceRate(DamageReduce reduce) {
        if (this.slug && reduce.type == DamageReduce.ReduceType.SHOTGUN) {
            return 0.015;
        }
        return super.getModifiedDamageReduceRate(reduce);
    }

    @Override
    public double getModifiedDamageReduceMinDistance(DamageReduce reduce) {
        if (this.slug && reduce.type == DamageReduce.ReduceType.SHOTGUN) {
            return super.getModifiedDamageReduceMinDistance(reduce) * 2.0;
        }
        return super.getModifiedDamageReduceMinDistance(reduce);
    }

    public static class Builder {
        String descriptionId;
        Perk.Type type;
        double bypassArmorRate = 0.0;
        double damageRate = 1.0;
        double speedRate = 1.0;
        boolean slug = false;
        float[] rgb = new float[]{1.0f, 0.87058824f, 0.15294118f};
        public ArrayList<MobEffect> mobEffects = new ArrayList();

        public Builder(String descriptionId, Perk.Type type) {
            this.descriptionId = descriptionId;
            this.type = type;
        }

        public Builder bypassArmorRate(double bypassArmorRate) {
            this.bypassArmorRate = Mth.m_14008_((double)bypassArmorRate, (double)-1.0, (double)1.0);
            return this;
        }

        public Builder damageRate(double damageRate) {
            this.damageRate = Mth.m_14008_((double)damageRate, (double)0.0, (double)Double.POSITIVE_INFINITY);
            return this;
        }

        public Builder speedRate(double speedRate) {
            this.speedRate = Mth.m_14008_((double)speedRate, (double)0.0, (double)Double.POSITIVE_INFINITY);
            return this;
        }

        public Builder slug() {
            this.slug = true;
            return this;
        }

        public Builder rgb(int r, int g, int b) {
            this.rgb[0] = (float)r / 255.0f;
            this.rgb[1] = (float)g / 255.0f;
            this.rgb[2] = (float)b / 255.0f;
            return this;
        }

        public Builder mobEffect(Supplier<MobEffect> mobEffect) {
            this.mobEffects.add(mobEffect.get());
            return this;
        }
    }
}

