/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.damage;

import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class OneTwoPunch
extends Perk {
    public OneTwoPunch() {
        super("one_two_punch", Perk.Type.DAMAGE);
    }

    @Override
    public DefaultGunData computeProperties(GunData gunData, DefaultGunData rawData) {
        if (gunData.perk.getTag(this).m_128451_("OneTwoPunchTime") > 0) {
            rawData.meleeDamage *= 1.5 + 0.75 * (double)(gunData.perk.getLevel(this) - 1);
        }
        return super.computeProperties(gunData, rawData);
    }

    @Override
    public void onHit(LivingEntity attacker, GunData data, PerkInstance instance, Entity target) {
        super.onHit(attacker, data, instance, target);
        data.perk.getTag(this).m_128405_("OneTwoPunchCount", data.perk.getTag(this).m_128451_("OneTwoPunchCount") + 1);
        data.perk.getTag(this).m_128405_("OneTwoPunchCountTime", 2);
        double needCount = Math.floor((double)data.compute().projectileAmount * (1.0 - 0.05 * (double)(instance.level() - 1)));
        if ((double)data.perk.getTag(this).m_128451_("OneTwoPunchCount") >= needCount) {
            data.perk.getTag(this).m_128405_("OneTwoPunchTime", 60);
            data.perk.getTag(this).m_128473_("OneTwoPunchCount");
            data.perk.getTag(this).m_128473_("OneTwoPunchCountTime");
        }
    }

    @Override
    public void onChangeSlot(GunData data, PerkInstance instance, @Nullable Entity living) {
        super.onChangeSlot(data, instance, living);
        data.perk.getTag(this).m_128473_("OneTwoPunchTime");
        data.perk.getTag(this).m_128473_("OneTwoPunchCount");
        data.perk.getTag(this).m_128473_("OneTwoPunchCountTime");
    }

    @Override
    public void onMeleeAttack(GunData data, PerkInstance instance, Entity target) {
        super.onMeleeAttack(data, instance, target);
        data.perk.getTag(this).m_128473_("OneTwoPunchTime");
        data.perk.getTag(this).m_128473_("OneTwoPunchCount");
        data.perk.getTag(this).m_128473_("OneTwoPunchCountTime");
    }

    @Override
    public void tick(GunData data, PerkInstance instance, @Nullable Entity entity) {
        super.tick(data, instance, entity);
        data.perk.reduceCooldown(this, "OneTwoPunchTime");
        data.perk.reduceCooldown(this, "OneTwoPunchCountTime");
    }
}

