/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.Mod;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="superbwarfare", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ResourceOnceLogger {
    private static final ReloadListener INSTANCE = new ReloadListener();
    private static final List<ResourceOnceLogger> LOGGERS = new ArrayList<ResourceOnceLogger>();
    private final Set<Object> logged = new HashSet<Object>();

    public ResourceOnceLogger() {
        LOGGERS.add(this);
    }

    public void log(Object obj, Consumer<Logger> logger) {
        if (this.logged.contains(obj)) {
            return;
        }
        this.logged.add(obj);
        logger.accept(Mod.LOGGER);
    }

    @SubscribeEvent
    static void onRegisterReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)INSTANCE);
    }

    static class ReloadListener
    implements ResourceManagerReloadListener {
        ReloadListener() {
        }

        public void m_6213_(@NotNull ResourceManager resourceManager) {
            LOGGERS.forEach(l -> l.logged.clear());
        }
    }
}

