/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.starwars.block.entity;

import io.netty.buffer.Unpooled;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mcreator.starwars.init.StarwarsModBlockEntities;
import net.mcreator.starwars.world.inventory.TurbolaserblockheavyguiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;

public class TurbolaserbaseheavyBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private final EnergyStorage energyStorage = new EnergyStorage(5000, 50, 50, 0){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int retval = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                TurbolaserbaseheavyBlockEntity.this.setChanged();
                TurbolaserbaseheavyBlockEntity.this.level.sendBlockUpdated(TurbolaserbaseheavyBlockEntity.this.worldPosition, TurbolaserbaseheavyBlockEntity.this.level.getBlockState(TurbolaserbaseheavyBlockEntity.this.worldPosition), TurbolaserbaseheavyBlockEntity.this.level.getBlockState(TurbolaserbaseheavyBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int retval = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                TurbolaserbaseheavyBlockEntity.this.setChanged();
                TurbolaserbaseheavyBlockEntity.this.level.sendBlockUpdated(TurbolaserbaseheavyBlockEntity.this.worldPosition, TurbolaserbaseheavyBlockEntity.this.level.getBlockState(TurbolaserbaseheavyBlockEntity.this.worldPosition), TurbolaserbaseheavyBlockEntity.this.level.getBlockState(TurbolaserbaseheavyBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }
    };

    public TurbolaserbaseheavyBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)StarwarsModBlockEntities.TURBOLASERBASEHEAVY.get(), position, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(compound, lookupProvider);
        if (!this.tryLoadLootTable(compound)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        Tag tag = compound.get("energyStorage");
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            this.energyStorage.deserializeNBT(lookupProvider, (Tag)intTag);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        }
        compound.put("energyStorage", this.energyStorage.serializeNBT(lookupProvider));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithFullMetadata(lookupProvider);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Component getDefaultName() {
        return Component.literal((String)"turbolaserbaseheavy");
    }

    public int getMaxStackSize() {
        return 64;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new TurbolaserblockheavyguiMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    public Component getDisplayName() {
        return Component.literal((String)"Turbolaser Barrel");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemstack, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemstack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack itemstack, Direction direction) {
        return true;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }
}

