/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.starwars.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelgrogu<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"starwars", (String)"modelgrogu"), "main");
    public final ModelPart head;
    public final ModelPart armleft;
    public final ModelPart armright;
    public final ModelPart body;

    public Modelgrogu(ModelPart root) {
        this.head = root.getChild("head");
        this.armleft = root.getChild("armleft");
        this.armright = root.getChild("armright");
        this.body = root.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(42, 43).addBox(-2.9f, -3.8f, -2.6f, 5.6f, 3.8f, 5.2f, new CubeDeformation(0.0f)).texOffs(59, 61).addBox(0.5f, -3.0f, -2.7f, 1.4f, 1.4f, 1.0f, new CubeDeformation(0.0f)).texOffs(51, 61).addBox(-1.9f, -3.0f, -2.7f, 1.4f, 1.4f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.1f, (float)14.0f, (float)0.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0397f, -0.0459f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-3.8f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.8552f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(56, 29).addBox(-0.7f, 0.1f, -0.6f, 2.9f, 2.0f, 1.1f, new CubeDeformation(0.0f)).texOffs(20, 0).addBox(-0.7f, 0.0f, -0.5f, 3.8f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9f, (float)-3.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition cube_r3 = head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(56, 36).addBox(-2.2f, 0.1f, -0.6f, 2.7f, 2.0f, 1.1f, new CubeDeformation(0.0f)).texOffs(19, 13).addBox(-3.1f, 0.0f, -0.5f, 3.6f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.9f, (float)-3.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition cube_r4 = head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 10).addBox(0.0397f, -0.0459f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-3.8f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.8552f));
        PartDefinition armleft = partdefinition.addOrReplaceChild("armleft", CubeListBuilder.create().texOffs(0, 24).addBox(-0.5f, -0.7f, -1.5f, 2.0f, 6.2f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)15.0f, (float)0.0f));
        PartDefinition armright = partdefinition.addOrReplaceChild("armright", CubeListBuilder.create().texOffs(10, 24).addBox(-1.5f, -0.7f, -1.5f, 2.0f, 6.2f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)15.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 55).addBox(-3.8f, -11.0f, -3.3f, 7.6f, 2.0f, 6.6f, new CubeDeformation(0.0f)).texOffs(38, 0).addBox(-3.5f, -10.0f, -3.0f, 7.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)25.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.armleft.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.armright.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.armright.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.armleft.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

