/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.starwars.network;

import java.io.File;
import java.util.function.Supplier;
import net.mcreator.starwars.StarwarsMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class StarwarsModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"starwars");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());
    public static File mustafar_data = new File("");
    public static File tatooine_data = new File("");
    public static File hoth_data = new File("");
    public static File geonosis_data = new File("");
    public static File endor_data = new File("");
    public static File yavin4_data = new File("");
    public static File scarif_data = new File("");

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        StarwarsMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        StarwarsMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUpdateSyncPlayerVariables(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((PlayerVariables)player2.getData(StarwarsModVariables.PLAYER_VARIABLES))._syncDirty) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerVariables)player2.getData(StarwarsModVariables.PLAYER_VARIABLES))._syncDirty = false;
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
        PlayerVariables clone = new PlayerVariables();
        clone.imp_Rep = original.imp_Rep;
        clone.rebel_Rep = original.rebel_Rep;
        clone.republic_Rep = original.republic_Rep;
        clone.cis_Rep = original.cis_Rep;
        clone.Fuel_player_starfighter = original.Fuel_player_starfighter;
        clone.Ammo_player_starfighter = original.Ammo_player_starfighter;
        clone.FuelCap_player_starfighter = original.FuelCap_player_starfighter;
        clone.TP_t70 = original.TP_t70;
        clone.TP_t70_DONE = original.TP_t70_DONE;
        clone.TP_rz2_awing = original.TP_rz2_awing;
        clone.TP_rz2_awing_DONE = original.TP_rz2_awing_DONE;
        clone.TP_rz2 = original.TP_rz2;
        clone.TP_rz2_DONE = original.TP_rz2_DONE;
        clone.TP_t65_red = original.TP_t65_red;
        clone.TP_t65_red_DONE = original.TP_t65_red_DONE;
        clone.TP_t65_blue = original.TP_t65_blue;
        clone.TP_t65_blue_DONE = original.TP_t65_blue_DONE;
        clone.TP_ywingy = original.TP_ywingy;
        clone.TP_ywingy_DONE = original.TP_ywingy_DONE;
        clone.TP_ywingb = original.TP_ywingb;
        clone.TP_ywingb_DONE = original.TP_ywingb_DONE;
        clone.TP_ywingr = original.TP_ywingr;
        clone.TP_ywingr_DONE = original.TP_ywingr_DONE;
        clone.TP_ywingnoy = original.TP_ywingnoy;
        clone.TP_ywingnoy_DONE = original.TP_ywingnoy_DONE;
        clone.TP_ywingnob = original.TP_ywingnob;
        clone.TP_ywingnob_DONE = original.TP_ywingnob_DONE;
        clone.TP_v19 = original.TP_v19;
        clone.TP_v19_DONE = original.TP_v19_DONE;
        clone.TP_z95 = original.TP_z95;
        clone.TP_z95_DONE = original.TP_z95_DONE;
        clone.TP_lambda_shuttle = original.TP_lambda_shuttle;
        if (!event.isWasDeath()) {
            clone.pos_exit_X = original.pos_exit_X;
            clone.pos_exit_Z = original.pos_exit_Z;
            clone.vehicle_riding = original.vehicle_riding;
        }
        event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (mapdata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level2);
            if (worldVariables._syncDirty) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level2, (CustomPacketPayload)new SavedDataSyncMessage(1, worldVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                worldVariables._syncDirty = false;
            }
            MapVariables mapVariables = MapVariables.get((LevelAccessor)level2);
            if (mapVariables._syncDirty) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, mapVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                mapVariables._syncDirty = false;
            }
        }
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"starwars", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"starwars", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        boolean _syncDirty = false;
        public double imp_Rep = 0.0;
        public double rebel_Rep = 0.0;
        public double republic_Rep = 0.0;
        public double cis_Rep = 0.0;
        public double Fuel_player_starfighter = 0.0;
        public double Ammo_player_starfighter = 0.0;
        public double FuelCap_player_starfighter = 0.0;
        public double pos_exit_X = 0.0;
        public double pos_exit_Z = 0.0;
        public boolean TP_t70 = false;
        public boolean TP_t70_DONE = false;
        public boolean TP_rz2_awing = false;
        public boolean TP_rz2_awing_DONE = false;
        public boolean TP_rz2 = false;
        public boolean TP_rz2_DONE = false;
        public boolean TP_t65_red = false;
        public boolean TP_t65_red_DONE = false;
        public boolean TP_t65_blue = false;
        public boolean TP_t65_blue_DONE = false;
        public boolean TP_ywingy = false;
        public boolean TP_ywingy_DONE = false;
        public boolean TP_ywingb = false;
        public boolean TP_ywingb_DONE = false;
        public boolean TP_ywingr = false;
        public boolean TP_ywingr_DONE = false;
        public boolean TP_ywingnoy = false;
        public boolean TP_ywingnoy_DONE = false;
        public boolean TP_ywingnob = false;
        public boolean TP_ywingnob_DONE = false;
        public boolean TP_v19 = false;
        public boolean TP_v19_DONE = false;
        public boolean TP_z95 = false;
        public boolean TP_z95_DONE = false;
        public String vehicle_riding = "\"\"";
        public boolean TP_lambda_shuttle = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("imp_Rep", this.imp_Rep);
            nbt.putDouble("rebel_Rep", this.rebel_Rep);
            nbt.putDouble("republic_Rep", this.republic_Rep);
            nbt.putDouble("cis_Rep", this.cis_Rep);
            nbt.putDouble("Fuel_player_starfighter", this.Fuel_player_starfighter);
            nbt.putDouble("Ammo_player_starfighter", this.Ammo_player_starfighter);
            nbt.putDouble("FuelCap_player_starfighter", this.FuelCap_player_starfighter);
            nbt.putDouble("pos_exit_X", this.pos_exit_X);
            nbt.putDouble("pos_exit_Z", this.pos_exit_Z);
            nbt.putBoolean("TP_t70", this.TP_t70);
            nbt.putBoolean("TP_t70_DONE", this.TP_t70_DONE);
            nbt.putBoolean("TP_rz2_awing", this.TP_rz2_awing);
            nbt.putBoolean("TP_rz2_awing_DONE", this.TP_rz2_awing_DONE);
            nbt.putBoolean("TP_rz2", this.TP_rz2);
            nbt.putBoolean("TP_rz2_DONE", this.TP_rz2_DONE);
            nbt.putBoolean("TP_t65_red", this.TP_t65_red);
            nbt.putBoolean("TP_t65_red_DONE", this.TP_t65_red_DONE);
            nbt.putBoolean("TP_t65_blue", this.TP_t65_blue);
            nbt.putBoolean("TP_t65_blue_DONE", this.TP_t65_blue_DONE);
            nbt.putBoolean("TP_ywingy", this.TP_ywingy);
            nbt.putBoolean("TP_ywingy_DONE", this.TP_ywingy_DONE);
            nbt.putBoolean("TP_ywingb", this.TP_ywingb);
            nbt.putBoolean("TP_ywingb_DONE", this.TP_ywingb_DONE);
            nbt.putBoolean("TP_ywingr", this.TP_ywingr);
            nbt.putBoolean("TP_ywingr_DONE", this.TP_ywingr_DONE);
            nbt.putBoolean("TP_ywingnoy", this.TP_ywingnoy);
            nbt.putBoolean("TP_ywingnoy_DONE", this.TP_ywingnoy_DONE);
            nbt.putBoolean("TP_ywingnob", this.TP_ywingnob);
            nbt.putBoolean("TP_ywingnob_DONE", this.TP_ywingnob_DONE);
            nbt.putBoolean("TP_v19", this.TP_v19);
            nbt.putBoolean("TP_v19_DONE", this.TP_v19_DONE);
            nbt.putBoolean("TP_z95", this.TP_z95);
            nbt.putBoolean("TP_z95_DONE", this.TP_z95_DONE);
            nbt.putString("vehicle_riding", this.vehicle_riding);
            nbt.putBoolean("TP_lambda_shuttle", this.TP_lambda_shuttle);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.imp_Rep = nbt.getDouble("imp_Rep");
            this.rebel_Rep = nbt.getDouble("rebel_Rep");
            this.republic_Rep = nbt.getDouble("republic_Rep");
            this.cis_Rep = nbt.getDouble("cis_Rep");
            this.Fuel_player_starfighter = nbt.getDouble("Fuel_player_starfighter");
            this.Ammo_player_starfighter = nbt.getDouble("Ammo_player_starfighter");
            this.FuelCap_player_starfighter = nbt.getDouble("FuelCap_player_starfighter");
            this.pos_exit_X = nbt.getDouble("pos_exit_X");
            this.pos_exit_Z = nbt.getDouble("pos_exit_Z");
            this.TP_t70 = nbt.getBoolean("TP_t70");
            this.TP_t70_DONE = nbt.getBoolean("TP_t70_DONE");
            this.TP_rz2_awing = nbt.getBoolean("TP_rz2_awing");
            this.TP_rz2_awing_DONE = nbt.getBoolean("TP_rz2_awing_DONE");
            this.TP_rz2 = nbt.getBoolean("TP_rz2");
            this.TP_rz2_DONE = nbt.getBoolean("TP_rz2_DONE");
            this.TP_t65_red = nbt.getBoolean("TP_t65_red");
            this.TP_t65_red_DONE = nbt.getBoolean("TP_t65_red_DONE");
            this.TP_t65_blue = nbt.getBoolean("TP_t65_blue");
            this.TP_t65_blue_DONE = nbt.getBoolean("TP_t65_blue_DONE");
            this.TP_ywingy = nbt.getBoolean("TP_ywingy");
            this.TP_ywingy_DONE = nbt.getBoolean("TP_ywingy_DONE");
            this.TP_ywingb = nbt.getBoolean("TP_ywingb");
            this.TP_ywingb_DONE = nbt.getBoolean("TP_ywingb_DONE");
            this.TP_ywingr = nbt.getBoolean("TP_ywingr");
            this.TP_ywingr_DONE = nbt.getBoolean("TP_ywingr_DONE");
            this.TP_ywingnoy = nbt.getBoolean("TP_ywingnoy");
            this.TP_ywingnoy_DONE = nbt.getBoolean("TP_ywingnoy_DONE");
            this.TP_ywingnob = nbt.getBoolean("TP_ywingnob");
            this.TP_ywingnob_DONE = nbt.getBoolean("TP_ywingnob_DONE");
            this.TP_v19 = nbt.getBoolean("TP_v19");
            this.TP_v19_DONE = nbt.getBoolean("TP_v19_DONE");
            this.TP_z95 = nbt.getBoolean("TP_z95");
            this.TP_z95_DONE = nbt.getBoolean("TP_z95_DONE");
            this.vehicle_riding = nbt.getString("vehicle_riding");
            this.TP_lambda_shuttle = nbt.getBoolean("TP_lambda_shuttle");
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "starwars_mapvars";
        boolean _syncDirty = false;
        public boolean player_login = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.player_login = nbt.getBoolean("player_login");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("player_login", this.player_login);
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "starwars_worldvars";
        boolean _syncDirty = false;
        public ItemStack ammo_blaster_blue = ItemStack.EMPTY;
        public ItemStack ammo_blaster_red = ItemStack.EMPTY;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.ammo_blaster_blue = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("ammo_blaster_blue"));
            this.ammo_blaster_red = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("ammo_blaster_red"));
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.put("ammo_blaster_blue", this.ammo_blaster_blue.saveOptional(lookupProvider));
            nbt.put("ammo_blaster_red", this.ammo_blaster_red.saveOptional(lookupProvider));
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }
}

