/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.starwars.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Map;
import javax.annotation.Nullable;
import net.mcreator.starwars.init.StarwarsModBlocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class RenderShieldprocedureProcedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.ZERO;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(float x, float y, float z, int color) {
        RenderShieldprocedureProcedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(float x, float y, float z, float u, float v, int color) {
        if (bufferBuilder == null) {
            return;
        }
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            bufferBuilder.addVertex(x, y, z).setColor(color);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            bufferBuilder.addVertex(x, y, z).setUv(u, v).setColor(color);
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null) {
            if (update) {
                RenderShieldprocedureProcedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.POSITION_COLOR) {
                    RenderShieldprocedureProcedure.mode = mode;
                    RenderShieldprocedureProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_COLOR);
                    return true;
                }
                if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
                    RenderShieldprocedureProcedure.mode = mode;
                    RenderShieldprocedureProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_TEX_COLOR);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        MeshData meshData;
        if (bufferBuilder == null) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        if ((meshData = bufferBuilder.build()) == null) {
            vertexBuffer = null;
            bufferBuilder = null;
        } else {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vertexBuffer.bind();
            vertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            bufferBuilder = null;
        }
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        RenderShieldprocedureProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            RenderShieldprocedureProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            i = (float)(x - pos.x());
            j = (float)(y - pos.y());
            k = (float)(z - pos.z());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate(i, j, k);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        poseStack.translate(offset.x(), offset.y(), offset.z());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            poseStack = new PoseStack();
            RenderSystem.depthMask((boolean)false);
            RenderShieldprocedureProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            poseStack = event.getPoseStack();
            RenderSystem.depthMask((boolean)true);
            RenderShieldprocedureProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (level != null && entity != null) {
            modelViewMatrix = event.getModelViewMatrix();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.getPosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderShieldprocedureProcedure.execute((Event)event, (LevelAccessor)level);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world) {
        RenderShieldprocedureProcedure.execute(null, world);
    }

    private static void execute(@Nullable Event event, LevelAccessor world) {
        if (world instanceof ClientLevel) {
            ClientLevel _blockEntityContext = (ClientLevel)world;
            int _scanRange = Minecraft.getInstance().options.getEffectiveRenderDistance();
            BlockPos _scanCenter = Minecraft.getInstance().player.blockPosition();
            for (int _chunkZ = -_scanRange; _chunkZ <= _scanRange; ++_chunkZ) {
                for (int _chunkX = -_scanRange; _chunkX <= _scanRange; ++_chunkX) {
                    LevelChunk _levelChunk = _blockEntityContext.getChunk(SectionPos.blockToSectionCoord((int)(_scanCenter.getX() + (_chunkX << 4))), SectionPos.blockToSectionCoord((int)(_scanCenter.getZ() + (_chunkZ << 4))));
                    if (_levelChunk == null) continue;
                    for (Map.Entry _blockEntityEntry : _levelChunk.getBlockEntities().entrySet()) {
                        BlockState blockstateiterator = ((BlockEntity)_blockEntityEntry.getValue()).getBlockState();
                        int positionx = ((BlockPos)_blockEntityEntry.getKey()).getX();
                        int positiony = ((BlockPos)_blockEntityEntry.getKey()).getY();
                        int positionz = ((BlockPos)_blockEntityEntry.getKey()).getZ();
                        if (blockstateiterator.getBlock() != StarwarsModBlocks.SHIELDGENERATOR.get()) continue;
                        if (RenderShieldprocedureProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, false)) {
                            RenderShieldprocedureProcedure.add(0.5f, -0.5f, -0.5f, -6250336);
                            RenderShieldprocedureProcedure.add(0.5f, -0.5f, 0.5f, -6250336);
                            RenderShieldprocedureProcedure.add(-0.5f, -0.5f, 0.5f, -6250336);
                            RenderShieldprocedureProcedure.add(-0.5f, -0.5f, -0.5f, -6250336);
                            RenderShieldprocedureProcedure.add(0.5f, 0.5f, 0.5f, -1);
                            RenderShieldprocedureProcedure.add(0.5f, 0.5f, -0.5f, -1);
                            RenderShieldprocedureProcedure.add(-0.5f, 0.5f, -0.5f, -1);
                            RenderShieldprocedureProcedure.add(-0.5f, 0.5f, 0.5f, -1);
                            RenderShieldprocedureProcedure.add(0.5f, 0.5f, -0.5f, -2039584);
                            RenderShieldprocedureProcedure.add(0.5f, -0.5f, -0.5f, -2039584);
                            RenderShieldprocedureProcedure.add(-0.5f, -0.5f, -0.5f, -2039584);
                            RenderShieldprocedureProcedure.add(-0.5f, 0.5f, -0.5f, -2039584);
                            RenderShieldprocedureProcedure.add(-0.5f, 0.5f, 0.5f, -2039584);
                            RenderShieldprocedureProcedure.add(-0.5f, -0.5f, 0.5f, -2039584);
                            RenderShieldprocedureProcedure.add(0.5f, -0.5f, 0.5f, -2039584);
                            RenderShieldprocedureProcedure.add(0.5f, 0.5f, 0.5f, -2039584);
                            RenderShieldprocedureProcedure.add(0.5f, 0.5f, 0.5f, -4144960);
                            RenderShieldprocedureProcedure.add(0.5f, -0.5f, 0.5f, -4144960);
                            RenderShieldprocedureProcedure.add(0.5f, -0.5f, -0.5f, -4144960);
                            RenderShieldprocedureProcedure.add(0.5f, 0.5f, -0.5f, -4144960);
                            RenderShieldprocedureProcedure.add(-0.5f, 0.5f, -0.5f, -4144960);
                            RenderShieldprocedureProcedure.add(-0.5f, -0.5f, -0.5f, -4144960);
                            RenderShieldprocedureProcedure.add(-0.5f, -0.5f, 0.5f, -4144960);
                            RenderShieldprocedureProcedure.add(-0.5f, 0.5f, 0.5f, -4144960);
                            RenderShieldprocedureProcedure.end();
                        }
                        if (!RenderShieldprocedureProcedure.target(2)) continue;
                        RenderSystem.disableCull();
                        RenderSystem.defaultBlendFunc();
                        RenderShieldprocedureProcedure.renderShape(RenderShieldprocedureProcedure.shape(), positionx, positiony, positionz, 0.0f, 0.0f, 0.0f, (float)RenderShieldprocedureProcedure.getBlockNBTNumber(world, new BlockPos(positionx, positiony, positionz), "shieldsize"), (float)RenderShieldprocedureProcedure.getBlockNBTNumber(world, new BlockPos(positionx, positiony, positionz), "shieldsize"), (float)RenderShieldprocedureProcedure.getBlockNBTNumber(world, new BlockPos(positionx, positiony, positionz), "shieldsize"), 1677768427);
                        RenderShieldprocedureProcedure.release();
                    }
                }
            }
        }
    }

    private static double getBlockNBTNumber(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null) {
            return blockEntity.getPersistentData().getDouble(tag);
        }
        return -1.0;
    }
}

