/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.starwars.network;

import java.io.File;
import java.util.function.Supplier;
import net.mcreator.starwars.StarwarsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class StarwarsModVariables {
    public static File mustafar_data = new File("");
    public static File tatooine_data = new File("");
    public static File hoth_data = new File("");
    public static File geonosis_data = new File("");
    public static File endor_data = new File("");
    public static File yavin4_data = new File("");
    public static File scarif_data = new File("");
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        StarwarsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        StarwarsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.imp_Rep = message.data.imp_Rep;
                    variables.rebel_Rep = message.data.rebel_Rep;
                    variables.republic_Rep = message.data.republic_Rep;
                    variables.cis_Rep = message.data.cis_Rep;
                    variables.Fuel_player_starfighter = message.data.Fuel_player_starfighter;
                    variables.Ammo_player_starfighter = message.data.Ammo_player_starfighter;
                    variables.FuelCap_player_starfighter = message.data.FuelCap_player_starfighter;
                    variables.pos_exit_X = message.data.pos_exit_X;
                    variables.pos_exit_Z = message.data.pos_exit_Z;
                    variables.TP_t70 = message.data.TP_t70;
                    variables.TP_t70_DONE = message.data.TP_t70_DONE;
                    variables.TP_rz2_awing = message.data.TP_rz2_awing;
                    variables.TP_rz2_awing_DONE = message.data.TP_rz2_awing_DONE;
                    variables.TP_rz2 = message.data.TP_rz2;
                    variables.TP_rz2_DONE = message.data.TP_rz2_DONE;
                    variables.TP_t65_red = message.data.TP_t65_red;
                    variables.TP_t65_red_DONE = message.data.TP_t65_red_DONE;
                    variables.TP_t65_blue = message.data.TP_t65_blue;
                    variables.TP_t65_blue_DONE = message.data.TP_t65_blue_DONE;
                    variables.TP_ywingy = message.data.TP_ywingy;
                    variables.TP_ywingy_DONE = message.data.TP_ywingy_DONE;
                    variables.TP_ywingb = message.data.TP_ywingb;
                    variables.TP_ywingb_DONE = message.data.TP_ywingb_DONE;
                    variables.TP_ywingr = message.data.TP_ywingr;
                    variables.TP_ywingr_DONE = message.data.TP_ywingr_DONE;
                    variables.TP_ywingnoy = message.data.TP_ywingnoy;
                    variables.TP_ywingnoy_DONE = message.data.TP_ywingnoy_DONE;
                    variables.TP_ywingnob = message.data.TP_ywingnob;
                    variables.TP_ywingnob_DONE = message.data.TP_ywingnob_DONE;
                    variables.TP_v19 = message.data.TP_v19;
                    variables.TP_v19_DONE = message.data.TP_v19_DONE;
                    variables.TP_z95 = message.data.TP_z95;
                    variables.TP_z95_DONE = message.data.TP_z95_DONE;
                    variables.vehicle_riding = message.data.vehicle_riding;
                    variables.TP_lambda_shuttle = message.data.TP_lambda_shuttle;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double imp_Rep = 0.0;
        public double rebel_Rep = 0.0;
        public double republic_Rep = 0.0;
        public double cis_Rep = 0.0;
        public double Fuel_player_starfighter = 0.0;
        public double Ammo_player_starfighter = 0.0;
        public double FuelCap_player_starfighter = 0.0;
        public double pos_exit_X = 0.0;
        public double pos_exit_Z = 0.0;
        public boolean TP_t70 = false;
        public boolean TP_t70_DONE = false;
        public boolean TP_rz2_awing = false;
        public boolean TP_rz2_awing_DONE = false;
        public boolean TP_rz2 = false;
        public boolean TP_rz2_DONE = false;
        public boolean TP_t65_red = false;
        public boolean TP_t65_red_DONE = false;
        public boolean TP_t65_blue = false;
        public boolean TP_t65_blue_DONE = false;
        public boolean TP_ywingy = false;
        public boolean TP_ywingy_DONE = false;
        public boolean TP_ywingb = false;
        public boolean TP_ywingb_DONE = false;
        public boolean TP_ywingr = false;
        public boolean TP_ywingr_DONE = false;
        public boolean TP_ywingnoy = false;
        public boolean TP_ywingnoy_DONE = false;
        public boolean TP_ywingnob = false;
        public boolean TP_ywingnob_DONE = false;
        public boolean TP_v19 = false;
        public boolean TP_v19_DONE = false;
        public boolean TP_z95 = false;
        public boolean TP_z95_DONE = false;
        public String vehicle_riding = "\"\"";
        public boolean TP_lambda_shuttle = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                StarwarsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("imp_Rep", this.imp_Rep);
            nbt.m_128347_("rebel_Rep", this.rebel_Rep);
            nbt.m_128347_("republic_Rep", this.republic_Rep);
            nbt.m_128347_("cis_Rep", this.cis_Rep);
            nbt.m_128347_("Fuel_player_starfighter", this.Fuel_player_starfighter);
            nbt.m_128347_("Ammo_player_starfighter", this.Ammo_player_starfighter);
            nbt.m_128347_("FuelCap_player_starfighter", this.FuelCap_player_starfighter);
            nbt.m_128347_("pos_exit_X", this.pos_exit_X);
            nbt.m_128347_("pos_exit_Z", this.pos_exit_Z);
            nbt.m_128379_("TP_t70", this.TP_t70);
            nbt.m_128379_("TP_t70_DONE", this.TP_t70_DONE);
            nbt.m_128379_("TP_rz2_awing", this.TP_rz2_awing);
            nbt.m_128379_("TP_rz2_awing_DONE", this.TP_rz2_awing_DONE);
            nbt.m_128379_("TP_rz2", this.TP_rz2);
            nbt.m_128379_("TP_rz2_DONE", this.TP_rz2_DONE);
            nbt.m_128379_("TP_t65_red", this.TP_t65_red);
            nbt.m_128379_("TP_t65_red_DONE", this.TP_t65_red_DONE);
            nbt.m_128379_("TP_t65_blue", this.TP_t65_blue);
            nbt.m_128379_("TP_t65_blue_DONE", this.TP_t65_blue_DONE);
            nbt.m_128379_("TP_ywingy", this.TP_ywingy);
            nbt.m_128379_("TP_ywingy_DONE", this.TP_ywingy_DONE);
            nbt.m_128379_("TP_ywingb", this.TP_ywingb);
            nbt.m_128379_("TP_ywingb_DONE", this.TP_ywingb_DONE);
            nbt.m_128379_("TP_ywingr", this.TP_ywingr);
            nbt.m_128379_("TP_ywingr_DONE", this.TP_ywingr_DONE);
            nbt.m_128379_("TP_ywingnoy", this.TP_ywingnoy);
            nbt.m_128379_("TP_ywingnoy_DONE", this.TP_ywingnoy_DONE);
            nbt.m_128379_("TP_ywingnob", this.TP_ywingnob);
            nbt.m_128379_("TP_ywingnob_DONE", this.TP_ywingnob_DONE);
            nbt.m_128379_("TP_v19", this.TP_v19);
            nbt.m_128379_("TP_v19_DONE", this.TP_v19_DONE);
            nbt.m_128379_("TP_z95", this.TP_z95);
            nbt.m_128379_("TP_z95_DONE", this.TP_z95_DONE);
            nbt.m_128359_("vehicle_riding", this.vehicle_riding);
            nbt.m_128379_("TP_lambda_shuttle", this.TP_lambda_shuttle);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.imp_Rep = nbt.m_128459_("imp_Rep");
            this.rebel_Rep = nbt.m_128459_("rebel_Rep");
            this.republic_Rep = nbt.m_128459_("republic_Rep");
            this.cis_Rep = nbt.m_128459_("cis_Rep");
            this.Fuel_player_starfighter = nbt.m_128459_("Fuel_player_starfighter");
            this.Ammo_player_starfighter = nbt.m_128459_("Ammo_player_starfighter");
            this.FuelCap_player_starfighter = nbt.m_128459_("FuelCap_player_starfighter");
            this.pos_exit_X = nbt.m_128459_("pos_exit_X");
            this.pos_exit_Z = nbt.m_128459_("pos_exit_Z");
            this.TP_t70 = nbt.m_128471_("TP_t70");
            this.TP_t70_DONE = nbt.m_128471_("TP_t70_DONE");
            this.TP_rz2_awing = nbt.m_128471_("TP_rz2_awing");
            this.TP_rz2_awing_DONE = nbt.m_128471_("TP_rz2_awing_DONE");
            this.TP_rz2 = nbt.m_128471_("TP_rz2");
            this.TP_rz2_DONE = nbt.m_128471_("TP_rz2_DONE");
            this.TP_t65_red = nbt.m_128471_("TP_t65_red");
            this.TP_t65_red_DONE = nbt.m_128471_("TP_t65_red_DONE");
            this.TP_t65_blue = nbt.m_128471_("TP_t65_blue");
            this.TP_t65_blue_DONE = nbt.m_128471_("TP_t65_blue_DONE");
            this.TP_ywingy = nbt.m_128471_("TP_ywingy");
            this.TP_ywingy_DONE = nbt.m_128471_("TP_ywingy_DONE");
            this.TP_ywingb = nbt.m_128471_("TP_ywingb");
            this.TP_ywingb_DONE = nbt.m_128471_("TP_ywingb_DONE");
            this.TP_ywingr = nbt.m_128471_("TP_ywingr");
            this.TP_ywingr_DONE = nbt.m_128471_("TP_ywingr_DONE");
            this.TP_ywingnoy = nbt.m_128471_("TP_ywingnoy");
            this.TP_ywingnoy_DONE = nbt.m_128471_("TP_ywingnoy_DONE");
            this.TP_ywingnob = nbt.m_128471_("TP_ywingnob");
            this.TP_ywingnob_DONE = nbt.m_128471_("TP_ywingnob_DONE");
            this.TP_v19 = nbt.m_128471_("TP_v19");
            this.TP_v19_DONE = nbt.m_128471_("TP_v19_DONE");
            this.TP_z95 = nbt.m_128471_("TP_z95");
            this.TP_z95_DONE = nbt.m_128471_("TP_z95_DONE");
            this.vehicle_riding = nbt.m_128461_("vehicle_riding");
            this.TP_lambda_shuttle = nbt.m_128471_("TP_lambda_shuttle");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("starwars", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "starwars_mapvars";
        public boolean player_login = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.player_login = nbt.m_128471_("player_login");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("player_login", this.player_login);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                StarwarsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "starwars_worldvars";
        public ItemStack ammo_blaster_blue = ItemStack.f_41583_;
        public ItemStack ammo_blaster_red = ItemStack.f_41583_;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.ammo_blaster_blue = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ammo_blaster_blue"));
            this.ammo_blaster_red = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ammo_blaster_red"));
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128365_("ammo_blaster_blue", (Tag)this.ammo_blaster_blue.m_41739_(new CompoundTag()));
            nbt.m_128365_("ammo_blaster_red", (Tag)this.ammo_blaster_red.m_41739_(new CompoundTag()));
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                StarwarsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.imp_Rep = original.imp_Rep;
            clone.rebel_Rep = original.rebel_Rep;
            clone.republic_Rep = original.republic_Rep;
            clone.cis_Rep = original.cis_Rep;
            clone.Fuel_player_starfighter = original.Fuel_player_starfighter;
            clone.Ammo_player_starfighter = original.Ammo_player_starfighter;
            clone.FuelCap_player_starfighter = original.FuelCap_player_starfighter;
            clone.TP_t70 = original.TP_t70;
            clone.TP_t70_DONE = original.TP_t70_DONE;
            clone.TP_rz2_awing = original.TP_rz2_awing;
            clone.TP_rz2_awing_DONE = original.TP_rz2_awing_DONE;
            clone.TP_rz2 = original.TP_rz2;
            clone.TP_rz2_DONE = original.TP_rz2_DONE;
            clone.TP_t65_red = original.TP_t65_red;
            clone.TP_t65_red_DONE = original.TP_t65_red_DONE;
            clone.TP_t65_blue = original.TP_t65_blue;
            clone.TP_t65_blue_DONE = original.TP_t65_blue_DONE;
            clone.TP_ywingy = original.TP_ywingy;
            clone.TP_ywingy_DONE = original.TP_ywingy_DONE;
            clone.TP_ywingb = original.TP_ywingb;
            clone.TP_ywingb_DONE = original.TP_ywingb_DONE;
            clone.TP_ywingr = original.TP_ywingr;
            clone.TP_ywingr_DONE = original.TP_ywingr_DONE;
            clone.TP_ywingnoy = original.TP_ywingnoy;
            clone.TP_ywingnoy_DONE = original.TP_ywingnoy_DONE;
            clone.TP_ywingnob = original.TP_ywingnob;
            clone.TP_ywingnob_DONE = original.TP_ywingnob_DONE;
            clone.TP_v19 = original.TP_v19;
            clone.TP_v19_DONE = original.TP_v19_DONE;
            clone.TP_z95 = original.TP_z95;
            clone.TP_z95_DONE = original.TP_z95_DONE;
            clone.TP_lambda_shuttle = original.TP_lambda_shuttle;
            if (!event.isWasDeath()) {
                clone.pos_exit_X = original.pos_exit_X;
                clone.pos_exit_Z = original.pos_exit_Z;
                clone.vehicle_riding = original.vehicle_riding;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    StarwarsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    StarwarsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                StarwarsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

