/*
 * Decompiled with CFR 0.152.
 */
package QCore.quantumquarry.world.client.screen;

import QCore.quantumquarry.world.container.QuantumCoreContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class QuantumCoreScreen
extends ContainerScreen<QuantumCoreContainer> {
    private static final int PADDING = 12;
    private static final int SLOT_SPACING = 18;
    private static final int SLOT_SIZE = 16;
    private static final int ENERGY_BAR_WIDTH = 16;
    private static final int COLOR_PANEL = -3750202;
    private static final int COLOR_SLOT_BG = -7631989;
    private static final int COLOR_SLOT_SHADOW = -13158601;
    private static final int COLOR_SLOT_DIV = 0x22FFFFFF;
    private static final int TEXT_COLOR = 0x404040;
    private final int gridWidth;
    private final int gridHeight;
    private final int contentWidth;
    private int gridStartXLocal;
    private int gridStartYLocal;
    private int upgradesStartXLocal;
    private int upgradesStartYLocal;
    private int energyBarXLocal;
    private int energyBarTopLocal;
    private int energyBarBottomLocal;
    private int playerInvTopLocal;

    public QuantumCoreScreen(@Nonnull QuantumCoreContainer container, @Nonnull PlayerInventory inv, @Nonnull ITextComponent title) {
        super((Container)container, inv, title);
        this.field_230711_n_ = false;
        this.gridWidth = 144;
        this.gridHeight = 144;
        int upgradeAreaWidth = 36;
        int upgradeAreaHeight = 54;
        this.contentWidth = Math.max(162, this.gridWidth + 12 + upgradeAreaWidth);
        this.field_146999_f = 24 + this.contentWidth;
        this.gridStartXLocal = 12;
        this.gridStartYLocal = 12;
        this.upgradesStartXLocal = this.gridStartXLocal + this.gridWidth + 12;
        this.upgradesStartYLocal = this.gridStartYLocal;
        this.playerInvTopLocal = this.gridStartYLocal + this.gridHeight + 12;
        this.energyBarXLocal = this.upgradesStartXLocal + (upgradeAreaWidth - 16) / 2;
        int filtersStartYLocal = this.upgradesStartYLocal + 54 + 8;
        this.energyBarTopLocal = filtersStartYLocal + 18 + 8;
        this.energyBarBottomLocal = this.energyBarTopLocal + 40;
        this.field_147000_g = this.playerInvTopLocal + 54 + 18 + 12;
        this.field_238745_s_ = this.playerInvTopLocal - 10;
    }

    protected void func_230450_a_(@Nonnull MatrixStack ms, float partialTicks, int mouseX, int mouseY) {
        this.field_147003_i = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_230709_l_ - this.field_147000_g) / 2;
        int outerLeft = this.field_147003_i - 3;
        int outerTop = this.field_147009_r - 3;
        int outerRight = this.field_147003_i + this.field_146999_f + 3;
        int outerBottom = this.field_147009_r + this.field_147000_g + 3;
        int black = -16777216;
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)(outerLeft + 1), (int)outerTop, (int)(outerRight - 1), (int)outerBottom, (int)black);
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)outerLeft, (int)(outerTop + 1), (int)(outerLeft + 1), (int)(outerBottom - 1), (int)black);
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)(outerRight - 1), (int)(outerTop + 1), (int)outerRight, (int)(outerBottom - 1), (int)black);
        int frameLeft = this.field_147003_i - 2;
        int frameTop = this.field_147009_r - 2;
        int frameRight = this.field_147003_i + this.field_146999_f + 2;
        int frameBottom = this.field_147009_r + this.field_147000_g + 2;
        int frameColor = -11184811;
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)(frameLeft + 1), (int)frameTop, (int)(frameRight - 1), (int)frameBottom, (int)frameColor);
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)frameLeft, (int)(frameTop + 1), (int)(frameLeft + 1), (int)(frameBottom - 1), (int)frameColor);
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)(frameRight - 1), (int)(frameTop + 1), (int)frameRight, (int)(frameBottom - 1), (int)frameColor);
        int panelLeft = this.field_147003_i;
        int panelTop = this.field_147009_r;
        int panelRight = this.field_147003_i + this.field_146999_f;
        int panelBottom = this.field_147009_r + this.field_147000_g;
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)(panelLeft + 1), (int)panelTop, (int)(panelRight - 1), (int)panelBottom, (int)-3750202);
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)panelLeft, (int)(panelTop + 1), (int)(panelLeft + 1), (int)(panelBottom - 1), (int)-3750202);
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)(panelRight - 1), (int)(panelTop + 1), (int)panelRight, (int)(panelBottom - 1), (int)-3750202);
        this.renderSlotGrid(ms, this.field_147003_i + this.gridStartXLocal + 1, this.field_147009_r + this.gridStartYLocal + 1, 8, 8);
        int upgradesScreenX = this.field_147003_i + this.upgradesStartXLocal + 1;
        int upgradesScreenY = this.field_147009_r + this.upgradesStartYLocal + 1;
        this.renderSlotGrid(ms, upgradesScreenX, upgradesScreenY, 2, 3);
        int filtersStartYLocal = this.upgradesStartYLocal + 54 + 8;
        int filtersScreenX = this.field_147003_i + this.upgradesStartXLocal + 1;
        int filtersScreenY = this.field_147009_r + filtersStartYLocal + 1;
        this.renderSlotGrid(ms, filtersScreenX, filtersScreenY, 2, 1);
        int barX = this.field_147003_i + this.energyBarXLocal;
        int barTop = this.field_147009_r + this.energyBarTopLocal;
        int barBottom = this.field_147009_r + this.energyBarBottomLocal;
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)barX, (int)barTop, (int)(barX + 16), (int)barBottom, (int)-7631989);
        int capWidth = 10;
        if (capWidth < 4) {
            capWidth = 16;
        }
        int capX = barX + (16 - capWidth) / 2;
        int capTop = barTop - 3;
        int capBottom = barTop;
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)capX, (int)capTop, (int)(capX + capWidth), (int)capBottom, (int)-7631989);
        int innerX = barX + 1;
        int innerY = barTop + 1;
        int innerW = 14;
        int innerH = barBottom - barTop - 2;
        if (innerW < 1) {
            innerW = 1;
        }
        if (innerH < 1) {
            innerH = 1;
        }
        int innerBg = -8684677;
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)innerX, (int)innerY, (int)(innerX + innerW), (int)(innerY + innerH), (int)innerBg);
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)barX, (int)barTop, (int)(barX + 16), (int)(barTop + 1), (int)0x22FFFFFF);
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)barX, (int)(barBottom - 1), (int)(barX + 16), (int)barBottom, (int)0x22FFFFFF);
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)barX, (int)barTop, (int)(barX + 1), (int)barBottom, (int)0x22FFFFFF);
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)(barX + 16 - 1), (int)barTop, (int)(barX + 16), (int)barBottom, (int)0x22FFFFFF);
        if (((QuantumCoreContainer)this.field_147002_h).getTile() != null && ((QuantumCoreContainer)this.field_147002_h).getTile().getEnergy() != null) {
            int energy = ((QuantumCoreContainer)this.field_147002_h).getTile().getEnergy().getEnergyStored();
            int maxEnergy = ((QuantumCoreContainer)this.field_147002_h).getTile().getEnergy().getMaxEnergyStored();
            int filled = 0;
            if (maxEnergy > 0) {
                filled = Math.round((float)energy / (float)maxEnergy * (float)innerH);
                if (energy > 0 && filled == 0) {
                    filled = 1;
                }
                if (filled > innerH) {
                    filled = innerH;
                }
            }
            if (filled > 0) {
                int filledTop = innerY + (innerH - filled);
                int fillColor = -2065798;
                int left = innerX + 1;
                int right = innerX + innerW - 1;
                int bottom = innerY + innerH - 1;
                QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)left, (int)filledTop, (int)Math.max(left + 1, right), (int)bottom, (int)fillColor);
                if (right > left + 1) {
                    QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)left, (int)filledTop, (int)right, (int)bottom, (int)fillColor);
                }
            }
        }
        int playerLeft = this.field_147003_i + 12 + (this.contentWidth - 162) / 2 + 1;
        int invTop = this.field_147009_r + this.playerInvTopLocal + 1;
        this.renderSlotGrid(ms, playerLeft, invTop, 9, 3);
        this.renderSlotGrid(ms, playerLeft, invTop + 54 + 4, 9, 1);
    }

    private void renderSlotGrid(@Nonnull MatrixStack ms, int startX, int startY, int cols, int rows) {
        int totalWidth = (cols - 1) * 18 + 16;
        int totalHeight = (rows - 1) * 18 + 16;
        QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)startX, (int)startY, (int)(startX + totalWidth), (int)(startY + totalHeight), (int)-7631989);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int sx = startX + col * 18;
                int sy = startY + row * 18;
                QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)(sx - 1), (int)sy, (int)sx, (int)(sy + 16), (int)-13158601);
                QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)sx, (int)(sy - 1), (int)(sx + 16), (int)sy, (int)-13158601);
                QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)sx, (int)sy, (int)(sx + 16), (int)(sy + 16), (int)-8684677);
                QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)(sx + 16 - 1), (int)sy, (int)(sx + 16), (int)(sy + 16), (int)0x22FFFFFF);
                QuantumCoreScreen.func_238467_a_((MatrixStack)ms, (int)sx, (int)(sy + 16 - 1), (int)(sx + 16), (int)(sy + 16), (int)0x22FFFFFF);
            }
        }
    }

    public void func_230430_a_(@Nonnull MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        if (((QuantumCoreContainer)this.field_147002_h).getTile() != null && ((QuantumCoreContainer)this.field_147002_h).getTile().getEnergy() != null) {
            int barX = this.field_147003_i + this.energyBarXLocal;
            int barTop = this.field_147009_r + this.energyBarTopLocal;
            int barBottom = this.field_147009_r + this.energyBarBottomLocal;
            int barRight = barX + 16;
            if (mouseX >= barX && mouseX <= barRight && mouseY >= barTop && mouseY <= barBottom) {
                int energy = ((QuantumCoreContainer)this.field_147002_h).getTile().getEnergy().getEnergyStored();
                int maxEnergy = ((QuantumCoreContainer)this.field_147002_h).getTile().getEnergy().getMaxEnergyStored();
                String tooltip = energy + " / " + maxEnergy + " RF";
                this.func_238652_a_(ms, (ITextComponent)new StringTextComponent(tooltip), mouseX, mouseY);
            }
        }
        this.func_230459_a_(ms, mouseX, mouseY);
    }

    protected void func_230451_b_(@Nonnull MatrixStack ms, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(ms, this.field_230704_d_.getString(), 12.0f, 2.0f, 0x404040);
        String upLabel = I18n.func_135052_a((String)"gui.quantumquarry.upgrade_slots", (Object[])new Object[0]);
        int upLabelX = this.upgradesStartXLocal - 6;
        int upLabelY = this.upgradesStartYLocal - 10;
        this.field_230712_o_.func_238421_b_(ms, upLabel, (float)upLabelX, (float)upLabelY, 0x404040);
        String filtersLabel = I18n.func_135052_a((String)"gui.quantumquarry.filters", (Object[])new Object[0]);
        int filtersStartYLocal = this.upgradesStartYLocal + 54 + 8;
        int filtersLabelX = this.upgradesStartXLocal - 6;
        int filtersLabelY = filtersStartYLocal - 8;
        this.field_230712_o_.func_238421_b_(ms, filtersLabel, (float)filtersLabelX, (float)filtersLabelY, 0x404040);
        int invX = 12 + (this.contentWidth - 162) / 2;
        this.field_230712_o_.func_238421_b_(ms, this.field_213127_e.func_145748_c_().getString(), (float)invX, (float)this.field_238745_s_, 0x404040);
        if (((QuantumCoreContainer)this.field_147002_h).getTile() != null) {
            long mined = ((QuantumCoreContainer)this.field_147002_h).getTile().getTotalMined();
            String minedLabel = I18n.func_135052_a((String)"gui.quantumquarry.mined", (Object[])new Object[0]);
            String minedValue = this.formatMined(mined);
            int barCenterX = this.energyBarXLocal + 8;
            int labelY = this.energyBarBottomLocal + 4;
            int labelX = barCenterX - this.field_230712_o_.func_78256_a(minedLabel) / 2;
            this.field_230712_o_.func_238421_b_(ms, minedLabel, (float)labelX, (float)labelY, 0x404040);
            int valueY = labelY + 10;
            int valueX = barCenterX - this.field_230712_o_.func_78256_a(minedValue) / 2;
            this.field_230712_o_.func_238421_b_(ms, minedValue, (float)valueX, (float)valueY, 0x404040);
        }
    }

    private String formatMined(long value) {
        if (value < 0L) {
            value = 0L;
        }
        long MILLION = 1000000L;
        long BILLION = 1000000000L;
        long TRILLION = 1000000000000L;
        if (value >= 1000000000000L) {
            double v = (double)value / 1.0E12;
            return this.formatWithSuffix(v, "T");
        }
        if (value >= 1000000000L) {
            double v = (double)value / 1.0E9;
            return this.formatWithSuffix(v, "B");
        }
        if (value >= 1000000L) {
            double v = (double)value / 1000000.0;
            return this.formatWithSuffix(v, "M");
        }
        String s = Long.toString(value);
        int len = s.length();
        if (len <= 3) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int firstGroup = len % 3;
        if (firstGroup == 0) {
            firstGroup = 3;
        }
        sb.append(s, 0, firstGroup);
        for (int i = firstGroup; i < len; i += 3) {
            sb.append('.');
            sb.append(s, i, i + 3);
        }
        return sb.toString();
    }

    private String formatWithSuffix(double v, String suffix) {
        if (v < 10.0) {
            return String.format("%.1f%s", v, suffix);
        }
        return String.format("%.0f%s", v, suffix);
    }
}

