/*
 * Decompiled with CFR 0.152.
 */
package QCore.quantumquarry.world.container;

import QCore.quantumquarry.content.ModBlocks;
import QCore.quantumquarry.content.ModContainers;
import QCore.quantumquarry.world.tile.QuantumCoreTileEntity;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class QuantumCoreContainer
extends Container {
    public static final int GRID_COLS = 8;
    public static final int GRID_ROWS = 8;
    public static final int ORE_SLOT_COUNT = 64;
    public static final int UPGRADE_COLUMNS = 2;
    public static final int UPGRADE_ROWS = 3;
    public static final int UPGRADE_SLOTS = 6;
    public static final int FILTER_SLOTS = 2;
    private static final int PADDING = 12;
    private static final int SLOT_SPACING = 18;
    private static final int SLOT_SIZE = 16;
    private static final int GAP_GRID_UPGRADE = 12;
    private static final int GAP_GRID_PLAYER = 12;
    private static final int HOTBAR_GAP = 4;
    private final QuantumCoreTileEntity tile;
    private final IWorldPosCallable worldPos;

    public QuantumCoreContainer(int id, PlayerInventory playerInventory, PacketBuffer data) {
        this(id, playerInventory, data.func_179259_c());
    }

    public QuantumCoreContainer(int id, PlayerInventory playerInventory, BlockPos pos) {
        super((ContainerType)ModContainers.QUANTUM_CORE.get(), id);
        World world = playerInventory.field_70458_d.field_70170_p;
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof QuantumCoreTileEntity)) {
            throw new IllegalStateException("QuantumCoreTileEntity not found!");
        }
        this.tile = (QuantumCoreTileEntity)te;
        this.worldPos = IWorldPosCallable.func_221488_a((World)world, (BlockPos)pos);
        this.layoutContainer(playerInventory);
    }

    private void layoutContainer(PlayerInventory playerInventory) {
        IItemHandler oreHandler = this.tile.getOreStorage();
        int gridStartX = 12;
        int gridStartY = 12;
        int oreIndex = 0;
        for (int row = 0; row < 8; ++row) {
            for (int col = 0; col < 8; ++col) {
                int x = gridStartX + col * 18 + 1;
                int y = gridStartY + row * 18 + 1;
                this.func_75146_a((Slot)new OreOutputSlot(oreHandler, oreIndex++, x, y));
            }
        }
        IItemHandler upgradeHandler = this.tile.getUpgradeStorage();
        int upgradesStartX = gridStartX + 144 + 12;
        int upgradesStartY = gridStartY;
        int upIndex = 0;
        for (int col = 0; col < 2; ++col) {
            for (int row = 0; row < 3; ++row) {
                int x = upgradesStartX + col * 18 + 1;
                int y = upgradesStartY + row * 18 + 1;
                this.func_75146_a((Slot)new UpgradeSlot(upgradeHandler, upIndex++, x, y));
            }
        }
        IItemHandler filterHandler = this.tile.getFilterStorage();
        int filtersStartY = upgradesStartY + 54 + 8;
        int filterIndex = 0;
        for (int col = 0; col < 2; ++col) {
            int x = upgradesStartX + col * 18 + 1;
            int y = filtersStartY + 1;
            this.func_75146_a((Slot)new FilterSlot(filterHandler, filterIndex++, x, y));
        }
        int upgradeBoxWidth = 36;
        int gridPixelWidth = 144;
        int contentWidth = Math.max(162, gridPixelWidth + 12 + upgradeBoxWidth);
        int playerInvTop = gridStartY + 144 + 12;
        int playerLeft = 12 + (contentWidth - 162) / 2;
        this.addPlayerInventory(playerInventory, playerLeft, playerInvTop);
    }

    private void addPlayerInventory(PlayerInventory playerInventory, int leftCol, int topRow) {
        int x;
        int col;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                x = leftCol + col * 18 + 1;
                int y = topRow + row * 18 + 1;
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, x, y));
            }
        }
        int hotbarY = topRow + 54 + 4;
        for (col = 0; col < 9; ++col) {
            x = leftCol + col * 18 + 1;
            this.func_75146_a(new Slot((IInventory)playerInventory, col, x, hotbarY + 1));
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        return QuantumCoreContainer.func_216963_a((IWorldPosCallable)this.worldPos, (PlayerEntity)player, (Block)((Block)ModBlocks.QUANTUM_CORE.get()));
    }

    public QuantumCoreTileEntity getTile() {
        return this.tile;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack result = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            result = stack.func_77946_l();
            int tileSlots = 72;
            if (index < tileSlots) {
                if (!this.func_75135_a(stack, tileSlots, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (stack.func_77973_b() == Items.field_151122_aG || stack.func_77973_b() == Items.field_151134_bR) {
                if (!this.func_75135_a(stack, 64, 70, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (stack.func_77973_b() == ModBlocks.QUANTUM_FILTER_ITEM.get() || stack.func_77973_b() == ModBlocks.QUARRY_WORLD_FILTER_ITEM.get()) {
                int filterStart = 70;
                int filterEnd = filterStart + 2;
                if (!this.func_75135_a(stack, filterStart, filterEnd, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack);
        }
        return result;
    }

    private static class FilterSlot
    extends SlotItemHandler {
        public FilterSlot(IItemHandler handler, int index, int x, int y) {
            super(handler, index, x, y);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return stack.func_77973_b() == ModBlocks.QUANTUM_FILTER_ITEM.get() || stack.func_77973_b() == ModBlocks.QUARRY_WORLD_FILTER_ITEM.get();
        }
    }

    private static class UpgradeSlot
    extends SlotItemHandler {
        public UpgradeSlot(IItemHandler handler, int index, int x, int y) {
            super(handler, index, x, y);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            if (stack.func_77973_b() != Items.field_151134_bR) {
                return false;
            }
            Map ench = EnchantmentHelper.func_82781_a((ItemStack)stack);
            Integer eff = (Integer)ench.get(Enchantments.field_185305_q);
            Integer fortune = (Integer)ench.get(Enchantments.field_185308_t);
            Integer silk = (Integer)ench.get(Enchantments.field_185306_r);
            return eff != null && eff > 0 || fortune != null && fortune > 0 || silk != null && silk > 0;
        }
    }

    private static class OreOutputSlot
    extends SlotItemHandler {
        public OreOutputSlot(IItemHandler handler, int index, int x, int y) {
            super(handler, index, x, y);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return false;
        }
    }
}

