/*
 * Decompiled with CFR 0.152.
 */
package QCore.quantumquarry.world.container;

import QCore.quantumquarry.content.ModContainers;
import QCore.quantumquarry.world.item.QuantumFilterItem;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class QuantumFilterContainer
extends Container {
    public static final int FILTER_SLOTS = 16;
    private final PlayerEntity player;
    private final ItemStackHandler handler;
    private final ItemStack filterStack;

    public QuantumFilterContainer(int id, PlayerInventory playerInventory) {
        super((ContainerType)ModContainers.QUANTUM_FILTER.get(), id);
        int x;
        int col;
        this.player = playerInventory.field_70458_d;
        ItemStack stack = QuantumFilterContainer.findFilterStack(this.player);
        this.filterStack = stack.func_190926_b() ? ItemStack.field_190927_a : stack;
        this.handler = QuantumFilterItem.getOrCreateHandler(this.filterStack.func_190926_b() ? new ItemStack((IItemProvider)this.player.func_184614_ca().func_77973_b()) : this.filterStack);
        int startX = 11;
        int startY = 16;
        int index = 0;
        for (int row = 0; row < 4; ++row) {
            for (int col2 = 0; col2 < 4; ++col2) {
                int x2 = startX + col2 * 18 + 1;
                int y = startY + row * 18 + 1;
                int slotIndex = index++;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, slotIndex, x2, y){

                    public int func_178170_b(@Nonnull ItemStack stack) {
                        return 1;
                    }

                    public boolean func_75214_a(@Nonnull ItemStack stack) {
                        return !(stack.func_77973_b() instanceof QuantumFilterItem);
                    }

                    public void func_75218_e() {
                        super.func_75218_e();
                        QuantumFilterItem.saveHandler(QuantumFilterContainer.this.filterStack, QuantumFilterContainer.this.handler);
                    }
                });
            }
        }
        int playerInvY = startY + 72 + 14;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                x = 12 + col * 18;
                int y = playerInvY + row * 18;
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, x, y));
            }
        }
        int hotbarY = playerInvY + 54 + 4;
        for (col = 0; col < 9; ++col) {
            x = 12 + col * 18;
            this.func_75146_a(new Slot((IInventory)playerInventory, col, x, hotbarY));
        }
    }

    public QuantumFilterContainer(int id, PlayerInventory playerInventory, PacketBuffer buf) {
        this(id, playerInventory);
    }

    public ItemStack getFilterStack() {
        return this.filterStack;
    }

    public boolean isWhitelist() {
        return !this.filterStack.func_190926_b() && QuantumFilterItem.isWhitelist(this.filterStack);
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        if (id == 0 && !this.filterStack.func_190926_b() && this.filterStack.func_77973_b() instanceof QuantumFilterItem) {
            QuantumFilterItem.toggleWhitelist(this.filterStack);
            QuantumFilterItem.saveHandler(this.filterStack, this.handler);
            return true;
        }
        return super.func_75140_a(playerIn, id);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        ItemStack current = QuantumFilterContainer.findFilterStack(playerIn);
        return !current.func_190926_b() && current.func_77973_b() instanceof QuantumFilterItem;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack result = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            result = stack.func_77946_l();
            int filterSlots = 16;
            if (index < filterSlots ? !this.func_75135_a(stack, filterSlots, this.field_75151_b.size(), true) : !this.func_75135_a(stack, 0, filterSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack);
        }
        return result;
    }

    private static ItemStack findFilterStack(PlayerEntity player) {
        ItemStack main = player.func_184614_ca();
        if (main.func_77973_b() instanceof QuantumFilterItem) {
            return main;
        }
        ItemStack off = player.func_184592_cb();
        if (off.func_77973_b() instanceof QuantumFilterItem) {
            return off;
        }
        return ItemStack.field_190927_a;
    }
}

