/*
 * Decompiled with CFR 0.152.
 */
package QCore.quantumquarry.world.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class QuantumBiomeFilterItem
extends Item {
    private static final String TAG_DIMENSION_ID = "DimensionId";

    public QuantumBiomeFilterItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_150297_b(TAG_DIMENSION_ID, 8)) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        ResourceLocation dimId = world.func_234923_W_().func_240901_a_();
        if (dimId == null) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        tag.func_74778_a(TAG_DIMENSION_ID, dimId.toString());
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public static boolean hasBoundDimension(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b(TAG_DIMENSION_ID, 8);
    }

    public static ResourceLocation getBoundDimensionId(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_150297_b(TAG_DIMENSION_ID, 8)) {
            return null;
        }
        String s = tag.func_74779_i(TAG_DIMENSION_ID);
        if (s.isEmpty()) {
            return null;
        }
        return new ResourceLocation(s);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ResourceLocation dimId = QuantumBiomeFilterItem.getBoundDimensionId(stack);
        if (dimId != null) {
            if ("minecraft".equals(dimId.func_110624_b())) {
                String path = dimId.func_110623_a();
                String key = "world.quantumquarry." + path;
                return new TranslationTextComponent(key);
            }
            return new StringTextComponent(dimId.toString());
        }
        return new TranslationTextComponent(this.func_77667_c(stack));
    }

    public void func_77624_a(@Nonnull ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        ResourceLocation dimId = QuantumBiomeFilterItem.getBoundDimensionId(stack);
        if (dimId != null) {
            TranslationTextComponent desc = new TranslationTextComponent("item.quantumquarry.quantum_world_filter.bound_desc");
            String colored = TextFormatting.LIGHT_PURPLE.toString() + desc.getString();
            tooltip.add((ITextComponent)new StringTextComponent(colored));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.quantumquarry.quantum_world_filter.unbound"));
        }
    }
}

