/*
 * Decompiled with CFR 0.152.
 */
package QCore.quantumquarry.world.item;

import QCore.quantumquarry.world.container.QuantumFilterContainer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class QuantumFilterItem
extends Item {
    public static final int FILTER_SLOTS = 16;
    private static final String TAG_FILTER_INV = "FilterInv";
    private static final String TAG_WHITELIST = "Whitelist";

    public QuantumFilterItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return ActionResult.func_226248_a_((Object)stack);
        }
        ItemStack filterStack = stack.func_77946_l();
        boolean whitelist = QuantumFilterItem.isWhitelist(filterStack);
        TranslationTextComponent title = new TranslationTextComponent(whitelist ? "container.quantumquarry.quantum_filter_whitelist" : "container.quantumquarry.quantum_filter_blacklist");
        player.func_213829_a(new INamedContainerProvider((ITextComponent)title){
            final /* synthetic */ ITextComponent val$title;
            {
                this.val$title = iTextComponent;
            }

            public ITextComponent func_145748_c_() {
                return this.val$title;
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new QuantumFilterContainer(id, playerInventory);
            }
        });
        return ActionResult.func_226248_a_((Object)stack);
    }

    public static ItemStackHandler getOrCreateHandler(ItemStack stack) {
        ItemStackHandler handler = new ItemStackHandler(16){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(TAG_FILTER_INV, 10)) {
            handler.deserializeNBT(tag.func_74775_l(TAG_FILTER_INV));
        }
        return handler;
    }

    public static void saveHandler(ItemStack stack, ItemStackHandler handler) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_218657_a(TAG_FILTER_INV, (INBT)handler.serializeNBT());
    }

    @Nonnull
    public static List<Item> getFilteredItems(ItemStack filterStack) {
        ArrayList<Item> result = new ArrayList<Item>();
        if (!(filterStack.func_77973_b() instanceof QuantumFilterItem)) {
            return result;
        }
        ItemStackHandler handler = QuantumFilterItem.getOrCreateHandler(filterStack);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack s = handler.getStackInSlot(i);
            if (s.func_190926_b()) continue;
            result.add(s.func_77973_b());
        }
        return result;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        boolean whitelist = QuantumFilterItem.isWhitelist(stack);
        String key = whitelist ? "item.quantumquarry.quantum_filter_whitelist" : "item.quantumquarry.quantum_filter_blacklist";
        return new TranslationTextComponent(key);
    }

    public static boolean isWhitelist(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_74767_n(TAG_WHITELIST);
    }

    public static void setWhitelist(ItemStack stack, boolean whitelist) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74757_a(TAG_WHITELIST, whitelist);
    }

    public static void toggleWhitelist(ItemStack stack) {
        QuantumFilterItem.setWhitelist(stack, !QuantumFilterItem.isWhitelist(stack));
    }
}

