/*
 * Decompiled with CFR 0.152.
 */
package QCore.quantumquarry.world.tile;

import QCore.quantumquarry.content.ModBlocks;
import QCore.quantumquarry.content.ModTiles;
import QCore.quantumquarry.world.block.QuantumCoreBlock;
import QCore.quantumquarry.world.block.QuantumFrameBlock;
import QCore.quantumquarry.world.container.QuantumCoreContainer;
import QCore.quantumquarry.world.energy.SerializableEnergyStorage;
import QCore.quantumquarry.world.item.QuantumBiomeFilterItem;
import QCore.quantumquarry.world.item.QuantumFilterItem;
import QCore.quantumquarry.world.tile.QuantumFrameTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class QuantumCoreTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int RF_PER_ORE = 2500;
    public static final int MAX_RF = 1000000;
    public static final int ORE_SLOTS = 64;
    public static final int UPGRADE_SLOTS = 6;
    public static final int FILTER_SLOTS = 2;
    private final ItemStackHandler oreStorage = new ItemStackHandler(64){

        protected void onContentsChanged(int slot) {
            QuantumCoreTileEntity.this.func_70296_d();
        }
    };
    private final ItemStackHandler filterStorage = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            QuantumCoreTileEntity.this.func_70296_d();
        }
    };
    private final ItemStackHandler upgradeStorage = new ItemStackHandler(6){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (stack.func_77973_b() != Items.field_151134_bR) {
                return false;
            }
            Map ench = EnchantmentHelper.func_82781_a((ItemStack)stack);
            Integer eff = (Integer)ench.get(Enchantments.field_185305_q);
            Integer fortune = (Integer)ench.get(Enchantments.field_185308_t);
            Integer silk = (Integer)ench.get(Enchantments.field_185306_r);
            return eff != null && eff > 0 || fortune != null && fortune > 0 || silk != null && silk > 0;
        }

        protected void onContentsChanged(int slot) {
            QuantumCoreTileEntity.this.func_70296_d();
        }
    };
    private final SerializableEnergyStorage energy = new SerializableEnergyStorage(1000000, 1000000, 1000000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!QuantumCoreTileEntity.this.isStructureValid()) {
                return 0;
            }
            int received = super.receiveEnergy(maxReceive, simulate);
            if (!simulate && received > 0) {
                QuantumCoreTileEntity.this.func_70296_d();
                QuantumCoreTileEntity.this.syncEnergyToClient();
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (!simulate && extracted > 0) {
                QuantumCoreTileEntity.this.func_70296_d();
                QuantumCoreTileEntity.this.syncEnergyToClient();
            }
            return extracted;
        }
    };
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private final LazyOptional<IItemHandler> itemCap = LazyOptional.of(this::createItemHandler);
    private final Random random = new Random();
    private double mineProgress = 0.0;
    private int lastSyncedEnergy = -1;
    private boolean wasStructureValid = false;
    private long totalMined = 0L;
    private long lastSyncedTotalMined = -1L;

    public QuantumCoreTileEntity() {
        super((TileEntityType)ModTiles.QUANTUM_CORE_TILE.get());
    }

    public void func_73660_a() {
        int MAX_ORES_PER_TICK;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        boolean active = this.isStructureValid();
        if (this.wasStructureValid && !active) {
            this.dropAllContents();
            this.totalMined = 0L;
            this.func_70296_d();
            this.syncMinedToClient();
        }
        this.wasStructureValid = active;
        if (!active) {
            this.updateActiveState(false);
            return;
        }
        if (this.isRedstonePowered()) {
            this.updateActiveState(false);
            this.mineProgress = 0.0;
            return;
        }
        this.pushOutputs();
        if (!this.hasInternalSpace()) {
            this.updateActiveState(this.energy.getEnergyStored() > 0);
            this.syncEnergyToClient();
            return;
        }
        if (this.energy.getEnergyStored() < 2500) {
            this.updateActiveState(false);
            this.syncEnergyToClient();
            return;
        }
        double speedMultiplier = this.computeSpeedMultiplier();
        boolean hasAutoSmelt = true;
        boolean hasSilkTouch = this.hasSilkTouchUpgrade();
        boolean isNetherOrEnd = this.isTargetDimensionNetherOrEnd();
        double oresPerSecond = speedMultiplier * 1.5;
        this.mineProgress += oresPerSecond / 20.0;
        int toProduce = (int)Math.floor(this.mineProgress);
        if (toProduce > (MAX_ORES_PER_TICK = 16)) {
            toProduce = MAX_ORES_PER_TICK;
        }
        if (toProduce > 0) {
            ItemStack stack;
            int produced = 0;
            for (int i = 0; i < toProduce && this.energy.getEnergyStored() >= 2500 && !(stack = this.getRandomOreDrop()).func_190926_b(); ++i) {
                int placed;
                ItemStack smelted;
                if (isNetherOrEnd && (stack = this.convertOreDropForNetherEnd(stack, hasSilkTouch)).func_190926_b()) continue;
                if (hasAutoSmelt && !hasSilkTouch && !isNetherOrEnd && !(smelted = this.getSmeltResult(stack)).func_190926_b()) {
                    stack = smelted;
                }
                if (hasSilkTouch && stack.func_77973_b() == Items.field_221585_m) {
                    stack = new ItemStack((IItemProvider)Items.field_221574_b, stack.func_190916_E());
                }
                if (this.isBlockedByFilters(stack)) continue;
                int fortune = this.getFortuneLevel();
                if (fortune > 0 && !hasSilkTouch) {
                    this.applyFortuneBonus(stack, fortune);
                }
                int originalCount = stack.func_190916_E();
                ItemStack remainder = this.tryInsertIntoNeighbors(stack);
                if (!remainder.func_190926_b()) {
                    remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.oreStorage, (ItemStack)remainder, (boolean)false);
                }
                if ((placed = originalCount - remainder.func_190916_E()) <= 0) break;
                this.energy.extractEnergy(2500, false);
                ++produced;
                ++this.totalMined;
                this.pushOutputs();
                this.spawnMiningParticles();
                if (!remainder.func_190926_b()) break;
            }
            if (produced > 0) {
                this.mineProgress -= (double)produced;
                this.syncMinedToClient();
            }
        }
        this.updateActiveState(this.energy.getEnergyStored() > 0);
        this.syncEnergyToClient();
    }

    private void syncEnergyToClient() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        int current = this.energy.getEnergyStored();
        if (current == this.lastSyncedEnergy) {
            return;
        }
        this.lastSyncedEnergy = current;
        BlockState state = this.func_195044_w();
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    private void syncMinedToClient() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        long current = this.totalMined;
        if (current == this.lastSyncedTotalMined) {
            return;
        }
        this.lastSyncedTotalMined = current;
        BlockState state = this.func_195044_w();
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    private void spawnMiningParticles() {
        if (this.field_145850_b instanceof ServerWorld) {
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.8, (double)this.field_174879_c.func_177952_p() + 0.5, 6, 0.2, 0.2, 0.2, 0.02);
        }
    }

    private boolean hasInternalSpace() {
        for (int i = 0; i < this.oreStorage.getSlots(); ++i) {
            ItemStack stack = this.oreStorage.getStackInSlot(i);
            if (stack.func_190926_b()) {
                return true;
            }
            if (stack.func_190916_E() >= Math.min(stack.func_77976_d(), this.oreStorage.getSlotLimit(i))) continue;
            return true;
        }
        return false;
    }

    private void dropAllContents() {
        ItemStack stack;
        int i;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        for (i = 0; i < this.oreStorage.getSlots(); ++i) {
            stack = this.oreStorage.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)stack.func_77946_l());
            this.oreStorage.extractItem(i, stack.func_190916_E(), false);
        }
        for (i = 0; i < this.upgradeStorage.getSlots(); ++i) {
            stack = this.upgradeStorage.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)stack.func_77946_l());
            this.upgradeStorage.extractItem(i, stack.func_190916_E(), false);
        }
        for (i = 0; i < this.filterStorage.getSlots(); ++i) {
            stack = this.filterStorage.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)stack.func_77946_l());
            this.filterStorage.extractItem(i, stack.func_190916_E(), false);
        }
    }

    private ItemStack tryInsertIntoNeighbors(ItemStack stack) {
        if (this.field_145850_b == null || stack.func_190926_b()) {
            return stack;
        }
        ItemStack remaining = stack.func_77946_l();
        for (Direction dir : Direction.values()) {
            if (remaining.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            BlockPos p = this.field_174879_c.func_177972_a(dir);
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (te == null || te instanceof QuantumFrameTileEntity) continue;
            ItemStack toInsert = remaining.func_77946_l();
            ItemStack rem = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(dst -> ItemHandlerHelper.insertItemStacked((IItemHandler)dst, (ItemStack)toInsert, (boolean)false)).orElse(toInsert);
            int moved = toInsert.func_190916_E() - rem.func_190916_E();
            if (moved <= 0) continue;
            remaining.func_190918_g(moved);
        }
        block1: for (Direction frameDir : Direction.values()) {
            if (remaining.func_190926_b()) break;
            BlockPos framePos = this.field_174879_c.func_177972_a(frameDir);
            BlockState frameState = this.field_145850_b.func_180495_p(framePos);
            if (frameState.func_177230_c() != ModBlocks.QUANTUM_FRAME.get()) continue;
            for (Direction out : Direction.values()) {
                TileEntity te;
                BlockState targetState;
                if (remaining.func_190926_b()) continue block1;
                BlockPos targetPos = framePos.func_177972_a(out);
                if (targetPos.equals((Object)this.field_174879_c) || (targetState = this.field_145850_b.func_180495_p(targetPos)).func_177230_c() == ModBlocks.QUANTUM_FRAME.get() || (te = this.field_145850_b.func_175625_s(targetPos)) == null) continue;
                ItemStack toInsert = remaining.func_77946_l();
                ItemStack rem = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(dst -> ItemHandlerHelper.insertItemStacked((IItemHandler)dst, (ItemStack)toInsert, (boolean)false)).orElse(toInsert);
                int moved = toInsert.func_190916_E() - rem.func_190916_E();
                if (moved <= 0) continue;
                remaining.func_190918_g(moved);
            }
        }
        return remaining;
    }

    private IItemHandler createItemHandler() {
        return new IItemHandler(){

            public int getSlots() {
                return QuantumCoreTileEntity.this.oreStorage.getSlots();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                if (slot < 0 || slot >= this.getSlots()) {
                    return ItemStack.field_190927_a;
                }
                return QuantumCoreTileEntity.this.oreStorage.getStackInSlot(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                Item item;
                if (amount <= 0) {
                    return ItemStack.field_190927_a;
                }
                if (slot < 0 || slot >= this.getSlots()) {
                    return ItemStack.field_190927_a;
                }
                ItemStack current = this.getStackInSlot(slot);
                if (!(current.func_190926_b() || (item = current.func_77973_b()) != Items.field_151122_aG && item != Items.field_151134_bR)) {
                    return ItemStack.field_190927_a;
                }
                return QuantumCoreTileEntity.this.oreStorage.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                if (slot < 0 || slot >= this.getSlots()) {
                    return 0;
                }
                return QuantumCoreTileEntity.this.oreStorage.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot < 0 || slot >= this.getSlots()) {
                    return false;
                }
                return QuantumCoreTileEntity.this.oreStorage.isItemValid(slot, stack);
            }
        };
    }

    private void updateActiveState(boolean active) {
        boolean current;
        if (this.field_145850_b == null) {
            return;
        }
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() == ModBlocks.QUANTUM_CORE.get() && state.func_235901_b_((Property)QuantumCoreBlock.ACTIVE) && (current = ((Boolean)state.func_177229_b((Property)QuantumCoreBlock.ACTIVE)).booleanValue()) != active) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)QuantumCoreBlock.ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
        }
        for (Direction dir : Direction.values()) {
            boolean lit;
            BlockPos framePos = this.field_174879_c.func_177972_a(dir);
            BlockState frameState = this.field_145850_b.func_180495_p(framePos);
            if (frameState.func_177230_c() != ModBlocks.QUANTUM_FRAME.get() || !frameState.func_235901_b_((Property)QuantumFrameBlock.LIT) || (lit = ((Boolean)frameState.func_177229_b((Property)QuantumFrameBlock.LIT)).booleanValue()) == active) continue;
            this.field_145850_b.func_180501_a(framePos, (BlockState)frameState.func_206870_a((Property)QuantumFrameBlock.LIT, (Comparable)Boolean.valueOf(active)), 3);
        }
    }

    private double computeSpeedMultiplier() {
        int totalEfficiencyLevels = 0;
        for (int i = 0; i < this.upgradeStorage.getSlots(); ++i) {
            Map ench;
            Integer lvl;
            ItemStack s = this.upgradeStorage.getStackInSlot(i);
            if (s.func_190926_b() || s.func_77973_b() != Items.field_151134_bR || (lvl = (Integer)(ench = EnchantmentHelper.func_82781_a((ItemStack)s)).get(Enchantments.field_185305_q)) == null || lvl <= 0) continue;
            totalEfficiencyLevels += lvl.intValue();
        }
        return 1.0 + 0.75 * (double)totalEfficiencyLevels;
    }

    private int countAutoSmeltBooks() {
        int count = 0;
        for (int i = 0; i < this.upgradeStorage.getSlots(); ++i) {
            ItemStack s = this.upgradeStorage.getStackInSlot(i);
            if (s.func_190926_b() || s.func_77973_b() != Items.field_151134_bR) continue;
            count += s.func_190916_E();
        }
        return count;
    }

    private boolean hasSilkTouchUpgrade() {
        for (int i = 0; i < this.upgradeStorage.getSlots(); ++i) {
            Map ench;
            Integer lvl;
            ItemStack s = this.upgradeStorage.getStackInSlot(i);
            if (s.func_190926_b() || s.func_77973_b() != Items.field_151134_bR || (lvl = (Integer)(ench = EnchantmentHelper.func_82781_a((ItemStack)s)).get(Enchantments.field_185306_r)) == null || lvl <= 0) continue;
            return true;
        }
        return false;
    }

    private int getFortuneLevel() {
        int totalFortune = 0;
        for (int i = 0; i < this.upgradeStorage.getSlots(); ++i) {
            Map ench;
            Integer lvl;
            ItemStack s = this.upgradeStorage.getStackInSlot(i);
            if (s.func_190926_b() || s.func_77973_b() != Items.field_151134_bR || (lvl = (Integer)(ench = EnchantmentHelper.func_82781_a((ItemStack)s)).get(Enchantments.field_185308_t)) == null || lvl <= 0) continue;
            totalFortune += lvl.intValue();
        }
        return totalFortune;
    }

    private void applyFortuneBonus(ItemStack stack, int totalFortune) {
        if (stack.func_190926_b() || totalFortune <= 0) {
            return;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151045_i || item == Items.field_151166_bC || item == Items.field_196128_bn || item == Items.field_151137_ax || item == Items.field_151044_h || item == Items.field_151128_bU) {
            int bonus = 0;
            for (int i = 0; i < totalFortune; ++i) {
                bonus += 1 + this.random.nextInt(2);
            }
            if (bonus > 0) {
                stack.func_190917_f(bonus);
            }
        }
    }

    private boolean isRedstonePowered() {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return true;
        }
        for (Direction dir : Direction.values()) {
            BlockPos p = this.field_174879_c.func_177972_a(dir);
            if (!this.field_145850_b.func_175640_z(p)) continue;
            return true;
        }
        return false;
    }

    public boolean isStructureValid() {
        if (this.field_145850_b == null) {
            return false;
        }
        BlockPos P = this.field_174879_c;
        BlockState below = this.field_145850_b.func_180495_p(P.func_177977_b());
        BlockState above = this.field_145850_b.func_180495_p(P.func_177984_a());
        if (below.func_177230_c() != ModBlocks.QUANTUM_FRAME.get()) {
            return false;
        }
        if (above.func_177230_c() != ModBlocks.QUANTUM_FRAME.get()) {
            return false;
        }
        if (this.field_145850_b.func_180495_p(P.func_177978_c()).func_177230_c() != ModBlocks.QUANTUM_FRAME.get()) {
            return false;
        }
        if (this.field_145850_b.func_180495_p(P.func_177968_d()).func_177230_c() != ModBlocks.QUANTUM_FRAME.get()) {
            return false;
        }
        if (this.field_145850_b.func_180495_p(P.func_177974_f()).func_177230_c() != ModBlocks.QUANTUM_FRAME.get()) {
            return false;
        }
        return this.field_145850_b.func_180495_p(P.func_177976_e()).func_177230_c() == ModBlocks.QUANTUM_FRAME.get();
    }

    private ItemStack getRandomOreDrop() {
        ResourceLocation cur;
        boolean hasWorldFilter;
        String dimId = null;
        ResourceLocation targetDim = this.getTargetDimensionId();
        boolean bl = hasWorldFilter = targetDim != null;
        if (targetDim != null) {
            dimId = targetDim.toString();
        } else if (this.field_145850_b != null && (cur = this.field_145850_b.func_234923_W_().func_240901_a_()) != null) {
            dimId = cur.toString();
        }
        if (dimId != null) {
            ResourceLocation dimKey;
            if ("minecraft:the_nether".equals(dimId)) {
                return hasWorldFilter ? this.getNetherDropWithFilter() : this.getNetherDrop();
            }
            if ("minecraft:the_end".equals(dimId)) {
                return this.getEndDrop();
            }
            if ("minecraft:overworld".equals(dimId)) {
                return hasWorldFilter ? this.getOverworldDrop() : this.getOverworldDropNoWorldFilter();
            }
            Object object = targetDim != null ? targetDim : (dimKey = this.field_145850_b != null ? this.field_145850_b.func_234923_W_().func_240901_a_() : null);
            if (dimKey != null) {
                return this.getModdedDimensionDrop(dimKey);
            }
        }
        return hasWorldFilter ? this.getOverworldDrop() : this.getOverworldDropNoWorldFilter();
    }

    private ItemStack getOverworldDrop() {
        int roll = this.random.nextInt(100);
        if (roll < 60) {
            int sub = this.random.nextInt(100);
            boolean silk = this.hasSilkTouchUpgrade();
            if (sub < 20) {
                if (silk) {
                    return new ItemStack((IItemProvider)Items.field_221581_i, 1 + this.random.nextInt(3));
                }
                return new ItemStack((IItemProvider)Items.field_221582_j, 1 + this.random.nextInt(3));
            }
            if (sub < 60) {
                return new ItemStack((IItemProvider)Items.field_221585_m, 1 + this.random.nextInt(3));
            }
            if (sub < 85) {
                return new ItemStack((IItemProvider)Items.field_221550_C, 1 + this.random.nextInt(2));
            }
            if (sub < 100) {
                return new ItemStack((IItemProvider)Items.field_221579_g, 1 + this.random.nextInt(2));
            }
            return new ItemStack((IItemProvider)Items.field_221585_m);
        }
        if (roll < 95) {
            List<Item> ores = this.getOverworldOresFromTag();
            if (!ores.isEmpty()) {
                Item item = ores.get(this.random.nextInt(ores.size()));
                return new ItemStack((IItemProvider)item);
            }
            return new ItemStack((IItemProvider)Items.field_221582_j);
        }
        int junk = this.random.nextInt(100);
        if (junk < 50) {
            return new ItemStack((IItemProvider)Items.field_151145_ak, 1 + this.random.nextInt(2));
        }
        return new ItemStack((IItemProvider)Items.field_151055_y, 1 + this.random.nextInt(3));
    }

    private ItemStack getOverworldDropNoWorldFilter() {
        int roll = this.random.nextInt(100);
        if (roll < 60) {
            int sub = this.random.nextInt(100);
            boolean silk = this.hasSilkTouchUpgrade();
            if (sub < 20) {
                if (silk) {
                    return new ItemStack((IItemProvider)Items.field_221581_i, 1 + this.random.nextInt(3));
                }
                return new ItemStack((IItemProvider)Items.field_221582_j, 1 + this.random.nextInt(3));
            }
            if (sub < 60) {
                return new ItemStack((IItemProvider)Items.field_221585_m, 1 + this.random.nextInt(3));
            }
            if (sub < 85) {
                return new ItemStack((IItemProvider)Items.field_221550_C, 1 + this.random.nextInt(2));
            }
            if (sub < 100) {
                return new ItemStack((IItemProvider)Items.field_221579_g, 1 + this.random.nextInt(2));
            }
            return new ItemStack((IItemProvider)Items.field_221585_m);
        }
        if (roll < 95) {
            int special = this.random.nextInt(100);
            if (special < 5) {
                return new ItemStack((IItemProvider)Items.field_234795_rx_, 1);
            }
            List<Item> ores = this.getOreItemsFromTag();
            if (!ores.isEmpty()) {
                Item item = ores.get(this.random.nextInt(ores.size()));
                return new ItemStack((IItemProvider)item);
            }
            return new ItemStack((IItemProvider)Items.field_221582_j);
        }
        int junk = this.random.nextInt(100);
        if (junk < 50) {
            return new ItemStack((IItemProvider)Items.field_151145_ak, 1 + this.random.nextInt(2));
        }
        return new ItemStack((IItemProvider)Items.field_151055_y, 1 + this.random.nextInt(3));
    }

    private ItemStack getNetherDrop() {
        int roll = this.random.nextInt(100);
        if (roll < 70) {
            int sub = this.random.nextInt(100);
            if (sub < 50) {
                return new ItemStack((IItemProvider)Items.field_221691_cH, 1 + this.random.nextInt(4));
            }
            if (sub < 75) {
                return new ItemStack((IItemProvider)Items.field_221693_cI, 1 + this.random.nextInt(3));
            }
            if (sub < 90) {
                return new ItemStack((IItemProvider)Items.field_234735_dn_, 1 + this.random.nextInt(3));
            }
            return new ItemStack((IItemProvider)Items.field_234777_rA_, 1 + this.random.nextInt(3));
        }
        if (roll < 97) {
            List<Item> netherOres = this.getDimensionOresFromTag("nether");
            if (!netherOres.isEmpty()) {
                Item item = netherOres.get(this.random.nextInt(netherOres.size()));
                return new ItemStack((IItemProvider)item);
            }
            int sub = this.random.nextInt(100);
            if (sub < 60) {
                return new ItemStack((IItemProvider)Items.field_151128_bU, 1 + this.random.nextInt(3));
            }
            if (sub < 90) {
                return new ItemStack((IItemProvider)Items.field_151114_aO, 2 + this.random.nextInt(3));
            }
            return new ItemStack((IItemProvider)Items.field_234795_rx_, 1);
        }
        if (this.random.nextBoolean()) {
            return new ItemStack((IItemProvider)Items.field_151074_bl, 2 + this.random.nextInt(4));
        }
        return new ItemStack((IItemProvider)Items.field_151072_bj, 1 + this.random.nextInt(2));
    }

    private ItemStack getNetherDropWithFilter() {
        int roll = this.random.nextInt(100);
        if (roll < 70) {
            int sub = this.random.nextInt(100);
            if (sub < 50) {
                return new ItemStack((IItemProvider)Items.field_221691_cH, 1 + this.random.nextInt(4));
            }
            if (sub < 75) {
                return new ItemStack((IItemProvider)Items.field_221693_cI, 1 + this.random.nextInt(3));
            }
            if (sub < 90) {
                return new ItemStack((IItemProvider)Items.field_234735_dn_, 1 + this.random.nextInt(3));
            }
            return new ItemStack((IItemProvider)Items.field_234777_rA_, 1 + this.random.nextInt(3));
        }
        if (roll < 97) {
            List<Item> netherOres = this.getDimensionOresFromTag("nether");
            if (!netherOres.isEmpty()) {
                int special = this.random.nextInt(100);
                if (special < 20) {
                    return new ItemStack((IItemProvider)Items.field_234795_rx_, 1);
                }
                Item item = netherOres.get(this.random.nextInt(netherOres.size()));
                return new ItemStack((IItemProvider)item);
            }
            int sub = this.random.nextInt(100);
            if (sub < 50) {
                return new ItemStack((IItemProvider)Items.field_151128_bU, 1 + this.random.nextInt(3));
            }
            if (sub < 80) {
                return new ItemStack((IItemProvider)Items.field_151114_aO, 2 + this.random.nextInt(3));
            }
            return new ItemStack((IItemProvider)Items.field_234795_rx_, 1);
        }
        if (this.random.nextBoolean()) {
            return new ItemStack((IItemProvider)Items.field_151074_bl, 2 + this.random.nextInt(4));
        }
        return new ItemStack((IItemProvider)Items.field_151072_bj, 1 + this.random.nextInt(2));
    }

    private ItemStack getEndDrop() {
        int roll = this.random.nextInt(100);
        if (roll < 70) {
            int sub = this.random.nextInt(100);
            if (sub < 80) {
                return new ItemStack((IItemProvider)Items.field_221828_dx, 1 + this.random.nextInt(4));
            }
            return new ItemStack((IItemProvider)Items.field_221665_bU, 1 + this.random.nextInt(2));
        }
        if (roll < 96) {
            List<Item> endOres = this.getDimensionOresFromTag("end");
            if (!endOres.isEmpty()) {
                Item item = endOres.get(this.random.nextInt(endOres.size()));
                return new ItemStack((IItemProvider)item);
            }
            int sub = this.random.nextInt(100);
            if (sub < 60) {
                return new ItemStack((IItemProvider)Items.field_185161_cS, 1 + this.random.nextInt(3));
            }
            if (sub < 90) {
                return new ItemStack((IItemProvider)Items.field_151079_bi, 1);
            }
            return new ItemStack((IItemProvider)Items.field_151061_bv, 1);
        }
        if (this.random.nextBoolean()) {
            return new ItemStack((IItemProvider)Items.field_190930_cZ, 1);
        }
        return new ItemStack((IItemProvider)Items.field_151061_bv, 1);
    }

    private ItemStack getModdedDimensionDrop(ResourceLocation dim) {
        if (dim == null) {
            return ItemStack.field_190927_a;
        }
        String keyword = dim.func_110623_a();
        List<Item> ores = this.getDimensionOresFromTag(keyword != null ? keyword : "");
        ArrayList<Item> filtered = new ArrayList<Item>();
        for (Item i : ores) {
            ResourceLocation id = i.getRegistryName();
            if (id == null || "minecraft".equals(id.func_110624_b())) continue;
            if (id.func_110624_b().equals(dim.func_110624_b())) {
                filtered.add(i);
                continue;
            }
            String path = id.func_110623_a();
            if (path == null || keyword == null || !path.toLowerCase(Locale.ROOT).contains(keyword.toLowerCase(Locale.ROOT))) continue;
            filtered.add(i);
        }
        if (filtered.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        Item item = (Item)filtered.get(this.random.nextInt(filtered.size()));
        return new ItemStack((IItemProvider)item);
    }

    private List<Item> getOreItemsFromTag() {
        ArrayList<Item> result = new ArrayList<Item>();
        try {
            for (Item i : Tags.Items.ORES.func_230236_b_()) {
                result.add(i);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!result.isEmpty()) {
            return result;
        }
        try {
            for (Block b : Tags.Blocks.ORES.func_230236_b_()) {
                Item it = b.func_199767_j();
                if (it == null || it == Items.field_190931_a) continue;
                result.add(it);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private List<Item> getOverworldOresFromTag() {
        List<Item> all = this.getOreItemsFromTag();
        if (all.isEmpty()) {
            return all;
        }
        ArrayList<Item> filtered = new ArrayList<Item>();
        for (Item i : all) {
            String lower;
            String path;
            ResourceLocation id = i.getRegistryName();
            if (id == null || (path = id.func_110623_a()) == null || (lower = path.toLowerCase(Locale.ROOT)).contains("nether") || lower.contains("end") || "minecraft".equals(id.func_110624_b()) && "ancient_debris".equals(path)) continue;
            filtered.add(i);
        }
        return filtered;
    }

    private List<Item> getDimensionOresFromTag(String keyword) {
        List<Item> all = this.getOreItemsFromTag();
        if (all.isEmpty() || keyword == null || keyword.isEmpty()) {
            return all;
        }
        ArrayList<Item> filtered = new ArrayList<Item>();
        for (Item i : all) {
            String path;
            ResourceLocation id = i.getRegistryName();
            if (id == null || (path = id.func_110623_a()) == null || !path.toLowerCase(Locale.ROOT).contains(keyword.toLowerCase(Locale.ROOT))) continue;
            filtered.add(i);
        }
        return filtered;
    }

    private ItemStack getSmeltResult(ItemStack input) {
        ItemStack out;
        if (this.field_145850_b == null) {
            return ItemStack.field_190927_a;
        }
        if (input.func_77973_b() == Items.field_221585_m) {
            return ItemStack.field_190927_a;
        }
        Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{input}), this.field_145850_b);
        if (recipe.isPresent() && !(out = ((FurnaceRecipe)recipe.get()).func_77571_b().func_77946_l()).func_190926_b()) {
            return out;
        }
        return ItemStack.field_190927_a;
    }

    private boolean isBlockedByFilters(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        boolean hasAnyFilter = false;
        boolean blockedByBlacklist = false;
        for (int i = 0; i < this.filterStorage.getSlots(); ++i) {
            ItemStack filterStack = this.filterStorage.getStackInSlot(i);
            if (filterStack.func_190926_b() || !(filterStack.func_77973_b() instanceof QuantumFilterItem)) continue;
            hasAnyFilter = true;
            List<Item> items = QuantumFilterItem.getFilteredItems(filterStack);
            if (items.isEmpty()) continue;
            boolean whitelist = QuantumFilterItem.isWhitelist(filterStack);
            if (whitelist) {
                if (items.contains(item)) continue;
                return true;
            }
            if (!items.contains(item)) continue;
            blockedByBlacklist = true;
        }
        if (!hasAnyFilter) {
            return false;
        }
        return blockedByBlacklist;
    }

    @Nullable
    private ResourceLocation getTargetDimensionId() {
        ArrayList<ResourceLocation> dims = new ArrayList<ResourceLocation>();
        for (int i = 0; i < this.filterStorage.getSlots(); ++i) {
            ResourceLocation bound;
            ItemStack filterStack = this.filterStorage.getStackInSlot(i);
            if (filterStack.func_190926_b() || !(filterStack.func_77973_b() instanceof QuantumBiomeFilterItem) || (bound = QuantumBiomeFilterItem.getBoundDimensionId(filterStack)) == null) continue;
            dims.add(bound);
        }
        if (dims.isEmpty()) {
            return null;
        }
        return (ResourceLocation)dims.get(this.random.nextInt(dims.size()));
    }

    private boolean isTargetDimensionNetherOrEnd() {
        ResourceLocation cur;
        String dimId = null;
        ResourceLocation targetDim = this.getTargetDimensionId();
        if (targetDim != null) {
            dimId = targetDim.toString();
        } else if (this.field_145850_b != null && (cur = this.field_145850_b.func_234923_W_().func_240901_a_()) != null) {
            dimId = cur.toString();
        }
        if (dimId == null) {
            return false;
        }
        if ("minecraft:the_nether".equals(dimId)) {
            return true;
        }
        return "minecraft:the_end".equals(dimId);
    }

    private ItemStack convertOreDropForNetherEnd(ItemStack stack, boolean hasSilkTouch) {
        if (stack.func_190926_b() || hasSilkTouch) {
            return stack;
        }
        if (!(stack.func_77973_b() instanceof BlockItem)) {
            return stack;
        }
        if (!(this.field_145850_b instanceof ServerWorld)) {
            return stack;
        }
        BlockItem blockItem = (BlockItem)stack.func_77973_b();
        Block block = blockItem.func_179223_d();
        BlockState state = block.func_176223_P();
        List drops = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)this.field_174879_c, null);
        if (drops == null || drops.isEmpty()) {
            return stack;
        }
        ItemStack primary = ((ItemStack)drops.get(0)).func_77946_l();
        for (int i = 1; i < drops.size(); ++i) {
            ItemStack d = (ItemStack)drops.get(i);
            if (d.func_190926_b() || !ItemStack.func_179545_c((ItemStack)primary, (ItemStack)d)) continue;
            primary.func_190917_f(d.func_190916_E());
        }
        if (stack.func_190916_E() > 1) {
            primary.func_190920_e(primary.func_190916_E() * stack.func_190916_E());
        }
        return primary;
    }

    private void pushOutputs() {
        if (this.field_145850_b == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlockPos p = this.field_174879_c.func_177972_a(dir);
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (te == null || te instanceof QuantumFrameTileEntity) continue;
            te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(dst -> this.moveAllPossible(this.oreStorage, (IItemHandler)dst));
        }
        for (Direction frameDir : Direction.values()) {
            BlockPos framePos = this.field_174879_c.func_177972_a(frameDir);
            BlockState frameState = this.field_145850_b.func_180495_p(framePos);
            if (frameState.func_177230_c() != ModBlocks.QUANTUM_FRAME.get()) continue;
            for (Direction out : Direction.values()) {
                TileEntity te;
                BlockState targetState;
                BlockPos targetPos = framePos.func_177972_a(out);
                if (targetPos.equals((Object)this.field_174879_c) || (targetState = this.field_145850_b.func_180495_p(targetPos)).func_177230_c() == ModBlocks.QUANTUM_FRAME.get() || (te = this.field_145850_b.func_175625_s(targetPos)) == null) continue;
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(dst -> this.moveAllPossible(this.oreStorage, (IItemHandler)dst));
            }
        }
    }

    private void moveAllPossible(ItemStackHandler src, IItemHandler dst) {
        for (int i = 0; i < src.getSlots(); ++i) {
            ItemStack stack = src.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemStack toMove = stack.func_77946_l();
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)dst, (ItemStack)toMove, (boolean)false);
            int moved = toMove.func_190916_E() - remainder.func_190916_E();
            if (moved <= 0) continue;
            src.extractItem(i, moved, false);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.oreStorage.deserializeNBT(nbt.func_74775_l("OreStorage"));
        this.upgradeStorage.deserializeNBT(nbt.func_74775_l("Upgrades"));
        if (nbt.func_74764_b("Filters")) {
            this.filterStorage.deserializeNBT(nbt.func_74775_l("Filters"));
        }
        this.energy.setEnergy(nbt.func_74762_e("Energy"));
        this.mineProgress = nbt.func_74769_h("MineProgress");
        if (nbt.func_74764_b("TotalMined")) {
            this.totalMined = nbt.func_74763_f("TotalMined");
        }
    }

    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt.func_218657_a("OreStorage", (INBT)this.oreStorage.serializeNBT());
        nbt.func_218657_a("Upgrades", (INBT)this.upgradeStorage.serializeNBT());
        nbt.func_218657_a("Filters", (INBT)this.filterStorage.serializeNBT());
        nbt.func_74768_a("Energy", this.energy.getEnergy());
        nbt.func_74780_a("MineProgress", this.mineProgress);
        nbt.func_74772_a("TotalMined", this.totalMined);
        return super.func_189515_b(nbt);
    }

    public IItemHandler getOreStorage() {
        return this.oreStorage;
    }

    public IItemHandler getUpgradeStorage() {
        return this.upgradeStorage;
    }

    public IItemHandler getFilterStorage() {
        return this.filterStorage;
    }

    public IEnergyStorage getEnergy() {
        return this.energy;
    }

    public long getTotalMined() {
        return this.totalMined;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.quantumquarry.quarry");
    }

    @Nullable
    public Container createMenu(int id, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new QuantumCoreContainer(id, playerInventory, this.field_174879_c);
    }
}

