/*
 * Decompiled with CFR 0.152.
 */
package QCore.quantumquarry.world.tile;

import QCore.quantumquarry.content.ModBlocks;
import QCore.quantumquarry.content.ModTiles;
import QCore.quantumquarry.world.tile.QuantumCoreTileEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;

public class QuantumFrameTileEntity
extends TileEntity {
    public QuantumFrameTileEntity() {
        super((TileEntityType)ModTiles.QUANTUM_FRAME_TILE.get());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        QuantumCoreTileEntity core = this.findCore();
        if (core != null) {
            LazyOptional itemCap;
            IEnergyStorage energy;
            if (cap == CapabilityEnergy.ENERGY && (energy = core.getEnergy()) != null) {
                return LazyOptional.of(() -> energy).cast();
            }
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (itemCap = core.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)).isPresent()) {
                return itemCap.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    private QuantumCoreTileEntity findCore() {
        if (this.field_145850_b == null) {
            return null;
        }
        for (Direction dir : Direction.values()) {
            TileEntity te;
            BlockPos cpos = this.field_174879_c.func_177972_a(dir);
            if (this.field_145850_b.func_180495_p(cpos).func_177230_c() != ModBlocks.QUANTUM_CORE.get() || !((te = this.field_145850_b.func_175625_s(cpos)) instanceof QuantumCoreTileEntity)) continue;
            return (QuantumCoreTileEntity)te;
        }
        return null;
    }
}

