/*
 * Decompiled with CFR 0.152.
 */
package org.zala.crossbowmulticharge.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_174;
import net.minecraft.class_1744;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3745;
import net.minecraft.class_5150;
import net.minecraft.class_5244;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.zala.crossbowmulticharge.moditems.ModContent;

@Mixin(value={class_1764.class})
public class CrossbowMixin
extends class_1811
implements class_5150 {
    @Unique
    private boolean charged = false;
    @Unique
    private boolean loaded = false;

    public CrossbowMixin(class_1792.class_1793 settings) {
        super(settings);
    }

    @Overwrite
    public Predicate<class_1799> method_20310() {
        return field_18282;
    }

    @Overwrite
    public Predicate<class_1799> method_19268() {
        return field_18281;
    }

    @Unique
    private static int getUpgradedStorageLevel(class_1799 itemStack) {
        return class_1890.method_8225((class_1887)ModContent.STORAGEUP, (class_1799)itemStack);
    }

    @Overwrite
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        int currentStorageSize;
        class_1799 itemStack = user.method_5998(hand);
        int n = currentStorageSize = CrossbowMixin.getUpgradedStorageLevel(itemStack) == 0 ? 6 : 10;
        if (user.method_5715() && CrossbowMixin.getProjectiles(itemStack).size() < currentStorageSize) {
            CrossbowMixin.setCharged(itemStack, false);
        }
        if (CrossbowMixin.isCharged(itemStack)) {
            CrossbowMixin.shootAll(world, (class_1309)user, hand, itemStack, CrossbowMixin.getSpeed(itemStack), 1.0f);
            if (CrossbowMixin.getProjectiles(itemStack).isEmpty()) {
                CrossbowMixin.setCharged(itemStack, false);
            }
            return class_1271.method_22428((Object)itemStack);
        }
        if (!user.method_18808(itemStack).method_7960() && CrossbowMixin.getProjectiles(itemStack).size() < currentStorageSize) {
            if (!CrossbowMixin.isCharged(itemStack)) {
                this.charged = false;
                this.loaded = false;
                user.method_6019(hand);
            }
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    @Unique
    private static float getSpeed(class_1799 stack) {
        return CrossbowMixin.hasProjectile(stack, class_1802.field_8639) ? 1.6f : 3.15f;
    }

    @Overwrite
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        int i = this.method_7881(stack) - remainingUseTicks;
        float f = CrossbowMixin.getPullProgress(i, stack);
        if (f >= 1.0f && !CrossbowMixin.isCharged(stack) && CrossbowMixin.loadProjectiles(user, stack)) {
            CrossbowMixin.setCharged(stack, true);
            class_3419 soundCategory = user instanceof class_1657 ? class_3419.field_15248 : class_3419.field_15251;
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14626, soundCategory, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f);
        }
    }

    @Unique
    private static boolean loadProjectiles(class_1309 shooter, class_1799 crossbow) {
        boolean bl = shooter instanceof class_1657 && ((class_1657)shooter).method_31549().field_7477;
        class_1799 itemStack = shooter.method_18808(crossbow);
        if (itemStack.method_7960() && bl) {
            itemStack = new class_1799((class_1935)class_1802.field_8107);
        }
        return CrossbowMixin.loadProjectile(shooter, crossbow, itemStack, false, bl);
    }

    @Unique
    private static boolean loadProjectile(class_1309 shooter, class_1799 crossbow, class_1799 projectile, boolean simulated, boolean creative) {
        class_1799 itemStack;
        boolean bl;
        if (projectile.method_7960()) {
            return false;
        }
        boolean bl2 = bl = creative && projectile.method_7909() instanceof class_1744;
        if (!(bl || creative || simulated)) {
            itemStack = projectile.method_7971(1);
            if (projectile.method_7960() && shooter instanceof class_1657) {
                ((class_1657)shooter).method_31548().method_7378(projectile);
            }
        } else {
            itemStack = projectile.method_7972();
        }
        CrossbowMixin.putProjectile(crossbow, itemStack);
        return true;
    }

    @Unique
    private static boolean isCharged(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        return nbtCompound != null && nbtCompound.method_10577("Charged");
    }

    @Unique
    private static void setCharged(class_1799 stack, boolean charged) {
        class_2487 nbtCompound = stack.method_7948();
        nbtCompound.method_10556("Charged", charged);
    }

    @Unique
    private static void putProjectile(class_1799 crossbow, class_1799 projectile) {
        class_2487 nbtCompound = crossbow.method_7948();
        class_2499 nbtList = nbtCompound.method_10573("ChargedProjectiles", 9) ? nbtCompound.method_10554("ChargedProjectiles", 10) : new class_2499();
        class_2487 nbtCompound2 = new class_2487();
        projectile.method_7953(nbtCompound2);
        nbtList.add((Object)nbtCompound2);
        nbtCompound.method_10566("ChargedProjectiles", (class_2520)nbtList);
    }

    @Unique
    private static List<class_1799> getProjectiles(class_1799 crossbow) {
        class_2499 nbtList;
        ArrayList list = Lists.newArrayList();
        class_2487 nbtCompound = crossbow.method_7969();
        if (nbtCompound != null && nbtCompound.method_10573("ChargedProjectiles", 9) && (nbtList = nbtCompound.method_10554("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound2 = nbtList.method_10602(i);
                list.add(class_1799.method_7915((class_2487)nbtCompound2));
            }
        }
        return list;
    }

    @Unique
    private static void decProjectiles(class_1799 crossbow) {
        class_2487 nbtCompound = crossbow.method_7969();
        if (nbtCompound != null) {
            class_2499 nbtList = nbtCompound.method_10554("ChargedProjectiles", 10);
            int id = nbtList.size() - 1;
            if (id >= 0) {
                nbtList.method_10536(id);
            }
            nbtCompound.method_10566("ChargedProjectiles", (class_2520)nbtList);
        }
    }

    @Unique
    private static boolean hasProjectile(class_1799 crossbow, class_1792 projectile) {
        return CrossbowMixin.getProjectiles(crossbow).stream().anyMatch(s -> s.method_31574(projectile));
    }

    @Unique
    private static void shoot(class_1937 world, class_1309 shooter, class_1268 hand, class_1799 crossbow, class_1799 projectile, float soundPitch, boolean creative, float speed, float divergence, float simulated) {
        if (!world.field_9236) {
            class_1665 projectileEntity;
            boolean bl = projectile.method_31574(class_1802.field_8639);
            if (bl) {
                projectileEntity = new class_1671(world, projectile, (class_1297)shooter, shooter.method_23317(), shooter.method_23320() - (double)0.15f, shooter.method_23321(), true);
            } else {
                projectileEntity = CrossbowMixin.createArrow(world, shooter, crossbow, projectile);
                if (creative || simulated != 0.0f) {
                    projectileEntity.field_7572 = class_1665.class_1666.field_7594;
                }
            }
            if (shooter instanceof class_3745) {
                class_3745 crossbowUser = (class_3745)shooter;
                crossbowUser.method_18811(crossbowUser.method_5968(), crossbow, (class_1676)projectileEntity, simulated);
            } else {
                class_243 vec3d = shooter.method_18864(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(simulated * ((float)Math.PI / 180)), vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
                class_243 vec3d2 = shooter.method_5828(1.0f);
                Vector3f vector3f = vec3d2.method_46409().rotate((Quaternionfc)quaternionf);
                projectileEntity.method_7485((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), speed, divergence);
            }
            crossbow.method_7956(bl ? 3 : 1, shooter, e -> e.method_20236(hand));
            world.method_8649((class_1297)projectileEntity);
            world.method_43128(null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), class_3417.field_15187, class_3419.field_15248, 1.0f, soundPitch);
        }
    }

    @Unique
    private static class_1665 createArrow(class_1937 world, class_1309 entity, class_1799 crossbow, class_1799 arrow) {
        class_1744 arrowItem = (class_1744)(arrow.method_7909() instanceof class_1744 ? arrow.method_7909() : class_1802.field_8107);
        class_1665 persistentProjectileEntity = arrowItem.method_7702(world, arrow, entity);
        if (entity instanceof class_1657) {
            persistentProjectileEntity.method_7439(true);
        }
        persistentProjectileEntity.method_7444(class_3417.field_14636);
        persistentProjectileEntity.method_7442(true);
        int i = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)crossbow);
        if (i > 0) {
            persistentProjectileEntity.method_7451((byte)i);
        }
        return persistentProjectileEntity;
    }

    @Unique
    private static void shootAll(class_1937 world, class_1309 entity, class_1268 hand, class_1799 stack, float speed, float divergence) {
        boolean bl;
        int i = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)stack);
        List<class_1799> list = CrossbowMixin.getProjectiles(stack);
        float[] fs = CrossbowMixin.getSoundPitches(entity.method_6051());
        int id = list.size() - 1;
        if (id < 0) {
            id = 0;
        }
        class_1799 itemStack = list.get(id);
        boolean bl2 = bl = entity instanceof class_1657 && ((class_1657)entity).method_31549().field_7477;
        if (!itemStack.method_7960()) {
            CrossbowMixin.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, 0.0f);
            if (i == 1) {
                CrossbowMixin.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, -10.0f);
                CrossbowMixin.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, 10.0f);
            }
        }
        CrossbowMixin.postShoot(world, entity, stack);
    }

    @Unique
    private static float[] getSoundPitches(class_5819 random) {
        boolean bl = random.method_43056();
        return new float[]{1.0f, CrossbowMixin.getSoundPitch(bl, random), CrossbowMixin.getSoundPitch(!bl, random)};
    }

    @Unique
    private static float getSoundPitch(boolean flag, class_5819 random) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (random.method_43057() * 0.5f + 1.8f) + f;
    }

    @Unique
    private static void postShoot(class_1937 world, class_1309 entity, class_1799 stack) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)entity;
            if (!world.field_9236) {
                class_174.field_1196.method_9115(serverPlayerEntity, stack);
            }
            serverPlayerEntity.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
        }
        CrossbowMixin.decProjectiles(stack);
    }

    @Overwrite
    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!world.field_9236) {
            int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
            class_3414 soundEvent = this.getQuickChargeSound(i);
            class_3414 soundEvent2 = i == 0 ? class_3417.field_14860 : null;
            float f = (float)(stack.method_7935() - remainingUseTicks) / (float)CrossbowMixin.getPullTime(stack);
            if (f < 0.2f) {
                this.charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f && !this.charged) {
                this.charged = true;
                world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), soundEvent, class_3419.field_15248, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundEvent2 != null && !this.loaded) {
                this.loaded = true;
                world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), soundEvent2, class_3419.field_15248, 0.5f, 1.0f);
            }
        }
    }

    @Overwrite
    public int method_7881(class_1799 stack) {
        return CrossbowMixin.getPullTime(stack) + 3;
    }

    @Unique
    private static int getPullTime(class_1799 stack) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    @Overwrite
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8947;
    }

    @Unique
    private class_3414 getQuickChargeSound(int stage) {
        return switch (stage) {
            case 1 -> class_3417.field_15011;
            case 2 -> class_3417.field_14916;
            case 3 -> class_3417.field_15089;
            default -> class_3417.field_14765;
        };
    }

    @Unique
    private static float getPullProgress(int useTicks, class_1799 stack) {
        float f = (float)useTicks / (float)CrossbowMixin.getPullTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Overwrite
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        List<class_1799> list = CrossbowMixin.getProjectiles(stack);
        if (CrossbowMixin.isCharged(stack) && !list.isEmpty()) {
            class_1799 itemStack = list.get(0);
            tooltip.add((class_2561)class_2561.method_43471((String)"item.minecraft.crossbow.projectile").method_10852(class_5244.field_41874).method_10852(itemStack.method_7954()));
            if (context.method_8035() && itemStack.method_31574(class_1802.field_8639)) {
                ArrayList list2 = Lists.newArrayList();
                class_1802.field_8639.method_7851(itemStack, world, (List)list2, context);
                if (!list2.isEmpty()) {
                    for (int i = 0; i < list2.size(); ++i) {
                        list2.set(i, class_2561.method_43470((String)"  ").method_10852((class_2561)list2.get(i)).method_27692(class_124.field_1080));
                    }
                    tooltip.addAll(list2);
                    tooltip.addAll(list2);
                    tooltip.addAll(list2);
                }
            }
        }
    }

    @Overwrite
    public boolean method_7838(class_1799 stack) {
        return stack.method_31574((class_1792)this);
    }

    @Overwrite
    public int method_24792() {
        return 8;
    }
}

