/*
 * Decompiled with CFR 0.152.
 */
package com.kloodoh.dropbar.hud;

import com.kloodoh.dropbar.DropBarClient;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10275;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1549;
import net.minecraft.class_1550;
import net.minecraft.class_1551;
import net.minecraft.class_1571;
import net.minecraft.class_1576;
import net.minecraft.class_1588;
import net.minecraft.class_1590;
import net.minecraft.class_1593;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1628;
import net.minecraft.class_1634;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4760;
import net.minecraft.class_4836;
import net.minecraft.class_5136;
import net.minecraft.class_5354;
import net.minecraft.class_7260;
import net.minecraft.class_746;
import net.minecraft.class_8949;
import net.minecraft.class_9254;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public final class DropBarRenderer {
    private static final int TARGET_HYST_FRAMES = 8;
    private static final Map<UUID, Integer> TARGET_TTL = new HashMap<UUID, Integer>();
    private static final int PIP_Y_OFFSET = 2;
    private static final double RADIUS = 64.0;
    private static final double MIN_ALPHA = 100.0;
    private static final double OCCLUDED_MAX = 12.0;

    private DropBarRenderer() {
    }

    public static void render(class_332 ctx, class_9779 tickCounter) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        if (!DropBarClient.isEnabled()) {
            return;
        }
        int screenW = ctx.method_51421();
        int screenH = ctx.method_51443();
        int barLeft = (screenW - 182) / 2;
        int barY = screenH - 32 + 3;
        class_746 player = mc.field_1724;
        if (player.method_7325() || player.method_31549().field_7477) {
            return;
        }
        class_243 pos = new class_243(player.method_23317(), player.method_23318(), player.method_23321());
        class_238 aabb = class_238.method_30048((class_243)pos, (double)128.0, (double)128.0, (double)128.0);
        List nearby = mc.field_1687.method_8333((class_1297)player, aabb, e -> {
            class_1308 mob;
            class_5354 ang;
            class_4836 pig;
            return e.method_5805() && !(e instanceof class_1657) && (e instanceof class_1588 && !(e instanceof class_4836) || e instanceof class_4836 && (pig = (class_4836)e).method_5968() instanceof class_1657 || e instanceof class_5354 && ((ang = (class_5354)e).method_29511() || ang.method_29507() > 0 || ang.method_29508() != null) || e instanceof class_1308 && (mob = (class_1308)e).method_5968() instanceof class_1657);
        });
        float camYaw = mc.method_1560() != null ? mc.method_1560().method_36454() : player.method_36454();
        float camPitch = mc.method_1560() != null ? mc.method_1560().method_36455() : player.method_36455();
        int mode = DropBarClient.getMode();
        HashSet<UUID> seenIds = new HashSet<UUID>();
        boolean[] pipUsed = new boolean[Math.max(1, screenW)];
        for (class_1297 ent : nearby) {
            boolean isBoss;
            double horiz;
            double elev;
            double relPitch;
            double entDistSq;
            double blockDistSq;
            class_1309 e2;
            double dist;
            seenIds.add(ent.method_5667());
            boolean targeting = false;
            if (!(ent instanceof class_1309) || (dist = Math.sqrt(player.method_5858((class_1297)(e2 = (class_1309)ent)))) > 64.0) continue;
            class_243 eyePos = player.method_33571();
            class_243 entCenter = e2.method_5829().method_1005();
            class_3965 hit = mc.field_1687.method_17742(new class_3959(eyePos, entCenter, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
            boolean occluded = false;
            if (hit.method_17783() == class_239.class_240.field_1332 && (blockDistSq = eyePos.method_1025(hit.method_17784())) + 0.25 < (entDistSq = eyePos.method_1025(entCenter))) {
                occluded = true;
            }
            if (occluded && dist > 12.0) continue;
            boolean detectedNow = false;
            if (ent instanceof class_1308) {
                class_1308 m = (class_1308)ent;
                detectedNow = m.method_5968() instanceof class_1657;
            }
            if (!detectedNow && ent instanceof class_5354) {
                class_5354 ang = (class_5354)ent;
                UUID angryAt = ang.method_29508();
                boolean bl = detectedNow = angryAt != null && player.method_5667().equals(angryAt);
            }
            if (!detectedNow) {
                class_243 look = ent.method_5828(1.0f).method_1029();
                class_243 toPlayer = player.method_33571().method_1020(ent.method_33571());
                double dLen = toPlayer.method_1033();
                if (dLen > 0.001) {
                    double dot = look.method_1026(toPlayer = toPlayer.method_1029());
                    boolean facingUs = dot >= 0.94;
                    boolean inRange = dLen <= (ent instanceof class_1588 ? 32.0 : 24.0);
                    detectedNow = facingUs && inRange;
                }
            }
            UUID id = ent.method_5667();
            int ttl = TARGET_TTL.getOrDefault(id, 0);
            if (detectedNow) {
                ttl = 8;
            } else if (ttl > 0) {
                --ttl;
            }
            TARGET_TTL.put(id, ttl);
            targeting = ttl > 0;
            class_243 dv = entCenter.method_1020(pos);
            double angleDeg = Math.toDegrees(Math.atan2(dv.field_1350, dv.field_1352));
            double relDeg = class_3532.method_15338((double)(angleDeg - (double)camYaw - 90.0));
            if (relDeg < -90.0 || relDeg > 90.0 || (relPitch = class_3532.method_15338((double)((elev = Math.toDegrees(Math.atan2(dv.field_1351, horiz = Math.sqrt(dv.field_1352 * dv.field_1352 + dv.field_1350 * dv.field_1350)))) + (double)camPitch))) < -69.0 || relPitch > 69.0) continue;
            double u = (relDeg + 90.0) / 180.0;
            int x = barLeft + 1 + Math.round((float)(u * 180.0));
            double distClamped = Math.min(dist, 64.0);
            int alpha = (int)class_3532.method_15350((double)(255.0 * (1.0 - distClamped / 64.0)), (double)100.0, (double)255.0);
            if (occluded) {
                alpha = (int)((double)alpha * 0.85);
                alpha = Math.max(alpha, 100);
            }
            boolean bl = isBoss = e2 instanceof class_7260 || e2 instanceof class_1528 || e2 instanceof class_1510 || e2 instanceof class_1550;
            int baseColor = mode == 1 ? (isBoss ? 15787074 : (occluded ? 0xFFFFFF : 5682409)) : (occluded ? 0xFF00FF : (isBoss ? 0xFFFF00 : (e2 instanceof class_1548 ? 65280 : (e2 instanceof class_1613 || e2 instanceof class_1627 || e2 instanceof class_1639 ? 65535 : (e2 instanceof class_9254 ? 5597999 : (e2 instanceof class_1642 || e2 instanceof class_1576 || e2 instanceof class_1551 || e2 instanceof class_1590 ? 0xFFC000 : (e2 instanceof class_1545 ? 0xFF7F00 : (e2 instanceof class_1571 ? 0xF0F0FF : (e2 instanceof class_1628 || e2 instanceof class_1549 ? 26214 : (e2 instanceof class_1634 || e2 instanceof class_1593 || e2 instanceof class_8949 ? 0x33CCFF : (e2 instanceof class_4760 || e2 instanceof class_5136 ? 0xFF66CC : (e2 instanceof class_10275 ? 0x663399 : 0xFF0000))))))))))));
            int y0 = barY - 2 + 2;
            int y1 = barY + 3 + 2;
            int pipWidth = isBoss ? 6 : 3;
            int argb = alpha << 24 | baseColor & 0xFFFFFF;
            int __xc = Math.max(0, Math.min(screenW - 1, x));
            boolean __skip = false;
            for (int __d = -1; __d <= 1; ++__d) {
                int __ix = __xc + __d;
                if (__ix < 0 || __ix >= pipUsed.length || !pipUsed[__ix]) continue;
                __skip = true;
                break;
            }
            if (__skip) continue;
            pipUsed[__xc] = true;
            int glowAlpha = (int)((double)alpha * 0.4);
            int glowColor = targeting ? 0xFF0000 : baseColor;
            int glowArgb = glowAlpha << 24 | glowColor;
            int glowX0 = Math.max(0, x - 2);
            int glowX1 = Math.min(screenW, x + pipWidth + 2);
            int glowY0 = Math.max(0, y0 - 2);
            int glowY1 = Math.min(screenH, y1 + 2);
            ctx.method_25294(glowX0, glowY0, glowX1, glowY1, glowArgb);
            int bgX0 = Math.max(0, x - 1);
            int bgX1 = Math.min(screenW, x + pipWidth + 1);
            int bgY0 = Math.max(0, y0 - 1);
            int bgY1 = Math.min(screenH, y1 + 1);
            int bgArgb = alpha << 24 | 0;
            ctx.method_25294(bgX0, bgY0, bgX1, bgY1, bgArgb);
            ctx.method_25294(x, y0, x + pipWidth, y1, argb);
        }
        Iterator<Map.Entry<UUID, Integer>> it = TARGET_TTL.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, Integer> en = it.next();
            if (seenIds.contains(en.getKey()) && en.getValue() > 0) continue;
            it.remove();
        }
    }

    public static void renderOnLocatorBar(class_332 ctx, class_9779 tickCounter) {
        DropBarRenderer.render(ctx, tickCounter);
    }
}

