/*
 * Decompiled with CFR 0.152.
 */
package com.ohacd.doublejump.util;

import com.ohacd.doublejump.util.DoubleJumpData;
import com.ohacd.doublejump.util.IDoubleJumpOwner;
import com.ohacd.doublejump.util.ModConfig;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public final class DoubleJumpHandler {
    public static void performDoubleJump(class_1657 player, float airtime) {
        class_243 dashDir;
        if (player == null || player.method_24828()) {
            return;
        }
        if (!(player instanceof IDoubleJumpOwner)) {
            return;
        }
        IDoubleJumpOwner owner = (IDoubleJumpOwner)player;
        DoubleJumpData data = owner.getDoubleJumpData();
        if (data.hasDoubleJumped) {
            return;
        }
        if (player.method_5715()) {
            return;
        }
        float clamped = Math.max(0.0f, Math.min(ModConfig.MAX_AIRTIME, airtime));
        double airtFrac = clamped / ModConfig.MAX_AIRTIME;
        class_243 vel = player.method_18798();
        class_243 currentHorizontal = new class_243(vel.field_1352, 0.0, vel.field_1350);
        double currentSpeed = currentHorizontal.method_1033();
        class_243 look = player.method_5720().method_1029();
        class_243 horizLook = new class_243(look.field_1352, 0.0, look.field_1350);
        double horizLen = horizLook.method_1033();
        if (horizLen > 1.0E-4) {
            dashDir = horizLook.method_1029();
        } else if (currentSpeed > 1.0E-4) {
            dashDir = currentHorizontal.method_1029();
        } else {
            float yawRad = player.method_36454() * ((float)Math.PI / 180);
            dashDir = new class_243(-Math.sin(yawRad), 0.0, Math.cos(yawRad));
        }
        double upFactor = class_3532.method_15350((double)look.field_1351, (double)0.0, (double)1.0);
        double verticalBias = Math.pow(upFactor, 1.2);
        double horizontalBias = 1.0 - verticalBias;
        horizontalBias = Math.max(horizontalBias, ModConfig.HORIZONTAL_BIAS_FLOOR);
        double biasSum = verticalBias + horizontalBias;
        horizontalBias /= biasSum;
        double airtPower = class_3532.method_15350((double)airtFrac, (double)0.0, (double)1.0);
        double verticalBoost = class_3532.method_16436((double)(verticalBias /= biasSum), (double)ModConfig.VERTICAL_MIN, (double)ModConfig.VERTICAL_MAX);
        verticalBoost += airtPower * ModConfig.AIRTIME_VERTICAL_GAIN;
        if (vel.field_1351 > 0.0) {
            verticalBoost = Math.max(verticalBoost, vel.field_1351 * 0.6);
        }
        double horizontalBoost = class_3532.method_16436((double)horizontalBias, (double)ModConfig.HORIZONTAL_MIN, (double)ModConfig.HORIZONTAL_MAX);
        horizontalBoost += airtPower * ModConfig.AIRTIME_HORIZONTAL_GAIN;
        horizontalBoost += currentSpeed * ModConfig.MOMENTUM_CARRY;
        horizontalBoost = Math.min(horizontalBoost, ModConfig.MAX_HORIZONTAL_SPEED);
        class_243 horizontalImpulse = dashDir.method_1021(horizontalBoost);
        class_243 newVel = new class_243(horizontalImpulse.field_1352, verticalBoost, horizontalImpulse.field_1350);
        double newHorizSpeed = Math.sqrt(newVel.field_1352 * newVel.field_1352 + newVel.field_1350 * newVel.field_1350);
        if (newHorizSpeed > ModConfig.MAX_HORIZONTAL_SPEED) {
            double scale = ModConfig.MAX_HORIZONTAL_SPEED / newHorizSpeed;
            newVel = new class_243(newVel.field_1352 * scale, newVel.field_1351, newVel.field_1350 * scale);
        }
        player.method_18799(newVel);
        player.field_6037 = true;
        player.field_6017 = 0.0;
        DoubleJumpHandler.spawnParticles(player);
        player.method_73183().method_8396(null, player.method_24515(), (class_3414)class_3417.field_14606.comp_349(), class_3419.field_15248, 0.6f, 1.4f);
        data.hasDoubleJumped = true;
        data.resetAirPress();
    }

    private static void spawnParticles(class_1657 player) {
        class_1937 class_19372 = player.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        class_243 look = player.method_5720();
        double offsetX = look.field_1352 * -0.3;
        double offsetZ = look.field_1350 * -0.3;
        double x = player.method_23317() + offsetX;
        double y = player.method_23318() + 0.4;
        double z = player.method_23321() + offsetZ;
        world.method_65096((class_2394)class_2398.field_11207, x, y, z, 6, 0.2, 0.2, 0.2, 0.01);
        world.method_65096((class_2394)class_2398.field_11204, x, y - 0.1, z, 10, 0.15, 0.05, 0.15, 0.02);
    }
}

