/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.merrysnow.mixin;

import com.sighs.merrysnow.Config;
import com.sighs.merrysnow.init.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Biome.class})
public class ClientBiomeMixin {
    @Inject(method={"getPrecipitationAt"}, at={@At(value="HEAD")}, cancellable=true)
    private void noWeather(BlockPos p_265163_, CallbackInfoReturnable<Biome.Precipitation> cir) {
        String id = Utils.getBiomeId((LevelReader)Minecraft.m_91087_().f_91073_, (Biome)this);
        String result = Config.getWeatherModify(id);
        if (result.equals("none")) {
            cir.setReturnValue((Object)Biome.Precipitation.NONE);
        }
    }

    @Redirect(method={"getPrecipitationAt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;coldEnoughToSnow(Lnet/minecraft/core/BlockPos;)Z"))
    private boolean customSnowWeather(Biome biome, BlockPos blockPos) {
        if (((String)Config.ENFORCE_SNOW_WEATHER.get()).equals("default")) {
            String id = Utils.getBiomeId((LevelReader)Minecraft.m_91087_().f_91073_, biome);
            String result = Config.getWeatherModify(id);
            if (result.equals("default")) {
                return biome.m_198904_(blockPos);
            }
            return result.equals("snow");
        }
        return Boolean.parseBoolean((String)Config.ENFORCE_SNOW_WEATHER.get());
    }
}

