/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.client.gui;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.carving.IChiselMode;
import com.leclowndu93150.chisel.carving.ChiselModeRegistry;
import com.leclowndu93150.chisel.client.gui.ButtonChiselMode;
import com.leclowndu93150.chisel.client.gui.PreviewBlockGetter;
import com.leclowndu93150.chisel.inventory.HitechChiselMenu;
import com.leclowndu93150.chisel.inventory.SlotChiselInput;
import com.leclowndu93150.chisel.item.ItemChisel;
import com.leclowndu93150.chisel.network.server.ChiselButtonPayload;
import com.leclowndu93150.chisel.network.server.ChiselModePayload;
import com.leclowndu93150.chisel.network.server.HitechSettingsPayload;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;

public class HitechChiselScreen
extends AbstractContainerScreen<HitechChiselMenu> {
    private static final ResourceLocation TEXTURE = Chisel.id("textures/gui/chiselguihitech.png");
    public static final int GUI_WIDTH = 256;
    public static final int GUI_HEIGHT = 220;
    private static final int PREVIEW_X = 8;
    private static final int PREVIEW_Y = 14;
    private static final int PREVIEW_WIDTH = 74;
    private static final int PREVIEW_HEIGHT = 74;
    private static final int PREVIEW_BUTTON_X = 7;
    private static final int PREVIEW_BUTTON_Y = 91;
    private static final int CHISEL_BUTTON_Y = 113;
    private static final int BUTTON_WIDTH = 76;
    private static final int BUTTON_HEIGHT = 20;
    private static final int HIGHLIGHT_SELECTION_U = 0;
    private static final int HIGHLIGHT_DUPLICATE_U = 18;
    private static final int HIGHLIGHT_TARGET_U = 36;
    private static final int HIGHLIGHT_V = 220;
    private float rotX = 25.0f;
    private float rotY = -45.0f;
    private float zoom = 1.0f;
    private float initRotX;
    private float initRotY;
    private float initZoom;
    private float prevRotX;
    private float prevRotY;
    private double momentumX = 0.0;
    private double momentumY = 0.0;
    private PreviewMode previewMode = PreviewMode.PANEL;
    private boolean autoRotate = true;
    private boolean panelClicked = false;
    private int clickButton;
    private int clickX;
    private int clickY;
    private long lastDragTime;
    private Button chiselButton;

    public HitechChiselScreen(HitechChiselMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.imageWidth = 256;
        this.imageHeight = 220;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.getPreviewModeText(), this::onPreviewModeClick).bounds(this.leftPos + 7, this.topPos + 91, 76, 20).build());
        this.chiselButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"chisel.button.chisel"), this::onChiselClick).bounds(this.leftPos + 7, this.topPos + 113, 76, 20).build(builder -> new Button(this, (Button.Builder)builder){

            public void playDownSound(SoundManager handler) {
            }
        }));
        this.addModeButtons();
        ItemStack chisel = ((HitechChiselMenu)this.menu).getChisel();
        Item item = chisel.getItem();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            this.previewMode = PreviewMode.values()[Math.min(itemChisel.getPreviewType(chisel), PreviewMode.values().length - 1)];
            this.autoRotate = itemChisel.getRotate(chisel);
        }
    }

    private Component getPreviewModeText() {
        return Component.literal((String)"< ").append((Component)Component.translatable((String)("chisel.preview." + this.previewMode.name().toLowerCase()))).append(" >");
    }

    private void addModeButtons() {
        int buttonX = this.leftPos + 7;
        int buttonY = this.topPos + 140;
        int modesAdded = 0;
        ItemStack chisel = ((HitechChiselMenu)this.menu).getChisel();
        IChiselMode currentMode = null;
        Item item = chisel.getItem();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            currentMode = itemChisel.getMode(chisel);
        }
        for (IChiselMode mode : ChiselModeRegistry.INSTANCE.getAllModes()) {
            ItemChisel itemChisel;
            Item item2 = chisel.getItem();
            if (item2 instanceof ItemChisel && !(itemChisel = (ItemChisel)item2).supportsMode((Player)this.minecraft.player, chisel, mode)) continue;
            IChiselMode finalMode = mode;
            ButtonChiselMode button = new ButtonChiselMode(buttonX + modesAdded % 2 * 38, buttonY + modesAdded / 2 * 22, 20, 20, mode, b -> this.onModeButtonClick(finalMode));
            if (mode == currentMode) {
                button.active = false;
            }
            this.addRenderableWidget((GuiEventListener)button);
            ++modesAdded;
        }
    }

    private int getChiselSlot() {
        return ((HitechChiselMenu)this.menu).getHand() == InteractionHand.MAIN_HAND ? this.minecraft.player.getInventory().selected : 40;
    }

    private void onPreviewModeClick(Button button) {
        this.previewMode = PreviewMode.values()[(this.previewMode.ordinal() + 1) % PreviewMode.values().length];
        button.setMessage(this.getPreviewModeText());
        this.saveSettings();
    }

    private void onChiselClick(Button button) {
        int[] slots;
        Slot selection = ((HitechChiselMenu)this.menu).getSelection();
        Slot target = ((HitechChiselMenu)this.menu).getTarget();
        if (selection == null || !selection.hasItem()) {
            return;
        }
        if (target == null || !target.hasItem()) {
            return;
        }
        if (ItemStack.isSameItem((ItemStack)selection.getItem(), (ItemStack)target.getItem())) {
            return;
        }
        if (HitechChiselScreen.hasShiftDown()) {
            List<Slot> duplicates = ((HitechChiselMenu)this.menu).getSelectionDuplicates();
            slots = new int[1 + duplicates.size()];
            slots[0] = selection.index;
            for (int i = 0; i < duplicates.size(); ++i) {
                slots[i + 1] = duplicates.get((int)i).index;
            }
        } else {
            slots = new int[]{selection.index};
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ChiselButtonPayload(slots), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ((HitechChiselMenu)this.menu).chiselSlots(slots);
    }

    private void onModeButtonClick(IChiselMode mode) {
        ItemStack chisel = ((HitechChiselMenu)this.menu).getChisel();
        Item item = chisel.getItem();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setMode(chisel, mode);
            PacketDistributor.sendToServer((CustomPacketPayload)new ChiselModePayload(this.getChiselSlot(), mode), (CustomPacketPayload[])new CustomPacketPayload[0]);
            for (GuiEventListener widget : this.children()) {
                if (!(widget instanceof ButtonChiselMode)) continue;
                ButtonChiselMode modeButton = (ButtonChiselMode)widget;
                modeButton.active = modeButton.getMode() != mode;
            }
        }
    }

    private void saveSettings() {
        ItemStack chisel = ((HitechChiselMenu)this.menu).getChisel();
        Item item = chisel.getItem();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setPreviewType(chisel, this.previewMode.ordinal());
            itemChisel.setRotate(chisel, this.autoRotate);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new HitechSettingsPayload(this.previewMode, this.autoRotate, this.getChiselSlot()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void containerTick() {
        super.containerTick();
        if (this.chiselButton != null) {
            if (HitechChiselScreen.hasShiftDown()) {
                this.chiselButton.setMessage((Component)Component.translatable((String)"chisel.button.chisel_all").withStyle(ChatFormatting.YELLOW));
            } else {
                this.chiselButton.setMessage((Component)Component.translatable((String)"chisel.button.chisel"));
            }
            this.chiselButton.active = ((HitechChiselMenu)this.menu).getSelection() != null && ((HitechChiselMenu)this.menu).getSelection().hasItem() && ((HitechChiselMenu)this.menu).getTarget() != null && ((HitechChiselMenu)this.menu).getTarget().hasItem();
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderSlotHighlights(graphics);
        if (this.autoRotate && this.momentumX == 0.0 && this.momentumY == 0.0 && !this.panelClicked && System.currentTimeMillis() - this.lastDragTime > 2000L) {
            this.rotY = this.initRotY + 2.0f * partialTick;
        }
        if (this.panelClicked && this.clickButton == 0) {
            this.momentumX = this.rotX - this.prevRotX;
            this.momentumY = this.rotY - this.prevRotY;
            this.prevRotX = this.rotX;
            this.prevRotY = this.rotY;
        }
        this.render3DPreview(graphics, partialTick);
    }

    private void renderSlotHighlights(GuiGraphics graphics) {
        Slot target;
        Slot selection = ((HitechChiselMenu)this.menu).getSelection();
        if (selection != null && selection.hasItem()) {
            this.drawSlotHighlight(graphics, selection, 0);
            for (Slot dup : ((HitechChiselMenu)this.menu).getSelectionDuplicates()) {
                this.drawSlotHighlight(graphics, dup, HitechChiselScreen.hasShiftDown() ? 0 : 18);
            }
        }
        if ((target = ((HitechChiselMenu)this.menu).getTarget()) != null && target.hasItem()) {
            this.drawSlotHighlight(graphics, target, 36);
        }
    }

    private void drawSlotHighlight(GuiGraphics graphics, Slot slot, int u) {
        graphics.blit(TEXTURE, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, u, 220, 18, 18);
    }

    private void render3DPreview(GuiGraphics graphics, float partialTick) {
        Item item;
        ItemStack previewItem = ((HitechChiselMenu)this.menu).getTargetItem();
        if (previewItem.isEmpty()) {
            previewItem = ((HitechChiselMenu)this.menu).getSelectionStack();
        }
        if (previewItem == null || previewItem.isEmpty() || !((item = previewItem.getItem()) instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState state = blockItem.getBlock().defaultBlockState();
        int centerX = this.leftPos + 8 + 37;
        int centerY = this.topPos + 14 + 37;
        graphics.enableScissor(this.leftPos + 8, this.topPos + 14, this.leftPos + 8 + 74, this.topPos + 14 + 74);
        if (!this.panelClicked) {
            this.rotX += (float)this.momentumX;
            this.rotY += (float)this.momentumY;
            this.momentumX *= 0.98;
            this.momentumY *= 0.98;
            if (Math.abs(this.momentumX) < 0.05) {
                this.momentumX = 0.0;
            }
            if (Math.abs(this.momentumY) < 0.05) {
                this.momentumY = 0.0;
            }
        }
        this.rotX = Math.max(-90.0f, Math.min(90.0f, this.rotX));
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)centerX, (float)centerY, 100.0f);
        float scale = 30.0f * this.zoom * this.previewMode.getScale();
        poseStack.scale(scale, -scale, scale);
        poseStack.mulPose(Axis.XP.rotationDegrees(this.rotX));
        poseStack.mulPose(Axis.YP.rotationDegrees(this.rotY));
        poseStack.translate((double)(-this.previewMode.getCenterX()), (double)(-this.previewMode.getCenterY()), -0.5);
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        BakedModel model = blockRenderer.getBlockModel(state);
        PreviewBlockGetter blockGetter = new PreviewBlockGetter(state, this.previewMode.getPositions());
        for (int[] pos : this.previewMode.getPositions()) {
            poseStack.pushPose();
            poseStack.translate((float)pos[0], (float)pos[1], (float)pos[2]);
            BlockPos blockPos = new BlockPos(pos[0], pos[1], pos[2]);
            ModelData modelData = model.getModelData((BlockAndTintGetter)blockGetter, blockPos, state, ModelData.EMPTY);
            for (RenderType renderType : model.getRenderTypes(state, this.minecraft.level.random, modelData)) {
                blockRenderer.getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(renderType), state, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY, modelData, renderType);
            }
            poseStack.popPose();
        }
        bufferSource.endBatch();
        poseStack.popPose();
        graphics.disableScissor();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
        MutableComponent previewLabel = Component.translatable((String)"chisel.preview");
        graphics.drawString(this.font, (Component)previewLabel, this.leftPos + 8 + (74 - this.font.width((FormattedText)previewLabel)) / 2, this.topPos + 14 - 9, 0x404040, false);
        this.drawButtonTooltips(graphics, mouseX, mouseY);
    }

    protected void drawButtonTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        for (GuiEventListener widget : this.children()) {
            ButtonChiselMode button;
            if (!(widget instanceof ButtonChiselMode) || !(button = (ButtonChiselMode)widget).isHovered()) continue;
            IChiselMode mode = button.getMode();
            List<MutableComponent> ttLines = List.of(mode.getLocalizedName(), mode.getLocalizedDescription().copy().withStyle(ChatFormatting.GRAY));
            graphics.renderComponentTooltip(this.font, ttLines, mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    protected void renderSlot(GuiGraphics graphics, Slot slot) {
        if (slot == ((HitechChiselMenu)this.menu).getInputSlot()) {
            return;
        }
        super.renderSlot(graphics, slot);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        SlotChiselInput inputSlot = ((HitechChiselMenu)this.menu).getInputSlot();
        if (x == inputSlot.x && y == inputSlot.y) {
            return false;
        }
        return super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isInPreviewArea(mouseX, mouseY)) {
            this.panelClicked = true;
            this.clickButton = button;
            this.clickX = (int)mouseX;
            this.clickY = (int)mouseY;
            this.initRotX = this.rotX;
            this.initRotY = this.rotY;
            this.initZoom = this.zoom;
            this.prevRotX = this.rotX;
            this.prevRotY = this.rotY;
            this.momentumX = 0.0;
            this.momentumY = 0.0;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.panelClicked) {
            this.lastDragTime = System.currentTimeMillis();
            this.panelClicked = false;
            this.initRotX = this.rotX;
            this.initRotY = this.rotY;
            this.initZoom = this.zoom;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.panelClicked) {
            if (this.clickButton == 0) {
                this.rotX = Math.max(-90.0f, Math.min(90.0f, this.initRotX + ((float)mouseY - (float)this.clickY)));
                this.rotY = this.initRotY + ((float)mouseX - (float)this.clickX);
            } else if (this.clickButton == 1) {
                this.zoom = Math.max(0.5f, this.initZoom + ((float)this.clickY - (float)mouseY) * 0.01f);
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isInPreviewArea(mouseX, mouseY)) {
            this.zoom += (float)scrollY * 0.1f;
            this.zoom = Math.max(0.5f, Math.min(3.0f, this.zoom));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private boolean isInPreviewArea(double mouseX, double mouseY) {
        return mouseX >= (double)(this.leftPos + 8) && mouseX < (double)(this.leftPos + 8 + 74) && mouseY >= (double)(this.topPos + 14) && mouseY < (double)(this.topPos + 14 + 74);
    }

    public static enum PreviewMode {
        PANEL(0.5f, 1.5f, 2.0f, new int[][]{{0, 1, 0}, {1, 1, 0}, {2, 1, 0}, {0, 2, 0}, {1, 2, 0}, {2, 2, 0}, {0, 3, 0}, {1, 3, 0}, {2, 3, 0}}),
        HOLLOW(0.5f, 1.5f, 2.0f, new int[][]{{0, 1, 0}, {1, 1, 0}, {2, 1, 0}, {0, 2, 0}, {2, 2, 0}, {0, 3, 0}, {1, 3, 0}, {2, 3, 0}}),
        PLUS(0.6f, 1.0f, 2.0f, new int[][]{{1, 1, 0}, {1, 2, 0}, {2, 2, 0}, {0, 2, 0}, {1, 3, 0}}),
        SINGLE(1.0f, 0.5f, 0.5f, new int[][]{{0, 0, 0}});

        private final float scale;
        private final float centerX;
        private final float centerY;
        private final int[][] positions;

        private PreviewMode(float scale, float centerX, float centerY, int[][] positions) {
            this.scale = scale;
            this.centerX = centerX;
            this.centerY = centerY;
            this.positions = positions;
        }

        public float getScale() {
            return this.scale;
        }

        public float getCenterX() {
            return this.centerX;
        }

        public float getCenterY() {
            return this.centerY;
        }

        public int[][] getPositions() {
            return this.positions;
        }
    }
}

