/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.carving;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.api.carving.ICarvingGroup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class CarvingGroup
implements ICarvingGroup {
    private final ChiselBlockType<?> blockType;

    public CarvingGroup(ChiselBlockType<?> blockType) {
        this.blockType = blockType;
    }

    @Override
    public ResourceLocation getId() {
        return Chisel.id("carving/" + this.blockType.getName());
    }

    @Override
    public String getTranslationKey() {
        return this.blockType.getGroupName() != null ? "chisel.group." + this.blockType.getName() : "block.chisel." + this.blockType.getName();
    }

    @Override
    public TagKey<Item> getItemTag() {
        TagKey<Block> blockTag = this.blockType.getCarvingGroupTag();
        if (blockTag != null) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)blockTag.f_203868_());
        }
        return this.blockType.getItemTags().isEmpty() ? TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)this.getId()) : this.blockType.getItemTags().get(0);
    }

    @Override
    public TagKey<Block> getBlockTag() {
        TagKey<Block> carvingTag = this.blockType.getCarvingGroupTag();
        if (carvingTag != null) {
            return carvingTag;
        }
        return this.blockType.getBlockTags().isEmpty() ? TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)this.getId()) : this.blockType.getBlockTags().get(0);
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.f_12442_;
    }

    public ChiselBlockType<?> getBlockType() {
        return this.blockType;
    }
}

