/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.carving;

import com.google.common.collect.Sets;
import com.leclowndu93150.chisel.api.carving.CarvingUtils;
import com.leclowndu93150.chisel.api.carving.IChiselMode;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ChiselMode implements IChiselMode
{
    SINGLE("Chisel a single block."){

        public Iterable<BlockPos> getCandidates(Player player, BlockPos pos, Direction side) {
            return Collections.singleton(pos);
        }

        @Override
        public AABB getBounds(Direction side) {
            return new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    }
    ,
    PANEL("Chisel a 3x3 square of blocks."){
        private final BlockPos ONE = new BlockPos(1, 1, 1);
        private final BlockPos NEG_ONE = new BlockPos(-1, -1, -1);

        public Iterable<BlockPos> getCandidates(Player player, BlockPos pos, Direction side) {
            if (side.m_122421_() == Direction.AxisDirection.NEGATIVE) {
                side = side.m_122424_();
            }
            Vec3i offset = side.m_122436_();
            return ChiselMode.filteredIterable(BlockPos.m_121990_((BlockPos)this.NEG_ONE.m_121955_(offset).m_121955_((Vec3i)pos), (BlockPos)this.ONE.m_121996_(offset).m_121955_((Vec3i)pos)), player.m_9236_(), player.m_9236_().m_8055_(pos));
        }

        @Override
        public AABB getBounds(Direction side) {
            return switch (side.m_122434_()) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> new AABB(0.0, -1.0, -1.0, 1.0, 2.0, 2.0);
                case Direction.Axis.Y -> new AABB(-1.0, 0.0, -1.0, 2.0, 1.0, 2.0);
                case Direction.Axis.Z -> new AABB(-1.0, -1.0, 0.0, 2.0, 2.0, 1.0);
            };
        }
    }
    ,
    COLUMN("Chisel a 3x1 column of blocks."){

        public Iterable<BlockPos> getCandidates(Player player, BlockPos pos, Direction side) {
            int facing = Mth.m_14107_((double)((double)(player.m_146908_() * 4.0f / 360.0f) + 0.5)) & 3;
            LinkedHashSet<BlockPos> ret = new LinkedHashSet<BlockPos>();
            for (int i = -1; i <= 1; ++i) {
                if (side != Direction.DOWN && side != Direction.UP) {
                    ret.add(pos.m_6630_(i));
                    continue;
                }
                if (facing == 0 || facing == 2) {
                    ret.add(pos.m_122020_(i));
                    continue;
                }
                ret.add(pos.m_122030_(i));
            }
            return ChiselMode.filteredIterable(ret.stream(), player.m_9236_(), player.m_9236_().m_8055_(pos));
        }

        @Override
        public AABB getBounds(Direction side) {
            return PANEL.getBounds(side);
        }

        @Override
        public long[] getCacheState(BlockPos origin, Direction side) {
            return new long[]{origin.m_121878_(), side.ordinal(), ChiselMode.getPlayerDirection()};
        }
    }
    ,
    ROW("Chisel a 1x3 row of blocks."){

        public Iterable<BlockPos> getCandidates(Player player, BlockPos pos, Direction side) {
            int facing = Mth.m_14107_((double)((double)(player.m_146908_() * 4.0f / 360.0f) + 0.5)) & 3;
            LinkedHashSet<BlockPos> ret = new LinkedHashSet<BlockPos>();
            for (int i = -1; i <= 1; ++i) {
                if (side != Direction.DOWN && side != Direction.UP) {
                    if (side == Direction.EAST || side == Direction.WEST) {
                        ret.add(pos.m_122020_(i));
                        continue;
                    }
                    ret.add(pos.m_122030_(i));
                    continue;
                }
                if (facing == 0 || facing == 2) {
                    ret.add(pos.m_122030_(i));
                    continue;
                }
                ret.add(pos.m_122020_(i));
            }
            return ChiselMode.filteredIterable(ret.stream(), player.m_9236_(), player.m_9236_().m_8055_(pos));
        }

        @Override
        public AABB getBounds(Direction side) {
            return PANEL.getBounds(side);
        }

        @Override
        public long[] getCacheState(BlockPos origin, Direction side) {
            return COLUMN.getCacheState(origin, side);
        }
    }
    ,
    CONTIGUOUS("Chisel an area of alike blocks, extending 10 blocks in any direction."){

        @Override
        public Iterable<? extends BlockPos> getCandidates(Player player, BlockPos pos, Direction side) {
            return () -> ChiselMode.getContiguousIterator(pos, player.m_9236_(), Direction.values());
        }

        @Override
        public AABB getBounds(Direction side) {
            int r = 10;
            return new AABB((double)(-r - 1), (double)(-r - 1), (double)(-r - 1), (double)(r + 2), (double)(r + 2), (double)(r + 2));
        }
    }
    ,
    CONTIGUOUS_2D("Contiguous (2D)", "Chisel an area of alike blocks, extending 10 blocks along the plane of the current side."){

        @Override
        public Iterable<? extends BlockPos> getCandidates(Player player, BlockPos pos, Direction side) {
            Direction[] directions = (Direction[])Arrays.stream(Direction.values()).filter(d -> d != side && d != side.m_122424_()).toArray(Direction[]::new);
            return () -> ChiselMode.getContiguousIterator(pos, player.m_9236_(), directions);
        }

        @Override
        public AABB getBounds(Direction side) {
            int r = 10;
            return switch (side.m_122434_()) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> new AABB(0.0, (double)(-r - 1), (double)(-r - 1), 1.0, (double)(r + 2), (double)(r + 2));
                case Direction.Axis.Y -> new AABB((double)(-r - 1), 0.0, (double)(-r - 1), (double)(r + 2), 1.0, (double)(r + 2));
                case Direction.Axis.Z -> new AABB((double)(-r - 1), (double)(-r - 1), 0.0, (double)(r + 2), (double)(r + 2), 1.0);
            };
        }
    };

    public static final int CONTIGUOUS_RANGE = 10;
    private final String description;
    @Nullable
    private final String displayName;

    private ChiselMode(String description) {
        this(null, description);
    }

    private ChiselMode(String displayName, String description) {
        this.displayName = displayName;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    private static Iterable<BlockPos> filteredIterable(Stream<BlockPos> source, Level world, BlockState state) {
        return source.filter(p -> world.m_8055_(p) == state)::iterator;
    }

    private static long getPlayerDirection() {
        if (Minecraft.m_91087_().f_91074_ != null) {
            return Minecraft.m_91087_().f_91074_.m_6350_().ordinal();
        }
        return 0L;
    }

    private static Iterator<BlockPos> getContiguousIterator(final BlockPos origin, final Level world, final Direction[] directionsToSearch) {
        final BlockState state = world.m_8055_(origin);
        return new Iterator<BlockPos>(){
            private final Set<BlockPos> seen;
            private final Queue<Node> search;
            {
                this.seen = Sets.newHashSet((Object[])new BlockPos[]{origin});
                this.search = new ArrayDeque<Node>();
                this.search.add(new Node(origin, 0));
            }

            @Override
            public boolean hasNext() {
                return !this.search.isEmpty();
            }

            @Override
            public BlockPos next() {
                Node ret = this.search.poll();
                if (ret != null && ret.distance() < 10) {
                    for (Direction face : directionsToSearch) {
                        BlockPos bp = ret.pos().m_121945_(face);
                        BlockState newState = world.m_8055_(bp);
                        if (!this.seen.contains(bp) && newState == state) {
                            for (Direction obscureCheck : Direction.values()) {
                                if (newState.m_60659_((BlockGetter)world, bp, obscureCheck.m_122424_(), SupportType.FULL)) continue;
                                this.search.offer(new Node(bp, ret.distance() + 1));
                                break;
                            }
                        }
                        this.seen.add(bp);
                    }
                }
                return ret != null ? ret.pos() : origin;
            }
        };
    }

    public static void registerAll() {
        for (ChiselMode mode : ChiselMode.values()) {
            CarvingUtils.getModeRegistry().registerMode(mode);
        }
    }

    private record Node(BlockPos pos, int distance) {
    }
}

