/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.leclowndu93150.chisel.client.util.ClientUtil;
import com.leclowndu93150.chisel.item.ItemOffsetTool;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="chisel", value={Dist.CLIENT})
public class OffsetToolRenderer {
    @SubscribeEvent
    public static void onBlockHighlight(RenderHighlightEvent.Block event) {
        boolean holdingOffsetTool;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        boolean bl = holdingOffsetTool = !mainHand.m_41619_() && mainHand.m_41720_() instanceof ItemOffsetTool || !offHand.m_41619_() && offHand.m_41720_() instanceof ItemOffsetTool;
        if (!holdingOffsetTool) {
            return;
        }
        BlockHitResult target = event.getTarget();
        Direction face = target.m_82434_();
        BlockPos pos = target.m_82425_();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource bufferSource = event.getMultiBufferSource();
        poseStack.m_85836_();
        float x = Math.max(0, face.m_122429_());
        float y = Math.max(0, face.m_122430_());
        float z = Math.max(0, face.m_122431_());
        Vec3 viewport = mc.f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_(-viewport.f_82479_, -viewport.f_82480_, -viewport.f_82481_);
        poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        VertexConsumer linesBuf = bufferSource.m_6299_(RenderType.m_110504_());
        if (face.m_122429_() != 0) {
            linesBuf.m_252986_(mat, x, 0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            linesBuf.m_252986_(mat, x, 1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            linesBuf.m_252986_(mat, x, 1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            linesBuf.m_252986_(mat, x, 0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        } else if (face.m_122430_() != 0) {
            linesBuf.m_252986_(mat, 0.0f, y, 0.0f).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            linesBuf.m_252986_(mat, 1.0f, y, 1.0f).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            linesBuf.m_252986_(mat, 1.0f, y, 0.0f).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            linesBuf.m_252986_(mat, 0.0f, y, 1.0f).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        } else {
            linesBuf.m_252986_(mat, 0.0f, 0.0f, z).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            linesBuf.m_252986_(mat, 1.0f, 1.0f, z).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            linesBuf.m_252986_(mat, 1.0f, 0.0f, z).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            linesBuf.m_252986_(mat, 0.0f, 1.0f, z).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        Vec3 hit = target.m_82450_();
        Vec3 localHit = hit.m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        Direction moveDir = OffsetToolRenderer.getMoveDir(face, localHit);
        VertexConsumer triBuf = bufferSource.m_6299_(ClientUtil.OFFSET_OVERLAY);
        int clampedX = Math.max(0, moveDir.m_122429_());
        int clampedY = Math.max(0, moveDir.m_122430_());
        int clampedZ = Math.max(0, moveDir.m_122431_());
        boolean isX = moveDir.m_122429_() != 0;
        boolean isY = moveDir.m_122430_() != 0;
        boolean isZ = moveDir.m_122431_() != 0;
        int alpha = 85;
        float offset = 0.001f;
        if (face.m_122429_() != 0) {
            float xOff = x + (face.m_122429_() > 0 ? offset : -offset);
            triBuf.m_252986_(mat, xOff, 0.5f, 0.5f).m_6122_(255, 255, 255, alpha).m_5752_();
            triBuf.m_252986_(mat, xOff, isY ? (float)clampedY : 0.0f, isZ ? (float)clampedZ : 0.0f).m_6122_(255, 255, 255, alpha).m_5752_();
            triBuf.m_252986_(mat, xOff, isY ? (float)clampedY : 1.0f, isZ ? (float)clampedZ : 1.0f).m_6122_(255, 255, 255, alpha).m_5752_();
        } else if (face.m_122430_() != 0) {
            float yOff = y + (face.m_122430_() > 0 ? offset : -offset);
            triBuf.m_252986_(mat, 0.5f, yOff, 0.5f).m_6122_(255, 255, 255, alpha).m_5752_();
            triBuf.m_252986_(mat, isX ? (float)clampedX : 0.0f, yOff, isZ ? (float)clampedZ : 0.0f).m_6122_(255, 255, 255, alpha).m_5752_();
            triBuf.m_252986_(mat, isX ? (float)clampedX : 1.0f, yOff, isZ ? (float)clampedZ : 1.0f).m_6122_(255, 255, 255, alpha).m_5752_();
        } else {
            float zOff = z + (face.m_122431_() > 0 ? offset : -offset);
            triBuf.m_252986_(mat, 0.5f, 0.5f, zOff).m_6122_(255, 255, 255, alpha).m_5752_();
            triBuf.m_252986_(mat, isX ? (float)clampedX : 0.0f, isY ? (float)clampedY : 0.0f, zOff).m_6122_(255, 255, 255, alpha).m_5752_();
            triBuf.m_252986_(mat, isX ? (float)clampedX : 1.0f, isY ? (float)clampedY : 1.0f, zOff).m_6122_(255, 255, 255, alpha).m_5752_();
        }
        poseStack.m_85849_();
    }

    private static Direction getMoveDir(Direction face, Vec3 hitVec) {
        HashMap map = Maps.newHashMap();
        if (face.m_122429_() != 0) {
            OffsetToolRenderer.fillMap(map, hitVec.f_82481_ - (double)((int)hitVec.f_82481_), hitVec.f_82480_ - (double)((int)hitVec.f_82480_), Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH);
        } else if (face.m_122430_() != 0) {
            OffsetToolRenderer.fillMap(map, hitVec.f_82479_ - (double)((int)hitVec.f_82479_), hitVec.f_82481_ - (double)((int)hitVec.f_82481_), Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
        } else if (face.m_122431_() != 0) {
            OffsetToolRenderer.fillMap(map, hitVec.f_82479_ - (double)((int)hitVec.f_82479_), hitVec.f_82480_ - (double)((int)hitVec.f_82480_), Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST);
        }
        ArrayList keys = Lists.newArrayList(map.keySet());
        Collections.sort(keys);
        return map.isEmpty() ? Direction.DOWN : (Direction)map.get(keys.get(0));
    }

    private static void fillMap(Map<Double, Direction> map, double x, double y, Direction ... dirs) {
        map.put(Line2D.ptLineDistSq(0.0, 0.0, 1.0, 0.0, x, y), dirs[0]);
        map.put(Line2D.ptLineDistSq(0.0, 1.0, 1.0, 1.0, x, y), dirs[1]);
        map.put(Line2D.ptLineDistSq(0.0, 0.0, 0.0, 1.0, x, y), dirs[2]);
        map.put(Line2D.ptLineDistSq(1.0, 0.0, 1.0, 1.0, x, y), dirs[3]);
    }
}

