/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.compat.kubejs;

import dev.latvian.mods.kubejs.typings.Info;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class CarvingGroupBuilder {
    private final ResourceLocation groupId;
    private final Set<ResourceLocation> blocksToAdd = new LinkedHashSet<ResourceLocation>();
    private final Set<ResourceLocation> blocksToRemove = new HashSet<ResourceLocation>();
    private boolean clearExisting = false;
    private boolean replace = false;

    public CarvingGroupBuilder(ResourceLocation groupId) {
        this.groupId = groupId;
    }

    @Info(value="Add a block to this carving group")
    public CarvingGroupBuilder add(String blockId) {
        ResourceLocation id = this.parseBlockId(blockId);
        this.blocksToAdd.add(id);
        this.blocksToRemove.remove(id);
        return this;
    }

    @Info(value="Add multiple blocks to this carving group. Pass an array like ['minecraft:stone', 'minecraft:andesite']")
    public CarvingGroupBuilder addAll(Object[] blockIds) {
        for (Object blockId : blockIds) {
            this.add(blockId.toString());
        }
        return this;
    }

    @Info(value="Remove a block from this carving group")
    public CarvingGroupBuilder remove(String blockId) {
        ResourceLocation id = this.parseBlockId(blockId);
        this.blocksToRemove.add(id);
        this.blocksToAdd.remove(id);
        return this;
    }

    @Info(value="Remove multiple blocks from this carving group. Pass an array like ['minecraft:stone', 'minecraft:andesite']")
    public CarvingGroupBuilder removeAll(Object[] blockIds) {
        for (Object blockId : blockIds) {
            this.remove(blockId.toString());
        }
        return this;
    }

    @Info(value="Clear all existing blocks from this group before adding new ones")
    public CarvingGroupBuilder clear() {
        this.clearExisting = true;
        return this;
    }

    @Info(value="Replace the entire group with the specified blocks (equivalent to clear().addAll(...))")
    public CarvingGroupBuilder replace(Object[] blockIds) {
        this.replace = true;
        this.clearExisting = true;
        this.blocksToAdd.clear();
        return this.addAll(blockIds);
    }

    public ResourceLocation getGroupId() {
        return this.groupId;
    }

    public Set<ResourceLocation> getBlocksToAdd() {
        return Collections.unmodifiableSet(this.blocksToAdd);
    }

    public Set<ResourceLocation> getBlocksToRemove() {
        return Collections.unmodifiableSet(this.blocksToRemove);
    }

    public boolean shouldClearExisting() {
        return this.clearExisting;
    }

    public boolean isReplace() {
        return this.replace;
    }

    private ResourceLocation parseBlockId(String id) {
        if (id.contains(":")) {
            return new ResourceLocation(id);
        }
        return new ResourceLocation("minecraft", id);
    }
}

